using System;
using System.Collections.Generic;
using System.Text;

namespace Emulation.Cpu.Z80
{
    public sealed partial class Z80
    {
        private int[] cc_op = 
        {
             4,10, 7, 6, 4, 4, 7, 4, 4,11, 7, 6, 4, 4, 7, 4,
             8,10, 7, 6, 4, 4, 7, 4,12,11, 7, 6, 4, 4, 7, 4,
             7,10,16, 6, 4, 4, 7, 4, 7,11,16, 6, 4, 4, 7, 4,
             7,10,13, 6,11,11,10, 4, 7,11,13, 6, 4, 4, 7, 4,
             4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
             4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
             4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
             7, 7, 7, 7, 7, 7, 4, 7, 4, 4, 4, 4, 4, 4, 7, 4,
             4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
             4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
             4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
             4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
             5,10,10,10,10,11, 7,11, 5,10,10, 0,10,17, 7,11,
             5,10,10,11,10,11, 7,11, 5, 4,10,11,10, 0, 7,11,
             5,10,10,19,10,11, 7,11, 5, 4,10, 4,10, 0, 7,11,
             5,10,10, 4,10,11, 7,11, 5, 6,10, 4,10, 0, 7,11
        };

        private int[] cc_cb = 
        {
             8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
             8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
             8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
             8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
             8, 8, 8, 8, 8, 8,12, 8, 8, 8, 8, 8, 8, 8,12, 8,
             8, 8, 8, 8, 8, 8,12, 8, 8, 8, 8, 8, 8, 8,12, 8,
             8, 8, 8, 8, 8, 8,12, 8, 8, 8, 8, 8, 8, 8,12, 8,
             8, 8, 8, 8, 8, 8,12, 8, 8, 8, 8, 8, 8, 8,12, 8,
             8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
             8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
             8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
             8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
             8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
             8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
             8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
             8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8
        };

        private int[] cc_ed = 
        {
             8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
             8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
             8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
             8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
            12,12,15,20, 8,14, 8, 9,12,12,15,20, 8,14, 8, 9,
            12,12,15,20, 8,14, 8, 9,12,12,15,20, 8,14, 8, 9,
            12,12,15,20, 8,14, 8,18,12,12,15,20, 8,14, 8,18,
            12,12,15,20, 8,14, 8, 8,12,12,15,20, 8,14, 8, 8,
             8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
             8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
            16,16,16,16, 8, 8, 8, 8,16,16,16,16, 8, 8, 8, 8,
            16,16,16,16, 8, 8, 8, 8,16,16,16,16, 8, 8, 8, 8,
             8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
             8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
             8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
             8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8
        };

        private int[] cc_xy = 
        {
             4, 4, 4, 4, 4, 4, 4, 4, 4,15, 4, 4, 4, 4, 4, 4,
             4, 4, 4, 4, 4, 4, 4, 4, 4,15, 4, 4, 4, 4, 4, 4,
             4,14,20,10, 9, 9, 9, 4, 4,15,20,10, 9, 9, 9, 4,
             4, 4, 4, 4,23,23,19, 4, 4,15, 4, 4, 4, 4, 4, 4,
             4, 4, 4, 4, 9, 9,19, 4, 4, 4, 4, 4, 9, 9,19, 4,
             4, 4, 4, 4, 9, 9,19, 4, 4, 4, 4, 4, 9, 9,19, 4,
             9, 9, 9, 9, 9, 9,19, 9, 9, 9, 9, 9, 9, 9,19, 9,
            19,19,19,19,19,19, 4,19, 4, 4, 4, 4, 9, 9,19, 4,
             4, 4, 4, 4, 9, 9,19, 4, 4, 4, 4, 4, 9, 9,19, 4,
             4, 4, 4, 4, 9, 9,19, 4, 4, 4, 4, 4, 9, 9,19, 4,
             4, 4, 4, 4, 9, 9,19, 4, 4, 4, 4, 4, 9, 9,19, 4,
             4, 4, 4, 4, 9, 9,19, 4, 4, 4, 4, 4, 9, 9,19, 4,
             4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 4, 4, 4, 4,
             4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
             4,14, 4,23, 4,15, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4,
             4, 4, 4, 4, 4, 4, 4, 4, 4,10, 4, 4, 4, 4, 4, 4
        };

        private int[] cc_xycb = 
        {
            23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
            23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
            23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
            23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
            20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
            20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
            20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
            20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
            23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
            23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
            23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
            23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
            23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
            23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
            23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
            23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23
        };

        /* extra cycles if jr/jp/call taken and 'interrupt latency' on rst 0-7 */
        private int[] cc_ex = 
        {
             0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
             5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* DJNZ */
             5, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0,	/* JR NZ/JR Z */
             5, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0,	/* JR NC/JR C */
             0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
             0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
             0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
             0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
             0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
             0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
             0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
             5, 5, 5, 5, 0, 0, 0, 0, 5, 5, 5, 5, 0, 0, 0, 0,	/* LDIR/CPIR/INIR/OTIR LDDR/CPDR/INDR/OTDR */
             6, 0, 0, 0, 7, 0, 0, 2, 6, 0, 0, 0, 7, 0, 0, 2,
             6, 0, 0, 0, 7, 0, 0, 2, 6, 0, 0, 0, 7, 0, 0, 2,
             6, 0, 0, 0, 7, 0, 0, 2, 6, 0, 0, 0, 7, 0, 0, 2,
             6, 0, 0, 0, 7, 0, 0, 2, 6, 0, 0, 0, 7, 0, 0, 2
        };

        private int[] P =
            {
              4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4,
              0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0,
              0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0,
              4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4,
              0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0,
              4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4,
              4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4,
              0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0,
              0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0,
              4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4,
              4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4,
              0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0,
              4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4,
              0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0,
              0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0,
              4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4
            };

        private int[] SZ = new int[256];	    /* zero and sign flags */
        private int[] SZ_BIT = new int[256];	/* zero, sign and parity/overflow (=zero) flags for BIT opcode */
        private int[] SZP = new int[256];		/* zero, sign and parity flags */
        private int[] SZHV_inc = new int[256];  /* zero, sign, half carry and overflow flags INC r8 */
        private int[] SZHV_dec = new int[256];  /* zero, sign, half carry and overflow flags DEC r8 */



        private void InitializeTables()
        {
            int i, p;

            for (i = 0; i < 256; i++)
            {
                p = 0;
                if ((i & 0x01) != 0) ++p;
                if ((i & 0x02) != 0) ++p;
                if ((i & 0x04) != 0) ++p;
                if ((i & 0x08) != 0) ++p;
                if ((i & 0x10) != 0) ++p;
                if ((i & 0x20) != 0) ++p;
                if ((i & 0x40) != 0) ++p;
                if ((i & 0x80) != 0) ++p;
                SZ[i] = (i != 0) ? i & SF : ZF;
                SZ[i] |= (i & (YF | XF));		/* undocumented flag bits 5+3 */
                SZ_BIT[i] = (i != 0) ? i & SF : ZF | PF;
                SZ_BIT[i] |= (i & (YF | XF));	/* undocumented flag bits 5+3 */
                SZP[i] = SZ[i] | (((p & 1) != 0) ? 0 : PF);
                SZHV_inc[i] = SZ[i];
                if (i == 0x80) SZHV_inc[i] |= VF;
                if ((i & 0x0f) == 0x00) SZHV_inc[i] |= HF;
                SZHV_dec[i] = SZ[i] | NF;
                if (i == 0x7f) SZHV_dec[i] |= VF;
                if ((i & 0x0f) == 0x0f) SZHV_dec[i] |= HF;
            }
        }
    }
}
