﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Media.Imaging;

namespace SilverlightSpecNix
{
    public class EditableBitmapImage
    {
        readonly int mWidth, mHeight;
        BitmapImage mBitmapImage;
        byte[] mBuffer;

        public BitmapImage BitmapImage
        {
            get { return mBitmapImage; }
        }

        public EditableBitmapImage(int width, int height)
        {
            mWidth = width;
            mHeight = height;
            mBuffer = new byte[(4 * width + 1) * height];
            mBitmapImage = new BitmapImage();
        }

        public void WriteData(UInt32[] buffer)
        {
            int rowLength = 4 * mWidth + 1;

            for (int y = 0; y < mHeight; y++)
            {
                for (int x = 0; x < mWidth; x++)
                {
                    int start = rowLength * y + x * 4 + 1;
                    mBuffer[start + 0] = (byte)(buffer[y * mWidth + x] >> 16);
                    mBuffer[start + 1] = (byte)(buffer[y * mWidth + x] >> 8);
                    mBuffer[start + 2] = (byte)(buffer[y * mWidth + x] >> 0);
                    mBuffer[start + 3] = (byte)(buffer[y * mWidth + x] >> 24);
                }
            }
            mBitmapImage.SetSource(PngEncoder.Encode(mBuffer, mWidth, mHeight));
        }
    }
}
