﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.IO;
using System.IO.IsolatedStorage;

namespace SilverlightSpecNix
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
            InitializeComponent();

            App.Model.IsRunningChangedAsync += delegate
            {
                Dispatcher.BeginInvoke(() => { ChangeUIState(App.Model.IsRunning); });
            };
        }

        private void mUploadButton_Click(object sender, RoutedEventArgs e)
        {            
            //Ensure enough space is available
            IsolatedStorageFile store = IsolatedStorageFile.GetUserStoreForApplication();            
            if (store.AvailableFreeSpace <= 128 * 1024)
            {
                if (store.IncreaseQuotaTo(store.AvailableFreeSpace + 5 * 1024 * 1024) == false)
                {
                    if (MessageBox.Show("Not enough free space", "Error", MessageBoxButton.OK) == MessageBoxResult.OK)
                        return;
                }
            }
            //
            OpenFileDialog openFileDialog = new OpenFileDialog()
            {
                Filter = "Supported files (.z80, .sna, .rzx)|*.z80;*.sna;*.rzx",
                Multiselect = false,               

            };
            if (openFileDialog.ShowDialog() == true)
            {                
                using (BinaryReader reader = new BinaryReader(openFileDialog.File.OpenRead()))
                {                    
                    using (BinaryWriter writer =
                        new BinaryWriter(IsolatedStorageFile.GetUserStoreForApplication().CreateFile(openFileDialog.File.Name)))
                    {
                        writer.Write(reader.ReadBytes((int)openFileDialog.File.Length));
                    }
                }
                App.Model.RefreshFiles();
            }
        }

        private void mDeleteButton_Click(object sender, RoutedEventArgs e)
        {
            SpecNixFileInfo sfi = mDataGrid.SelectedItem as SpecNixFileInfo;
            if (sfi != null)
            {
                if (System.Windows.Browser.HtmlPage.Window.Confirm(string.Format("¿Are you sure?")))
                {
                    IsolatedStorageFile store = IsolatedStorageFile.GetUserStoreForApplication();
                    if (store.FileExists(sfi.Path) == true)
                    {
                        IsolatedStorageFile.GetUserStoreForApplication().DeleteFile(sfi.Path);
                    }
                    App.Model.RefreshFiles();
                }
            }            
        }

        private void mDataGrid_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            mRunButton.IsEnabled = mDeleteButton.IsEnabled = mDataGrid.SelectedItem != null;
        }

        private void mRunButton_Click(object sender, RoutedEventArgs e)
        {
            SpecNixFileInfo sfi = mDataGrid.SelectedItem as SpecNixFileInfo;
            if (sfi != null)
            {
                App.Model.Run(sfi);
            }
        }        

        void ChangeUIState(bool isGameRunning)
        {
            mDataGrid.IsEnabled = !isGameRunning;
            mDataGrid.Visibility = isGameRunning ? Visibility.Collapsed : Visibility.Visible;
            mTitleTextBlock.Visibility = isGameRunning ? Visibility.Collapsed : Visibility.Visible;
            //
            mToolBar.Visibility = isGameRunning ? Visibility.Collapsed : Visibility.Visible;
            mLoadAndRunButton.IsEnabled = mUploadButton.IsEnabled = !isGameRunning;
            mDeleteButton.IsEnabled = mRunButton.IsEnabled = !isGameRunning && mDataGrid.SelectedItem != null;
            mDisplayImage.Visibility = isGameRunning ? Visibility.Visible : Visibility.Collapsed;
            Focus();
        }

        private void UserControl_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Escape && App.Model.IsRunning)
            {
                App.Model.Stop();
                //ChangeUIState(false);
            }
            App.Model.KeyDown(e.Key);
        }

        private void UserControl_KeyUp(object sender, KeyEventArgs e)
        {
            App.Model.KeyUp(e.Key);
        }

        private void mFullScreenButton_Click(object sender, RoutedEventArgs e)
        {
            App.Current.Host.Content.IsFullScreen = true;
        }

        private void mLoadAndRunButton_Click(object sender, RoutedEventArgs e)
        {
            //ChangeUIState(true);
            App.Model.Run(null);
        }
    }
}
