/* ////////////////////////////////////////////////////////////////////////////
 * This file implements the keyboard of the spectrum
 * 
 * Written by: Pedro Anuarbe Corts
 * ////////////////////////////////////////////////////////////////////////////
 * CREDITS:
 * 
 * By now, this file is a copy&paste of the equivalent file of:
 *  Emulador en Java de un Sinclair ZX Spectrum 48K v1.0B by Alberto Snchez Terrn
 * 
 * ////////////////////////////////////////////////////////////////////////////
 * LICENSE: Microsoft Permissive License (Ms-PL)
 *
 *     
 * This license governs use of the accompanying software. If you use the software,
 * you accept this license. If you do not accept the license, do not use the software.
 *
 * 1. Definitions
 *
 * The terms reproduce, reproduction, derivative works, and distribution 
 * have the same meaning here as under U.S. copyright law.
 *
 * A contribution is the original software, or any additions or changes to the software.
 *
 * A contributor is any person that distributes its contribution under this license.
 * 
 * Licensed patents are a contributors patent claims that read directly on its contribution.
 *
 *
 * 2. Grant of Rights
 *
 * (A) Copyright Grant- Subject to the terms of this license, including the license conditions
 * and limitations in section 3, each contributor grants you a non-exclusive,
 * worldwide, royalty-free copyright license to reproduce its contribution, prepare derivative
 * works of its contribution, and distribute its contribution or any derivative works that you create.
 *
 * (B) Patent Grant- Subject to the terms of this license, including the license conditions and
 * limitations in section 3, each contributor grants you a non-exclusive, worldwide, 
 * royalty-free license under its licensed patents to make, have made, use, sell, offer for sale,
 * import, and/or otherwise dispose of its contribution in the software or derivative works of the
 * contribution in the software.
 *
 *
 * 3. Conditions and Limitations
 *
 * (A) No Trademark License- This license does not grant you rights to use any contributors name,
 * logo, or trademarks.
 *
 * (B) If you bring a patent claim against any contributor over patents that you claim are infringed
 * by the software, your patent license from such contributor to the software ends automatically.
 *
 * (C) If you distribute any portion of the software, you must retain all copyright, patent, trademark,
 * and attribution notices that are present in the software.
 *
 * (D) If you distribute any portion of the software in source code form, you may do so only under this
 * license by including a complete copy of this license with your distribution. If you distribute any portion
 * of the software in compiled or object code form, you may only do so under a license that complies with this license.
 *
 *(E) The software is licensed as-is. You bear the risk of using it. The contributors give no express warranties,
 * guarantees or conditions. You may have additional consumer rights under your local laws which this license 
 * cannot change. To the extent permitted under your local laws, the contributors exclude the implied warranties
 * of merchantability, fitness for a particular purpose and non-infringement.
 * ////////////////////////////////////////////////////////////////////////////
 */


using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Input;

namespace Emulation.Computers.ZxSpectrum
{
    public class Keyboard
    {
        private int[] matrix;

        //Para ver si se ha pulsado la tecla Alt
        private bool P_Alt = false;
        //Constantes para la matriz del teclado
        private const int T0 = 0x01;
	    private const int T1 = 0x02;
	    private const int T2 = 0x04;
	    private const int T3 = 0x08;
	    private const int T4 = 0x10;

        public Keyboard()
        {
            matrix = new int[8];
            for (int i = 0; i < 8; ++i) matrix[i] = int.MaxValue;
        }

        public int[] Matrix { get { return matrix; } }

        public void OnKeyDown(Key key)
        {
            switch (key)
            {
                case Key.Back: { matrix[4] &= ~T0; matrix[0] &= ~T0; break; }   //BACKSPACE
                case Key.Enter:
                    {
                        matrix[6] &= ~T0;
                        if (P_Alt)
                        {
                            //Completa();
                        }
                        break;
                    }   //ENTER
                case Key.Shift: { matrix[0] &= ~T0; break; }   //SHIFT
                case Key.Ctrl: { matrix[7] &= ~T1; break; }   //Ctrl
                case Key.Alt: { P_Alt = true; break; }   //Alt
                case Key.Space: { matrix[7] &= ~T0; break; }   //Espacio
                case Key.Left: { matrix[3] &= ~T4; break; }   //IZDA
                case Key.Up: { matrix[4] &= ~T3; break; }   //ARRIBA
                case Key.Right: { matrix[4] &= ~T2; break; }   //DCHA
                case Key.Down: { matrix[4] &= ~T4; break; }   //ABAJO
                case Key.D0: { matrix[4] &= ~T0; break; }   //0
                case Key.D1: { matrix[3] &= ~T0; break; }   //1
                case Key.D2: { matrix[3] &= ~T1; break; }   //2
                case Key.D3: { matrix[3] &= ~T2; break; }   //3
                case Key.D4: { matrix[3] &= ~T3; break; }   //4
                case Key.D5: { matrix[3] &= ~T4; break; }   //5
                case Key.D6: { matrix[4] &= ~T4; break; }   //6
                case Key.D7: { matrix[4] &= ~T3; break; }   //7
                case Key.D8: { matrix[4] &= ~T2; break; }   //8
                case Key.D9: { matrix[4] &= ~T1; break; }   //9
                case Key.A: { matrix[1] &= ~T0; break; }   //A
                case Key.B: { matrix[7] &= ~T4; break; }   //B
                case Key.C: { matrix[0] &= ~T3; break; }   //C
                case Key.D: { matrix[1] &= ~T2; break; }   //D
                case Key.E: { matrix[2] &= ~T2; break; }   //E
                case Key.F: { matrix[1] &= ~T3; break; }   //F
                case Key.G: { matrix[1] &= ~T4; break; }   //G
                case Key.H: { matrix[6] &= ~T4; break; }   //H
                case Key.I: { matrix[5] &= ~T2; break; }   //I
                case Key.J: { matrix[6] &= ~T3; break; }   //J
                case Key.K: { matrix[6] &= ~T2; break; }   //K
                case Key.L: { matrix[6] &= ~T1; break; }   //L
                case Key.M: { matrix[7] &= ~T2; break; }   //M
                case Key.N: { matrix[7] &= ~T3; break; }   //N
                case Key.O: { matrix[5] &= ~T1; break; }   //O
                case Key.P: { matrix[5] &= ~T0; break; }   //P
                case Key.Q: { matrix[2] &= ~T0; break; }   //Q
                case Key.R: { matrix[2] &= ~T3; break; }   //R
                case Key.S: { matrix[1] &= ~T1; break; }   //S
                case Key.T: { matrix[2] &= ~T4; break; }   //T
                case Key.U: { matrix[5] &= ~T3; break; }   //U
                case Key.V: { matrix[0] &= ~T4; break; }   //V
                case Key.W: { matrix[2] &= ~T1; break; }   //W
                case Key.X: { matrix[0] &= ~T2; break; }   //X
                case Key.Y: { matrix[5] &= ~T4; break; }   //Y
                case Key.Z: { matrix[0] &= ~T1; break; }   //Z

                default: { break; }
            }
        }

        //Controla la matriz del teclado
        public void OnKeyUp(Key key)
        {
            switch (key)
            {
                case Key.Back: { matrix[4] |= T0; matrix[0] |= T0; break; }   //BACKSPACE
                case Key.Enter: { matrix[6] |= T0; break; }   //ENTER
                case Key.Shift: { matrix[0] |= T0; break; }   //SHIFT
                case Key.Ctrl: { matrix[7] |= T1; break; }   //Ctrl
                case Key.Alt: { P_Alt = false; break; }   //Alt
                case Key.Space: { matrix[7] |= T0; break; }   //Espacio
                case Key.Left: { matrix[3] |= T4; break; }   //IZDA
                case Key.Up: { matrix[4] |= T3; break; }   //ARRIBA
                case Key.Right: { matrix[4] |= T2; break; }   //DCHA
                case Key.Down: { matrix[4] |= T4; break; }   //ABAJO
                case Key.D0: { matrix[4] |= T0; break; }   //0
                case Key.D1: { matrix[3] |= T0; break; }   //1
                case Key.D2: { matrix[3] |= T1; break; }   //2
                case Key.D3: { matrix[3] |= T2; break; }   //3
                case Key.D4: { matrix[3] |= T3; break; }   //4
                case Key.D5: { matrix[3] |= T4; break; }   //5
                case Key.D6: { matrix[4] |= T4; break; }   //6
                case Key.D7: { matrix[4] |= T3; break; }   //7
                case Key.D8: { matrix[4] |= T2; break; }   //8
                case Key.D9: { matrix[4] |= T1; break; }   //9
                case Key.A: { matrix[1] |= T0; break; }   //A
                case Key.B: { matrix[7] |= T4; break; }   //B
                case Key.C: { matrix[0] |= T3; break; }   //C
                case Key.D: { matrix[1] |= T2; break; }   //D
                case Key.E: { matrix[2] |= T2; break; }   //E
                case Key.F: { matrix[1] |= T3; break; }   //F
                case Key.G: { matrix[1] |= T4; break; }   //G
                case Key.H: { matrix[6] |= T4; break; }   //H
                case Key.I: { matrix[5] |= T2; break; }   //I
                case Key.J: { matrix[6] |= T3; break; }   //J
                case Key.K: { matrix[6] |= T2; break; }   //K
                case Key.L: { matrix[6] |= T1; break; }   //L
                case Key.M: { matrix[7] |= T2; break; }   //M
                case Key.N: { matrix[7] |= T3; break; }   //N
                case Key.O: { matrix[5] |= T1; break; }   //O
                case Key.P: { matrix[5] |= T0; break; }   //P
                case Key.Q: { matrix[2] |= T0; break; }   //Q
                case Key.R: { matrix[2] |= T3; break; }   //R
                case Key.S: { matrix[1] |= T1; break; }   //S
                case Key.T: { matrix[2] |= T4; break; }   //T
                case Key.U: { matrix[5] |= T3; break; }   //U
                case Key.V: { matrix[0] |= T4; break; }   //V
                case Key.W: { matrix[2] |= T1; break; }   //W
                case Key.X: { matrix[0] |= T2; break; }   //X
                case Key.Y: { matrix[5] |= T4; break; }   //Y
                case Key.Z: { matrix[0] |= T1; break; }   //Z

                default: { break; }
            }
        }

    }
}
