using System;
using System.Collections.Generic;
using System.Text;
using Emulation.Infrastructure;
using System.Windows;
using System.IO;
#if XBOX360
using Properties = Emulation.Computers.ZxSpectrum360.Properties;
#endif

namespace Emulation.Computers.ZxSpectrum
{
    public sealed class Memory48:IMemory
    {
        private int[] content;

        public Memory48()
        {
            content = new int[65536];

            byte[] rom48K = null;
            using (BinaryReader reader =
                new BinaryReader(Application.GetResourceStream(new Uri("SilverlightSpecNix;component/Roms/zxs48.rom", UriKind.Relative)).Stream))
            {
                rom48K = reader.ReadBytes((int)reader.BaseStream.Length);
            }
            //Cargamos la rom
            for (int i = 0; i < rom48K.Length; ++i)
            {
                content[i] = rom48K[i];
            }
        }

        #region IMemory Members

        public int Length
        {
            get { return content.Length; }
        }

        public int ReadByte(int address)
        {
            address &= 0xFFFF;
            return content[address];
        }

        public int ReadWord(int address)
        {
            address &= 0xFFFF;
            return (content[address + 1] << 8) | (content[address] & 0xFF);
        }

        public void WriteByte(int address, int value)
        {
            //Rom write does not success
            address &= 0xFFFF;
            if (address < 0x4000)
            {
                return;
            }
            content[address] = value & 0xFF;
        }

        public void WriteWord(int address, int value)
        {
            //Rom write does not success
            address &= 0xFFFF;
            if (address < 0x4000)
            {
#warning
                 return;
            }
            content[address] = value & 0xFF;
            content[address + 1] = (value >> 8) & 0xFF;
        }

        #endregion
    }
}
