using System;
using System.Collections.Generic;
using System.Text;
using Emulation.Cpu.Z80;
using Emulation.Infrastructure;
using System.Threading;

namespace Emulation.Computers.ZxSpectrum
{
    public abstract class Spectrum: ISpectrum
    {
        private Z80 z80;
        private IMemory memory;
        private Ula ula;
        private Keyboard keyboard;
        private Display display;
        protected bool stopping;
        

        public Spectrum()
        {
            Build();
            //
            ula.PortReadHandler = Ula_PortReadHandler;
        }

        #region Public Properties

        public Z80 Z80
        {
            get { return z80; }
            set { z80 = value; }
        }

        public IMemory Memory
        {
            get { return memory; }
            set { memory = value; }
        }

        public Ula Ula
        {
            get { return ula; }
            set { ula = value; }
        }

        public Keyboard Keyboard
        {
            get { return keyboard; }
            set { keyboard = value; }
        }

        public Display Display
        {
            get { return display; }
            set { display = value; }
        }

        #endregion

        protected abstract void Build();

        public void Stop()
        {
            stopping = true;
        }

        public void Run()
        {
            stopping = false;
            while (stopping != true)
            {
                StepFrame();
                Thread.Sleep(20);
            }
        }
        public abstract void StepFrame();

        int Ula_PortReadHandler(int port)
        {
            int res = 0xFF;

            /*El joystick tiene prioridad sobre
            el resto de elementos*/

            /*Joystick Kempston*/
            if ((port & 0x20) == 0)
            {
                //return ((fuego << 4) | (arriba << 3) | (abajo << 2) | (izquierda << 1) | (derecha));
                return 0xFF;
            }

            /*Joystick Sinclair 1 -- 0, 9, 8, 7, 6*/
            if (port == 0xEFFE)
            {
                /*res &= ((fuego == 1) ? ~T0 : 0xFF);
                res &= ((arriba == 1) ? ~T1 : 0xFF);
                res &= ((abajo == 1) ? ~T2 : 0xFF);
                res &= ((derecha == 1) ? ~T3 : 0xFF);
                res &= ((izquierda == 1) ? ~T4 : 0xFF);*/
                res = 0xFF;
            }

              /*Joystick Sinclair 2 -- 1, 2, 3, 4, 5*/
            else if (port == 0xF7FE)
            {
                /*res &= ((fuego == 1) ? ~T0 : 0xFF);
                res &= ((arriba == 1) ? ~T1 : 0xFF);
                res &= ((abajo == 1) ? ~T2 : 0xFF);
                res &= ((derecha == 1) ? ~T3 : 0xFF);
                res &= ((izquierda == 1) ? ~T4 : 0xFF);*/
                res = 0xFF;
            }

            /*Leemos el teclado y la cinta*/
            if ((port & 0x0001) == 0)
            {
                int cod = port >> 8;
                res &= ((cod & 0x01) == 0 ? keyboard.Matrix[0] : 0xFF);
                res &= ((cod & 0x02) == 0 ? keyboard.Matrix[1] : 0xFF);
                res &= ((cod & 0x04) == 0 ? keyboard.Matrix[2] : 0xFF);
                res &= ((cod & 0x08) == 0 ? keyboard.Matrix[3] : 0xFF);
                res &= ((cod & 0x10) == 0 ? keyboard.Matrix[4] : 0xFF);
                res &= ((cod & 0x20) == 0 ? keyboard.Matrix[5] : 0xFF);
                res &= ((cod & 0x40) == 0 ? keyboard.Matrix[6] : 0xFF);
                res &= ((cod & 0x80) == 0 ? keyboard.Matrix[7] : 0xFF);

                int ear = (/*la_Cinta.valor()*/false ? 0xFF : 0xBF);
                return (byte)(res | (ear & 0x40));
            }

            return (byte)res;
        }
    }
}
