using System;
using System.Collections.Generic;
using System.Text;
using Emulation.Cpu.Z80;
using System.Threading;
using Emulation.Infrastructure;

namespace Emulation.Computers.ZxSpectrum
{
    public class Spectrum128 : Spectrum
    {
        public new Memory128 Memory
        {
            get { return base.Memory as Memory128; }
            set { base.Memory = value; }
        }

        protected override void Build()
        {
            Keyboard = new Keyboard();
            Memory = new Memory128();
            Ula = new Ula128();
            Z80 = new Z80(Memory, Ula);
            Display = new Display128(Memory);

            Ula.Memory = Memory;
            Ula.Z80 = Z80;
            Z80.Memory = Memory;
            Z80.IO = Ula;
        }

        public override void StepFrame()
        {
            while (Z80.GetRegister(Z80Registers.TStates) <= 70908)
            {
                Z80.Step();
            }
            Z80.SetRegister(Z80Registers.TStates, Z80.GetRegister(Z80Registers.TStates) - 70908);
            Z80.MaskableInterrupt();
        }
    }
}
