using System;
using System.Collections.Generic;
using System.Text;
using Emulation.Cpu.Z80;
using Emulation.Infrastructure;
using System.Threading;

namespace Emulation.Computers.ZxSpectrum
{
    public class Spectrum48 : Spectrum
    {
        public new Memory48 Memory
        {
            get { return base.Memory as Memory48; }
            set { base.Memory = value; }
        }

        protected override void Build()
        {
            //Construimos
            this.Keyboard = new Keyboard();
            Memory = new Memory48();
            Ula = new Ula48();
            Z80 = new Z80();
            Display = new Display(Memory);
            //Conectamos            
            Ula.Memory = Memory;
            Ula.Z80 = Z80;
            Z80.Memory = Memory;
            Z80.IO = Ula;
        }

        public override void StepFrame()
        {
            while (Z80.GetRegister(Z80Registers.TStates) <= 69988)
            {
                Z80.Step();
            }
            Z80.SetRegister(Z80Registers.TStates, Z80.GetRegister(Z80Registers.TStates) - 69988);
            Z80.MaskableInterrupt();
        }
    }
}
