using System;
using System.Collections.Generic;
using System.Text;
using Emulation.Cpu.Z80;
using Emulation.Infrastructure;

namespace Emulation.Computers.ZxSpectrum
{
    public delegate int PortReadHandler(int port);

    public class Ula: IInputOutput
    {
        private IMemory memory;
        private Z80 z80;
        private PortReadHandler portReadHandler;

        public IMemory Memory
        {
            get { return memory; }
            set { memory = value; }
        }

        public Z80 Z80
        {
            get { return z80; }
            set { z80 = value; }
        }

        public PortReadHandler PortReadHandler
        {
            get { return portReadHandler; }
            set { portReadHandler = value; }
        }

        public virtual int ReadPort(int port)
        {
            return portReadHandler(port);
        }

        public virtual void WritePort(int port, int value)
        {

        }

        public virtual void InterruptHandler()
        {
        }
    }
}
