using System;
using System.Collections.Generic;
using System.Text;

namespace Emulation.Cpu.Z80
{
    public enum Z80Registers
    {
        A, F, B, C, D, E, H, L,
        AF, BC, DE, HL,
        AltA, AltF, AltB, AltC, AltD, AltE, AltH, AltL,        
        AltAF, AltBC, AltDE, AltHL,
        PC, IX, IY, I,
        SP,
        R,
        IFF1, IFF2,
        InterruptMode,        
        TStates,
    }

	public partial class Z80
	{
        public void Reset()
        {
            isHalted = false;
            IrqVector = 0xFF;

            A = F = B = C = D = E = H = L = I = 0xFF;
            AltA = AltF = AltB = AltC = AltD = AltE = AltH = AltL = 0xFF;
            SP = IX = IY = 0xFFFF;
            R = 0x7F;
            R7 = 0x80;
            PC = InterruptMode = 0;
            IFF1 = IFF2 = false;
        }

        public int GetRegister(Z80Registers register)
        {
            switch (register)
            {
                case Z80Registers.A:
                    return A;
                case Z80Registers.F:
                    return F;
                case Z80Registers.B:
                    return B;
                case Z80Registers.C:
                    return C;
                case Z80Registers.D:
                    return D;
                case Z80Registers.E:
                    return E;
                case Z80Registers.H:
                    return H;
                case Z80Registers.L:
                    return L;
                case Z80Registers.AF:
                    return AF;
                case Z80Registers.BC:
                    return BC;
                case Z80Registers.DE:
                    return DE;
                case Z80Registers.HL:
                    return HL;
                case Z80Registers.AltA:
                    return AltA;
                case Z80Registers.AltF:
                    return AltF;
                case Z80Registers.AltB:
                    return AltB;
                case Z80Registers.AltC:
                    return AltC;
                case Z80Registers.AltD:
                    return AltD;
                case Z80Registers.AltE:
                    return AltE;
                case Z80Registers.AltH:
                    return AltH;
                case Z80Registers.AltL:
                    return AltL;
                case Z80Registers.AltAF:
                    return AltAF;
                case Z80Registers.AltBC:
                    return AltBC;
                case Z80Registers.AltDE:
                    return AltDE;
                case Z80Registers.AltHL:
                    return AltHL;
                case Z80Registers.PC:
                    return PC;
                case Z80Registers.IX:
                    return IX;
                case Z80Registers.IY:
                    return IY;
                case Z80Registers.I:
                    return I;
                case Z80Registers.SP:
                    return SP;
                case Z80Registers.R:
                    return R | R7;
                case Z80Registers.IFF1:
                    return IFF1 ? 1 : 0;
                case Z80Registers.IFF2:
                    return IFF2 ? 1 : 0;
                case Z80Registers.InterruptMode:
                    return InterruptMode;
                case Z80Registers.TStates:
                    return tStates;
                default:
                    throw new ArgumentOutOfRangeException();
            }            
        }

        public void SetRegister(Z80Registers register, int value)
        {
            switch (register)
            {
                case Z80Registers.A:
                    A = value;
                    break;
                case Z80Registers.F:
                    F = value;
                    break;
                case Z80Registers.B:
                    B = value;
                    break;
                case Z80Registers.C:
                    C = value;
                    break;
                case Z80Registers.D:
                    D = value;
                    break;
                case Z80Registers.E:
                    E = value;
                    break;
                case Z80Registers.H:
                    H = value;
                    break;
                case Z80Registers.L:
                    L = value;
                    break;
                case Z80Registers.AF:
                    AF = value;
                    break;
                case Z80Registers.BC:
                    BC = value;
                    break;
                case Z80Registers.DE:
                    DE = value;
                    break;
                case Z80Registers.HL:
                    HL = value;
                    break;
                case Z80Registers.AltA:
                    AltA = value;
                    break;
                case Z80Registers.AltF:
                    AltF = value;
                    break;
                case Z80Registers.AltB:
                    AltB = value;
                    break;
                case Z80Registers.AltC:
                    AltC = value;
                    break;
                case Z80Registers.AltD:
                    AltD = value;
                    break;
                case Z80Registers.AltE:
                    AltE = value;
                    break;
                case Z80Registers.AltH:
                    AltH = value;
                    break;
                case Z80Registers.AltL:
                    AltL = value;
                    break;
                case Z80Registers.AltAF:
                    AltAF = value;
                    break;
                case Z80Registers.AltBC:
                    AltBC = value;
                    break;
                case Z80Registers.AltDE:
                    AltDE = value;
                    break;
                case Z80Registers.AltHL:
                    AltHL = value;
                    break;
                case Z80Registers.PC:
                    PC = value;
                    break;
                case Z80Registers.IX:
                    IX = value;
                    break;
                case Z80Registers.IY:
                    IY = value;
                    break;
                case Z80Registers.I:
                    I = value;
                    break;
                case Z80Registers.SP:
                    SP = value;
                    break;
                case Z80Registers.R:
                    R = value & 0x7F;
                    R7 = value & 0x80;
                    break;
                case Z80Registers.IFF1:
                    IFF1 = (value != 0) ? true : false;
                    break;
                case Z80Registers.IFF2:
                    IFF2 = (value != 0) ? true : false;
                    break;
                case Z80Registers.InterruptMode:
                    InterruptMode = value;
                    break;
                case Z80Registers.TStates:
                    tStates = value;
                    break;
                default:
                    throw new IndexOutOfRangeException();
            }            
        }
	}
}
