using System;
using System.Collections.Generic;
using System.Text;

namespace Emulation.Cpu.Z80
{
    public sealed partial class Z80
    {
        private void Add(int val)
        {
            int res = A + val;
            F = SZ[(byte)res] | ((res >> 8) & CF) |
                ((A ^ res ^ val) & HF) |
                (((val ^ A ^ 0x80) & (val ^ res) & 0x80) >> 5);
            A = (byte)res;
        }

        private void Adc(int val)
        {
            int res = A + val + (F & CF);
            F = SZ[res & 0xff] | ((res >> 8) & CF) |
                ((A ^ res ^ val) & HF) |
                (((val ^ A ^ 0x80) & (val ^ res) & 0x80) >> 5);
            A = (byte)res;
        }

        private void Sub(int val)
        {
            int res = (A - val);
            F = SZ[res & 0xff] | ((res >> 8) & CF) | NF |
                ((A ^ res ^ val) & HF) |
                (((val ^ A) & (A ^ res) & 0x80) >> 5);
            A = (byte)res;
        }

        private void Sbc(int val)
        {
            int res = (A - val - (F & CF));
            F = SZ[res & 0xff] | ((res >> 8) & CF) | NF |
                ((A ^ res ^ val) & HF) |
                (((val ^ A) & (A ^ res) & 0x80) >> 5);
            A = (byte)res;
        }

        private void And(int val)
        {
            A &= val;
            F = SZP[A] | HF;
        }

        private void Or(int val)
        {
            A |= val;
            F = SZP[A];
        }

        private void Xor(int val)
        {
            A ^= val;
            F = SZP[A];
        }

        private void Cp(int val)
        {
            int res = (A - val);
            F = (SZ[res & 0xff] & (SF | ZF)) |
                (val & (YF | XF)) | ((res >> 8) & CF) | NF |
                ((A ^ res ^ val) & HF) |
                ((((val ^ A) & (A ^ res)) >> 5) & VF);
        }

        private int Add16(int val1, int val2)
        {
            int res = val1 + val2;
            F = (F & (SF | ZF | VF)) |
                (((val1 ^ res ^ val2) >> 8) & HF) |
                ((res >> 16) & CF) | ((res >> 8) & (YF | XF));
            return (UInt16)res;
        }

        private void Adc16(int val)
        {
            int res = HL + val + (F & CF);
            F = (((HL ^ res ^ val) >> 8) & HF) |
                ((res >> 16) & CF) |
                ((res >> 8) & (SF | YF | XF)) |
                (((res & 0xffff) != 0) ? 0 : ZF) |
                (((val ^ HL ^ 0x8000) & (val ^ res) & 0x8000) >> 13);
            HL = (UInt16)res;
        }

        private void Sbc16(int val)
        {
            int res = (int)(uint)(HL - val - (F & CF));
            F = (((HL ^ res ^ val) >> 8) & HF) | NF |
                ((res >> 16) & CF) |
                ((res >> 8) & (SF | YF | XF)) |
                (((res & 0xffff) != 0) ? 0 : ZF) |
                (((val ^ HL) & (HL ^ res) & 0x8000) >> 13);
            HL = (UInt16)res;
        }

        private int Inc(int val)
        {
            int res = (byte)(val + 1);
            F = (F & CF) | SZHV_inc[res];
            return res;
        }

        private int Dec(int val)
        {
            int res = (byte)(val - 1);
            F = (F & CF) | SZHV_dec[res];
            return (byte)res;
        }

        private void Rlca()
        {
            A = (byte)((A << 1) | (A >> 7));
            F = (F & (SF | ZF | PF)) | (A & (YF | XF | CF));
        }

        private void Rrca()
        {
            F = (F & (SF | ZF | PF)) | (A & CF);
            A = (byte)((A >> 1) | (A << 7));
            F |= (A & (YF | XF));
        }

        private void Rla()
        {
            int res = (A << 1) | (F & CF);
            int c = ((A & 0x80) != 0) ? CF : 0;
            F = (F & (SF | ZF | PF)) | c | (res & (YF | XF));
            A = (byte)res;
        }

        private void Rra()
        {
            int res = (A >> 1) | (F << 7);
            int c = ((A & 0x01) != 0) ? CF : 0;
            F = (F & (SF | ZF | PF)) | c | (res & (YF | XF));
            A = (byte)res;
        }

        private void Rrd()
        {
            int n = memory.ReadByte(HL);
            memory.WriteByte(HL, (n >> 4) | (A << 4));
            A = (byte)((A & 0xf0) | (n & 0x0f));
            F = (F & CF) | SZP[A];
        }

        private void Rld()
        {
            int n = memory.ReadByte(HL);
            memory.WriteByte(HL, (n << 4) | (A & 0x0f));
            A = (byte)((A & 0xf0) | (n >> 4));
            F = (F & CF) | SZP[A];
        }

        private int Rlc(int value)
        {
            int res = value;
            int c = ((res & 0x80)!=0) ? CF : 0;
            res = ((res << 1) | (res >> 7)) & 0xff;
            F = SZP[(byte)res] | c;
            return (byte)res;
        }

        private int Rrc(int value)
        {
            int res = value;
            int c = ((res & 0x01)!=0) ? CF : 0;
            res = ((res >> 1) | (res << 7)) & 0xff;
            F = SZP[(byte)res] | c;
            return (byte)res;
        }

        private int Rl(int value)
        {
            int res = value;
            int c = ((res & 0x80)!=0) ? CF : 0;
            res = ((res << 1) | (F & CF)) & 0xff;
            F = SZP[(byte)res] | c;
            return (byte)res;
        }

        private int Rr(int value)
        {
            int res = value;
            int c = ((res & 0x01)!=0) ? CF : 0;
            res = ((res >> 1) | (F << 7)) & 0xff;
            F = SZP[(byte)res] | c;
            return (byte)res;
        }

        private int Sla(int value)
        {
            int res = value;
            int c = ((res & 0x80) != 0) ? CF : 0;
            res = (res << 1) & 0xff;
            F = SZP[(byte)res] | c;
            return (byte)res;
        }

        private int Sra(int value)
        {
            int res = value;
            int c = ((res & 0x01)!=0) ? CF : 0;
            res = ((res >> 1) | (res & 0x80)) & 0xff;
            F = SZP[(byte)res] | c;
            return (byte)res;
        }

        private int Sll(int value)
        {
            int res = value;
            int c = ((res & 0x80)!=0) ? CF : 0;
            res = ((res << 1) | 0x01) & 0xff;
            F = SZP[(byte)res] | c;
            return (byte)res;
        }

        private int Srl(int value)
        {
            int res = value;
            int c = ((res & 0x01)!=0) ? CF : 0;
            res = (res >> 1) & 0xff;
            F = SZP[(byte)res] | c;
            return (byte)res;
        }

        private void Neg()
        {
            int val = A;
            A = 0;
            int res = A - val;
            F = SZ[res & 0xff] | ((res >> 8) & CF) | NF |
                ((A ^ res ^ val) & HF) |
                (((val ^ A) & (A ^ res) & 0x80) >> 5);
            A = (byte)res;
        }

        private void Bit(int bit, int val)
        {
            F = (F & CF) | HF | SZ_BIT[val & (1 << bit)];
        }

        private void Daa()
        {
            int cf, nf, hf, lo, hi, diff;								
	        cf = F & CF;												
	        nf = F & NF;											
	        hf = F & HF;												
	        lo = A & 15;												
	        hi = A / 16;												
																
	        if (cf!=0)														
	        {															
		        diff = (lo <= 9 && (hf==0)) ? 0x60 : 0x66;					
	        }															
	        else														
	        {															
		        if (lo >= 10)											
		        {														
			        diff = hi <= 8 ? 0x06 : 0x66;						
		        }														
		        else													
		        {														
			        if (hi >= 10)										
			        {													
				        diff = (hf!=0) ? 0x66 : 0x60;						
			        }													
			        else												
			        {													
				        diff = (hf!=0) ? 0x06 : 0x00;						
			        }													
		        }														
	        }
            if (nf != 0) A = (A - diff) & 0xFF;
            else A = (A + diff) & 0xFF;
        																
	        F = SZP[(byte)A] | (F & NF);										
	        if ((cf!=0) || (lo <= 9 ? hi >= 10 : hi >= 9)) F |= CF;			
	        if ((nf!=0) ? (hf!=0) && lo <= 5 : lo >= 10)	F |= HF;
        }

        private void EXX()
        {
            int aux;
            
            aux = B;
            B = AltB;
            AltB = aux;
            aux = C;
            C = AltC;
            AltC = aux;

            aux = D;
            D = AltD;
            AltD = aux;
            aux = E;
            E = AltE;
            AltE = aux;

            aux = H;
            H = AltH;
            AltH = aux;
            aux = L;
            L = AltL;
            AltL = aux;
        }
    }
}
