; Kind of color table test for Tunguska
;
;  Assemble into demo.ternobj
;  Run 'tunguska image.ternobj -F demo.ternobj'
;  Type 'LOADSUB'
;

@ORG    %DDD000
        ; Bootstrap function
        ;
        ; Read page 2 from disk into page 2 in memory
        LDA     #2
        LDY     #2
        JSR     (jumpvector.fl_read_block)
        JMP     colortable

; These won't be copied. They are also present in the host at the same
; memory location. 

@ORG    %001000
jumpvector:
.getstring:     @DW     0
.feedscreen:    @DW     0
.putchar:       @DW     0
.putnon:        @DW     0
.puts:          @DW     0
.strcmp:        @DW     0
.strlen:        @DW     0
.index:         @DW     0
.strspn:        @DW     0
.strcspn:       @DW     0
.memset6:       @DW     0
.random:        @DW     0
.between:       @DW     0
.repaint:       @DW     0
.fl_read_block: @DW     0
.fl_write_block: @DW    0

@ORG    %002000
colortable:
                ; Enable raster mode
                LDA     #%00C
                STA     %DDDDDB

                ; Load screen buffer address
                LDX     #%DDB
                LDY     #%DDD
.mainloop:              
                LDA     .colornum
                INC     .colornum
                STA     X,Y
                INY
                JVC     .pass
                INX
.pass:                  
                TXA
                CMP     #%CAB
                JNE     .mainloop
.idleloop:
                JMP     .idleloop

.colornum:
                @DW     %444
