#include "math.3h"


/* Babylonian square root computation */
int sqrti(int x) {
	int guess;
	int iters;
	if(x < 0) return -1;

	iters = 2 * log3i(x);

	guess = x / 2;
	while(iters--) 
		guess = (guess + x/guess) / 2;

	return guess;
	
}

/* Babylonian square root computation for fixed point maths */
int sqrtfi(int x) {
	int guess;
	int iters;
	if(x < 0) return -1;

	iters = 2 * log3i(x/81);

	guess = x / 2;
	while(iters--) 
		guess = (guess + 81*x/guess) / 2;

	return guess;

}

/* Integral 3-logarithm */
int log3i(int x) {
	int result = 0;
	while(x != 0) {
		x = x / 3;
		result++;
	}
	return result;
}

/* Integral 10-logarithm */
int log10i(int x) {
	int result = 0;
	while(x != 0) {
		x = x / 10;
		result++;
	}
	return result;
}

char cos(char x) {
	/* Cosine is an even function, and thus cos(-x) = cos(x), therefore it is only
	 * necessary to keep 365 values of the table (as opposed to 729) */
	static char lookup_table[] = { 364, 363, 363, 363, 363, 363, 363, 363, 363, 362, 362, 362, 362, 361, 361, 
				       360, 360, 360, 359, 359, 358, 358, 357, 356, 356, 355, 354, 354, 353, 352,
				       351, 351, 350, 349, 348, 347, 346, 345, 344, 343, 342, 341, 340, 339, 338,
				       336, 335, 334, 333, 331, 330, 329, 327, 326, 325, 323, 322, 320, 319, 317,
				       316, 314, 313, 311, 309, 308, 306, 304, 303, 301, 299, 297, 295, 294, 292,
				       290, 288, 286, 284, 282, 280, 278, 276, 274, 272, 270, 268, 266, 263, 261,
				       259, 257, 255, 252, 250, 248, 246, 243, 241, 239, 236, 234, 231, 229, 226,
				       224, 222, 219, 216, 214, 211, 209, 206, 204, 201, 198, 196, 193, 190, 188,
				       185, 182, 180, 177, 174, 171, 169, 166, 163, 160, 157, 155, 152, 149, 146,
				       143, 140, 137, 134, 132, 129, 126, 123, 120, 117, 114, 111, 108, 105, 102,
				       99, 96, 93, 90, 87, 84, 80, 77, 74, 71, 68, 65, 62, 59, 56, 53, 50, 46, 43,
				       40, 37, 34, 31, 28, 25, 21, 18, 15, 12, 9, 6, 3, 0, -3, -6, -9, -12, -15,
				       -18, -21, -25, -28, -31, -34, -37, -40, -43, -46, -50, -53, -56, -59, -62,
				       -65, -68, -71, -74, -77, -80, -84, -87, -90, -93, -96, -99, -102, -105,
				       -108, -111, -114, -117, -120, -123, -126, -129, -132, -134, -137, -140,
				       -143, -146, -149, -152, -155, -157, -160, -163, -166, -169, -171, -174,
				       -177, -180, -182, -185, -188, -190, -193, -196, -198, -201, -204, -206,
				       -209, -211, -214, -216, -219, -222, -224, -226, -229, -231, -234, -236,
				       -239, -241, -243, -246, -248, -250, -252, -255, -257, -259, -261, -263,
				       -266, -268, -270, -272, -274, -276, -278, -280, -282, -284, -286, -288,
				       -290, -292, -294, -295, -297, -299, -301, -303, -304, -306, -308, -309,
				       -311, -313, -314, -316, -317, -319, -320, -322, -323, -325, -326, -327,
				       -329, -330, -331, -333, -334, -335, -336, -338, -339, -340, -341, -342,
				       -343, -344, -345, -346, -347, -348, -349, -350, -351, -351, -352, -353,
				       -354, -354, -355, -356, -356, -357, -358, -358, -359, -359, -360, -360,
				       -360, -361, -361, -362, -362, -362, -362, -363, -363, -363, -363, -363,
				       -363, -363, -363, -364 };

	/* Note that x*~x = abs(x) */
	return lookup_table[x*(~x)];
}

char sin(char x) {
	return cos(182-x); 
}
