/* ADDBIN.C - Alexander Shabarshin 17.11.2000-23.01.2006 */

#include <stdio.h>
#include <stdlib.h>
#include "hex.hpp"

int main(int argc, char **argv)
{
 int i,j,off,size;
 FILE *f1,*f2;
 char str1[256],str2[256];
 if(argc<3)
 {
    printf("\n\nADDBIN target.bin source.bin [hexoffset]\n\n");
    return 0;
 }
 strcpy(str1,argv[1]);
 strcpy(str2,argv[2]);
 if(argc>3) 
 {
    off = hex2i(argv[3]);
    printf("ADD %s TO %s WITH OFFSET %4.4X\n",str2,str1,off);
 }  
 else
 {
    off = -1;
    printf("ADD %s TO END OF %s\n",str2,str1);
 }  
 f1 = fopen(str1,"r+b");
 if(f1==NULL)
 {  
    f1 = fopen(str1,"wb");
    for(i=0;i<off;i++) fputc(0,f1);
 }
 else
 {
    fseek(f1,0L,SEEK_END);
    j = ftell(f1);
    fseek(f1,0L,SEEK_SET);
    if(off<0) off = j;
    if(j>off) fseek(f1,off,SEEK_SET);
    else
    {
       fseek(f1,j,SEEK_SET);
       for(i=j;i<off;i++) fputc(0,f1);
    }
 }
 if(f1==NULL) return 0;
 f2 = fopen(str2,"rb");
 if(f2==NULL)
 {
    fclose(f1);
    printf("Can't open file %s\n",str2);
    return 0;
 }
 fseek(f2,0L,SEEK_END);
 size = ftell(f2);
 fseek(f2,0L,SEEK_SET);
 for(i=0;i<size;i++) fputc(fgetc(f2),f1);
 fclose(f1);
 fclose(f2);
 printf("Done\n\n");
 return 1;
}
