
/************************************

  PicchioEngine

  Copyright(c)2008 Emanuele Bettidi

************************************/

/* Gamepad.h */

#ifndef GAMEPADS_H
#define GAMEPADS_H

class gamepad_t
{
 public:
  static const uint16 I      = 0x0001;
  static const uint16 II     = 0x0002;
  static const uint16 SELECT = 0x0004;
  static const uint16 RUN    = 0x0008;
  static const uint16 UP     = 0x0010;
  static const uint16 RIGHT  = 0x0020;
  static const uint16 DOWN   = 0x0040;
  static const uint16 LEFT   = 0x0080;
  static const uint16 III    = 0x0100;
  static const uint16 IV     = 0x0200;
  static const uint16 V      = 0x0400;
  static const uint16 VI     = 0x0800;

  static const bool OFF = false;  // slow off
  static const bool ON = true;    // slow on

  static const bool MODE_A = false;  // two-button mode
  static const bool MODE_B = true;   // six-button mode

  uint8 clr_line;
  uint8 sel_line;
  uint16 buttons;
  bool mode;
  bool slow;
  uint8 counter;   // 4-bit counter
  uint8 i_turbo;   // n-position slide switch
  uint8 ii_turbo;  // n-position slide switch

  void init();
  uint8 read();
  void write(uint8 new_clr_line, uint8 new_sel_line);
};

extern gamepad_t Gamepad[5];

#endif // GAMEPADS_H
