
/************************************

  PicchioEngine

  Copyright(c)2008 Emanuele Bettidi

************************************/

/* IOPort.cpp */

/* HuC6280 - I/O Port */

#include "Types.h"
#include "Config.h"
#include "Input.h"
#include "MultiTap.h"
#include "Gamepads.h"
#include "PCE.h"
#include "IOPort.h"

namespace IOPort
{
 void reset();

 uint8 clr_line;
 uint8 sel_line;
 uint8 high_nibble;
 int controller_port;

 void init()
 {
  if (PCE::console == 2) high_nibble = 0xB0; else high_nibble = 0xF0;
  reset();
 }

 void reset()
 {
  clr_line = 1;
  sel_line = 1;  // NOT TESTED
  switch(controller_port)
  {
   case 0: /* none       */                                       break;
   case 1: /* pcepad     */ Gamepad[0].write(clr_line, sel_line); break;
   case 2: /* turbopad   */ Gamepad[0].write(clr_line, sel_line); break;
   case 3: /* avenuepad6 */ Gamepad[0].write(clr_line, sel_line); break;
   case 4: /* multitap   */ MultiTap::write(clr_line, sel_line);  break;
  }
 }

 uint8 read()
 {
  Input::update_events();
  switch(controller_port)
  {
   case 0: /* none       */ return (high_nibble | 0x0F);
   case 1: /* pcepad     */ return (high_nibble | Gamepad[0].read());
   case 2: /* turbopad   */ return (high_nibble | Gamepad[0].read());
   case 3: /* avenuepad6 */ return (high_nibble | Gamepad[0].read());
   case 4: /* multitap   */ return (high_nibble | MultiTap::read());
  }
  return (high_nibble | 0x0F);
 }

 void write(uint8 data)
 {
  // Input::update_events();
  clr_line = (data & 2) >> 1;
  sel_line = data & 1;
  switch(controller_port)
  {
   case 0: /* none       */                                       break;
   case 1: /* pcepad     */ Gamepad[0].write(clr_line, sel_line); break;
   case 2: /* turbopad   */ Gamepad[0].write(clr_line, sel_line); break;
   case 3: /* avenuepad6 */ Gamepad[0].write(clr_line, sel_line); break;
   case 4: /* multitap   */ MultiTap::write(clr_line, sel_line);  break;
  }
 }
}
