
/************************************

  PicchioEngine

  Copyright(c)2008 Emanuele Bettidi

************************************/

/* Input.h */

#ifndef INPUT_H
#define INPUT_H

namespace Input
{
 void init();
 void deinit();
 void to_undefined_values();
 void to_default_values();
 void update_events();
 void pause_loop();

 struct pcepad_t
 {
  int key[8];
  int joy_index;
  int32 joy_button[8];
 };

 struct turbopad_t
 {
  int key[12];
  int joy_index;
  int32 joy_button[12];
 };

 struct avenuepad6_t
 {
  int key[16];
  int joy_index;
  int32 joy_button[16];
 };

 extern const int32 BUTTON;
 extern const int32 AXIS;
 extern const int32 HAT;

 extern const int32 POS;
 extern const int32 NEG;

 extern bool exit;
 extern bool pause;

 extern pcepad_t PCEPad[5];
 extern turbopad_t TurboPad[5];
 extern avenuepad6_t AvenuePad6[5];
}

#endif // INPUT_H
