
/************************************

  PicchioEngine

  Copyright(c)2008 Emanuele Bettidi

************************************/

/* IntCtrl.cpp */

/* HuC6280 - Interrupt Control */

#include "Types.h"
#include "CPU.h"
#include "Timer.h"
#include "VDC.h"
#include "IntCtrl.h"

namespace IntCtrl
{
 void reset();

 /* registers */
 uint8 disable;  // Interrupt disable register
 uint8 status;   // Interrupt status register, meglio: 'Interrupt Request Register'?

 void init()
 {
  reset();
 }

 void reset()
 {
  disable = 0x00;
  status = 0x00;
 }

 uint8 read(uint8 reg)
 {
  switch (reg & 0x03)
  {
   // case 0: return CPU::IO_buffer;
   // case 1: return CPU::IO_buffer;
   case 2: return disable;
   case 3: Timer::resync();
           VDC::resync();
           return status;
   default: return 0;  // to avoid the warning
  }
 } 

 void write(uint8 reg, uint8 data)
 {
  switch (reg & 0x03)
  {
   case 0: break;
   case 1: break;
   case 2: disable = data & 0x07;
           break;
   case 3: Timer::resync();
           int32 delay = Timer::phase & (CPU::cycle_length >> 2); 
           if (Timer::tail < (2 - delay)) status &= 0x03;
           int32 tirq_delay = (Timer::phase & 1) + (CPU::cycle_length >> 2);
           if (Timer::tail != (2 - tirq_delay)) CPU::IRQ_lines &= 0x03;
           break;
  }
 }

}
