
/************************************

  PicchioEngine

  Copyright(c)2008 Emanuele Bettidi

************************************/

/* Ops.h */

    case 0x00: /* BRK */         { BRK();                      } break;
    case 0x01: /* ORA_zpxind */  { LD_ZPXIND(); ORA();         } break;
    case 0x02: /* SXY */         { SWP(X,Y);                   } break;
    case 0x03: /* ST0 */         { ST_VDC(0);                  } break;
    case 0x04: /* TSB_zp */      { LD_ZP();   TSB(); WR_ZP();  } break;
    case 0x05: /* ORA_zp */      { LD_ZP();     ORA();         } break;
    case 0x06: /* ASL_zp */      { LD_ZP();   ASL(); WR_ZP();  } break;
    case 0x07: /* RMB0 */        { RMB(0);                     } break;
    case 0x08: /* PHP */         { PH(P);                      } break;
    case 0x09: /* ORA_imm */     { LD_IMM();    ORA();         } break;
    case 0x0A: /* ASL_a */       { ASL_A();                    } break;
    case 0x0B: /* ILL_0B */      { ILL();                      } break;
    case 0x0C: /* TSB_abs */     { LD_ABS();  TSB(); WR_ABS(); } break;
    case 0x0D: /* ORA_abs */     { LD_ABS();    ORA();         } break;
    case 0x0E: /* ASL_abs */     { LD_ABS();  ASL(); WR_ABS(); } break;
    case 0x0F: /* BBR0 */        { BBR(0);                     } break;

    case 0x10: /* BPL */         { BR((P & N_FLAG) == 0);      } break;
    case 0x11: /* ORA_zpindy */  { LD_ZPINDY(); ORA();         } break;
    case 0x12: /* ORA_zpind */   { LD_ZPIND();  ORA();         } break;
    case 0x13: /* ST1 */         { ST_VDC(2);                  } break;
    case 0x14: /* TRB_zp */      { LD_ZP();   TRB(); WR_ZP();  } break;
    case 0x15: /* ORA_zpx */     { LD_ZPX();    ORA();         } break;
    case 0x16: /* ASL_zpx */     { LD_ZPX();  ASL(); WR_ZP();  } break;
    case 0x17: /* RMB1 */        { RMB(1);                     } break;
    case 0x18: /* CLC */         { CL_FLAG(C_FLAG);            } break;
    case 0x19: /* ORA_absy */    { LD_ABSY();   ORA();         } break;
    case 0x1A: /* INC_a */       { INC_A();                    } break;
    case 0x1B: /* ILL_1B */      { ILL();                      } break;
    case 0x1C: /* TRB_abs */     { LD_ABS();  TRB(); WR_ABS(); } break;
    case 0x1D: /* ORA_absx */    { LD_ABSX();   ORA();         } break;
    case 0x1E: /* ASL_absx */    { LD_ABSX(); ASL(); WR_ABS(); } break;
    case 0x1F: /* BBR1 */        { BBR(1);                     } break;

    case 0x20: /* JSR */         { JSR();                      } break;
    case 0x21: /* AND_zpxind */  { LD_ZPXIND(); AND();         } break;
    case 0x22: /* SAX */         { SWP(A,X);                   } break;
    case 0x23: /* ST2 */         { ST_VDC(3);                  } break;
    case 0x24: /* BIT_zp */      { LD_ZP();     BIT();         } break;
    case 0x25: /* AND_zp */      { LD_ZP();     AND();         } break;
    case 0x26: /* ROL_zp */      { LD_ZP();   ROL(); WR_ZP();  } break;
    case 0x27: /* RMB2 */        { RMB(2);                     } break;
    case 0x28: /* PLP */         { PLP();                      } break;
    case 0x29: /* AND_imm */     { LD_IMM();    AND();         } break;
    case 0x2A: /* ROL_a */       { ROL_A();                    } break;
    case 0x2B: /* ILL_2B */      { ILL();                      } break;
    case 0x2C: /* BIT_abs */     { LD_ABS();    BIT();         } break;
    case 0x2D: /* AND_abs */     { LD_ABS();    AND();         } break;
    case 0x2E: /* ROL_abs */     { LD_ABS();  ROL(); WR_ABS(); } break;
    case 0x2F: /* BBR2 */        { BBR(2);                     } break;

    case 0x30: /* BMI */         { BR((P & N_FLAG) != 0);      } break;
    case 0x31: /* AND_zpindy */  { LD_ZPINDY(); AND();         } break;
    case 0x32: /* AND_zpind */   { LD_ZPIND();  AND();         } break;
    case 0x33: /* ILL_33 */      { ILL();                      } break;
    case 0x34: /* BIT_zpx */     { LD_ZPX();    BIT();         } break;
    case 0x35: /* AND_zpx */     { LD_ZPX();    AND();         } break;
    case 0x36: /* ROL_zpx */     { LD_ZPX();  ROL(); WR_ZP();  } break;
    case 0x37: /* RMB3 */        { RMB(3);                     } break;
    case 0x38: /* SEC */         { SEC();                      } break;
    case 0x39: /* AND_absy */    { LD_ABSY();   AND();         } break;
    case 0x3A: /* DEC_a */       { DEC_A();                    } break;
    case 0x3B: /* ILL_3B */      { ILL();                      } break;
    case 0x3C: /* BIT_absx */    { LD_ABSX();   BIT();         } break;
    case 0x3D: /* AND_absx */    { LD_ABSX();   AND();         } break;
    case 0x3E: /* ROL_absx */    { LD_ABSX(); ROL(); WR_ABS(); } break;
    case 0x3F: /* BBR3 */        { BBR(3);                     } break;

    case 0x40: /* RTI */         { RTI();                      } break;
    case 0x41: /* EOR_zpxind */  { LD_ZPXIND(); EOR();         } break;
    case 0x42: /* SAY */         { SWP(A,Y);                   } break;
    case 0x43: /* TMA */         { TMA();                      } break;
    case 0x44: /* BSR */         { BSR();                      } break;
    case 0x45: /* EOR_zp */      { LD_ZP();     EOR();         } break;
    case 0x46: /* LSR_zp */      { LD_ZP();   LSR(); WR_ZP();  } break;
    case 0x47: /* RMB4 */        { RMB(4);                     } break;
    case 0x48: /* PHA */         { PH(A);                      } break;
    case 0x49: /* EOR_imm */     { LD_IMM();    EOR();         } break;
    case 0x4A: /* LSR_a */       { LSR_A();                    } break;
    case 0x4B: /* ILL_4B */      { ILL();                      } break;
    case 0x4C: /* JMP_abs */     { JMP_ABS();                  } break;
    case 0x4D: /* EOR_abs */     { LD_ABS();    EOR();         } break;
    case 0x4E: /* LSR_abs */     { LD_ABS();  LSR(); WR_ABS(); } break;
    case 0x4F: /* BBR4 */        { BBR(4);                     } break;

    case 0x50: /* BVC */         { BR((P & V_FLAG) == 0);      } break;
    case 0x51: /* EOR_zpindy */  { LD_ZPINDY(); EOR();         } break;
    case 0x52: /* EOR_zpind */   { LD_ZPIND();  EOR();         } break;
    case 0x53: /* TAM */         { TAM();                      } break;
    case 0x54: /* CSL */         { CSL();                      } break;
    case 0x55: /* EOR_zpx */     { LD_ZPX();    EOR();         } break;
    case 0x56: /* LSR_zpx */     { LD_ZPX();  LSR(); WR_ZP();  } break;
    case 0x57: /* RMB5 */        { RMB(5);                     } break;
    case 0x58: /* CLI */         { CLI();                      } break;
    case 0x59: /* EOR_absy */    { LD_ABSY();   EOR();         } break;
    case 0x5A: /* PHY */         { PH(Y);                      } break;
    case 0x5B: /* ILL_5B */      { ILL();                      } break;
    case 0x5C: /* ILL_5C */      { ILL();                      } break;
    case 0x5D: /* EOR_absx */    { LD_ABSX();   EOR();         } break;
    case 0x5E: /* LSR_absx */    { LD_ABSX(); LSR(); WR_ABS(); } break;
    case 0x5F: /* BBR5 */        { BBR(5);                     } break;

    case 0x60: /* RTS */         { RTS();                      } break;
    case 0x61: /* ADC_zpxind */  { LD_ZPXIND(); ADC();         } break;
    case 0x62: /* CLA */         { CL_REG(A);                  } break;
    case 0x63: /* ILL_63 */      { ILL();                      } break;
    case 0x64: /* STZ_zp */      { ST_ZP(0);                   } break;
    case 0x65: /* ADC_zp */      { LD_ZP();     ADC();         } break;
    case 0x66: /* ROR_zp */      { LD_ZP();   ROR(); WR_ZP();  } break;
    case 0x67: /* RMB6 */        { RMB(6);                     } break;
    case 0x68: /* PLA */         { PL(A);                      } break;
    case 0x69: /* ADC_imm */     { LD_IMM();    ADC();         } break;
    case 0x6A: /* ROR_a */       { ROR_A();                    } break;
    case 0x6B: /* ILL_6B */      { ILL();                      } break;
    case 0x6C: /* JMP_absind */  { JMP_ABSIND();               } break;
    case 0x6D: /* ADC_abs */     { LD_ABS();    ADC();         } break;
    case 0x6E: /* ROR_abs */     { LD_ABS();  ROR(); WR_ABS(); } break;
    case 0x6F: /* BBR6 */        { BBR(6);                     } break;

    case 0x70: /* BVS */         { BR((P & V_FLAG) != 0);      } break;
    case 0x71: /* ADC_zpindy */  { LD_ZPINDY(); ADC();         } break;
    case 0x72: /* ADC_zpind */   { LD_ZPIND();  ADC();         } break;
    case 0x73: /* TII */         { TII();                      } break;
    case 0x74: /* STZ_zpx */     { ST_ZPX(0);                  } break;
    case 0x75: /* ADC_zpx */     { LD_ZPX();    ADC();         } break;
    case 0x76: /* ROR_zpx */     { LD_ZPX();  ROR(); WR_ZP();  } break;
    case 0x77: /* RMB7 */        { RMB(7);                     } break;
    case 0x78: /* SEI */         { SEI();                      } break;
    case 0x79: /* ADC_absy */    { LD_ABSY();   ADC();         } break;
    case 0x7A: /* PLY */         { PL(Y);                      } break;
    case 0x7B: /* ILL_7B */      { ILL();                      } break;
    case 0x7C: /* JMP_absxind */ { JMP_ABSXIND();              } break;
    case 0x7D: /* ADC_absx */    { LD_ABSX();   ADC();         } break;
    case 0x7E: /* ROR_absx */    { LD_ABSX(); ROR(); WR_ABS(); } break;
    case 0x7F: /* BBR7 */        { BBR(7);                     } break;

    case 0x80: /* BRA */         { BRA();                      } break;
    case 0x81: /* STA_zpxind */  { ST_ZPXIND(A);               } break;
    case 0x82: /* CLX */         { CL_REG(X);                  } break;
    case 0x83: /* TST_zp */      { LD_IMM_ZP();   TST();       } break;
    case 0x84: /* STY_zp */      { ST_ZP(Y);                   } break;
    case 0x85: /* STA_zp */      { ST_ZP(A);                   } break;
    case 0x86: /* STX_zp */      { ST_ZP(X);                   } break;
    case 0x87: /* SMB0 */        { SMB(0);                     } break;
    case 0x88: /* DEY */         { DEY();                      } break;
    case 0x89: /* BIT_imm */     { LD_IMM();    BIT();         } break;
    case 0x8A: /* TXA */         { TRN(X,A);                   } break;
    case 0x8B: /* ILL_8B */      { ILL();                      } break;
    case 0x8C: /* STY_abs */     { ST_ABS(Y);                  } break;
    case 0x8D: /* STA_abs */     { ST_ABS(A);                  } break;
    case 0x8E: /* STX_abs */     { ST_ABS(X);                  } break;
    case 0x8F: /* BBS0 */        { BBS(0);                     } break;

    case 0x90: /* BCC */         { BR((P & C_FLAG) == 0);      } break;
    case 0x91: /* STA_zpindy */  { ST_ZPINDY(A);               } break;
    case 0x92: /* STA_zpind */   { ST_ZPIND(A);                } break;
    case 0x93: /* TST_abs */     { LD_IMM_ABS();  TST();       } break;
    case 0x94: /* STY_zpx */     { ST_ZPX(Y);                  } break;
    case 0x95: /* STA_zpx */     { ST_ZPX(A);                  } break;
    case 0x96: /* STX_zpy */     { ST_ZPY(X);                  } break;
    case 0x97: /* SMB1 */        { SMB(1);                     } break;
    case 0x98: /* TYA */         { TRN(Y,A);                   } break;
    case 0x99: /* STA_absy */    { ST_ABSY(A);                 } break;
    case 0x9A: /* TXS */         { TXS();                      } break;
    case 0x9B: /* ILL_9B */      { ILL();                      } break;
    case 0x9C: /* STZ_abs */     { ST_ABS(0);                  } break;
    case 0x9D: /* STA_absx */    { ST_ABSX(A);                 } break;
    case 0x9E: /* STZ_absx */    { ST_ABSX(0);                 } break;
    case 0x9F: /* BBS1 */        { BBS(1);                     } break;

    case 0xA0: /* LDY_imm */     { LD_IMM();    LDY();         } break;
    case 0xA1: /* LDA_zpxind */  { LD_ZPXIND(); LDA();         } break;
    case 0xA2: /* LDX_imm */     { LD_IMM();    LDX();         } break;
    case 0xA3: /* TST_zpx */     { LD_IMM_ZPX();  TST();       } break;
    case 0xA4: /* LDY_zp */      { LD_ZP();     LDY();         } break;
    case 0xA5: /* LDA_zp */      { LD_ZP();     LDA();         } break;
    case 0xA6: /* LDX_zp */      { LD_ZP();     LDX();         } break;
    case 0xA7: /* SMB2 */        { SMB(2);                     } break;
    case 0xA8: /* TAY */         { TRN(A,Y);                   } break;
    case 0xA9: /* LDA_imm */     { LD_IMM();    LDA();         } break;
    case 0xAA: /* TAX */         { TRN(A,X);                   } break;
    case 0xAB: /* ILL_AB */      { ILL();                      } break;
    case 0xAC: /* LDY_abs */     { LD_ABS();    LDY();         } break;
    case 0xAD: /* LDA_abs */     { LD_ABS();    LDA();         } break;
    case 0xAE: /* LDX_abs */     { LD_ABS();    LDX();         } break;
    case 0xAF: /* BBS2 */        { BBS(2);                     } break;

    case 0xB0: /* BCS */         { BR((P & C_FLAG) != 0);      } break;
    case 0xB1: /* LDA_zpindy */  { LD_ZPINDY(); LDA();         } break;
    case 0xB2: /* LDA_zpind */   { LD_ZPIND();  LDA();         } break;
    case 0xB3: /* TST_absx */    { LD_IMM_ABSX(); TST();       } break;
    case 0xB4: /* LDY_zpx */     { LD_ZPX();    LDY();         } break;
    case 0xB5: /* LDA_zpx */     { LD_ZPX();    LDA();         } break;
    case 0xB6: /* LDX_zpy */     { LD_ZPY();    LDX();         } break;
    case 0xB7: /* SMB3 */        { SMB(3);                     } break;
    case 0xB8: /* CLV */         { CL_FLAG(V_FLAG);            } break;
    case 0xB9: /* LDA_absy */    { LD_ABSY();   LDA();         } break;
    case 0xBA: /* TSX */         { TRN(S,X);                   } break;
    case 0xBB: /* ILL_BB */      { ILL();                      } break;
    case 0xBC: /* LDY_absx */    { LD_ABSX();   LDY();         } break;
    case 0xBD: /* LDA_absx */    { LD_ABSX();   LDA();         } break;
    case 0xBE: /* LDX_absy */    { LD_ABSY();   LDX();         } break;
    case 0xBF: /* BBS3 */        { BBS(3);                     } break;

    case 0xC0: /* CPY_imm */     { LD_IMM();    CPY();         } break;
    case 0xC1: /* CMP_zpxind */  { LD_ZPXIND(); CMP();         } break;
    case 0xC2: /* CLY */         { CL_REG(Y);                  } break;
    case 0xC3: /* TDD */         { TDD();                      } break;
    case 0xC4: /* CPY_zp */      { LD_ZP();     CPY();         } break;
    case 0xC5: /* CMP_zp */      { LD_ZP();     CMP();         } break;
    case 0xC6: /* DEC_zp */      { LD_ZP();   DEC(); WR_ZP();  } break;
    case 0xC7: /* SMB4 */        { SMB(4);                     } break;
    case 0xC8: /* INY */         { INY();                      } break;
    case 0xC9: /* CMP_imm */     { LD_IMM();    CMP();         } break;
    case 0xCA: /* DEX */         { DEX();                      } break;
    case 0xCB: /* ILL_CB */      { ILL();                      } break;
    case 0xCC: /* CPY_abs */     { LD_ABS();    CPY();         } break;
    case 0xCD: /* CMP_abs */     { LD_ABS();    CMP();         } break;
    case 0xCE: /* DEC_abs */     { LD_ABS();  DEC(); WR_ABS(); } break;
    case 0xCF: /* BBS4 */        { BBS(4);                     } break;

    case 0xD0: /* BNE */         { BR((P & Z_FLAG) == 0);      } break;
    case 0xD1: /* CMP_zpindy */  { LD_ZPINDY(); CMP();         } break;
    case 0xD2: /* CMP_zpind */   { LD_ZPIND();  CMP();         } break;
    case 0xD3: /* TIN */         { TIN();                      } break;
    case 0xD4: /* CSH */         { CSH();                      } break;
    case 0xD5: /* CMP_zpx */     { LD_ZPX();    CMP();         } break;
    case 0xD6: /* DEC_zpx */     { LD_ZPX();  DEC(); WR_ZP();  } break;
    case 0xD7: /* SMB5 */        { SMB(5);                     } break;
    case 0xD8: /* CLD */         { CL_FLAG(D_FLAG);            } break;
    case 0xD9: /* CMP_absy */    { LD_ABSY();   CMP();         } break;
    case 0xDA: /* PHX */         { PH(X);                      } break;
    case 0xDB: /* ILL_DB */      { ILL();                      } break;
    case 0xDC: /* ILL_DC */      { ILL();                      } break;
    case 0xDD: /* CMP_absx */    { LD_ABSX();   CMP();         } break;
    case 0xDE: /* DEC_absx */    { LD_ABSX(); DEC(); WR_ABS(); } break;
    case 0xDF: /* BBS5 */        { BBS(5);                     } break;

    case 0xE0: /* CPX_imm */     { LD_IMM();    CPX();         } break;
    case 0xE1: /* SBC_zpxind */  { LD_ZPXIND(); SBC();         } break;
    case 0xE2: /* ILL_E2 */      { ILL();                      } break;
    case 0xE3: /* TIA */         { TIA();                      } break;
    case 0xE4: /* CPX_zp */      { LD_ZP();     CPX();         } break;
    case 0xE5: /* SBC_zp */      { LD_ZP();     SBC();         } break;
    case 0xE6: /* INC_zp */      { LD_ZP();   INC(); WR_ZP();  } break;
    case 0xE7: /* SMB6 */        { SMB(6);                     } break;
    case 0xE8: /* INX */         { INX();                      } break;
    case 0xE9: /* SBC_imm */     { LD_IMM();    SBC();         } break;
    case 0xEA: /* NOP */         { NOP();                      } break;
    case 0xEB: /* ILL_EB */      { ILL();                      } break;
    case 0xEC: /* CPX_abs */     { LD_ABS();    CPX();         } break;
    case 0xED: /* SBC_abs */     { LD_ABS();    SBC();         } break;
    case 0xEE: /* INC_abs */     { LD_ABS();  INC(); WR_ABS(); } break;
    case 0xEF: /* BBS6 */        { BBS(6);                     } break;

    case 0xF0: /* BEQ */         { BR((P & Z_FLAG) != 0);      } break;
    case 0xF1: /* SBC_zpindy */  { LD_ZPINDY(); SBC();         } break;
    case 0xF2: /* SBC_zpind */   { LD_ZPIND();  SBC();         } break;
    case 0xF3: /* TAI */         { TAI();                      } break;
    case 0xF4: /* SET */         { SET();                      } break;
    case 0xF5: /* SBC_zpx */     { LD_ZPX();    SBC();         } break;
    case 0xF6: /* INC_zpx */     { LD_ZPX();  INC(); WR_ZP();  } break;
    case 0xF7: /* SMB7 */        { SMB(7);                     } break;
    case 0xF8: /* SED */         { SED();                      } break;
    case 0xF9: /* SBC_absy */    { LD_ABSY();   SBC();         } break;
    case 0xFA: /* PLX */         { PL(X);                      } break;
    case 0xFB: /* ILL_FB */      { ILL();                      } break;
    case 0xFC: /* ILL_FC */      { ILL();                      } break;
    case 0xFD: /* SBC_absx */    { LD_ABSX();   SBC();         } break;
    case 0xFE: /* INC_absx */    { LD_ABSX(); INC(); WR_ABS(); } break;
    case 0xFF: /* BBS7 */        { BBS(7);                     } break;
