
/************************************

  PicchioEngine

  Copyright(c)2008 Emanuele Bettidi

************************************/

/* Video.cpp */

#include <ios>
#include <iostream>
#include <SDL/SDL.h>
#include <SDL/SDL_opengl.h>
#include "Types.h"
#include "Config.h"
#include "Video.h"

namespace Video
{
 SDL_Surface *screen = 0;
 int width;
 int height;
 // int bitsperpixel;
 Uint32 flags;

 GLint vp_x;
 GLint vp_y;
 GLsizei vp_width;
 GLsizei vp_height;

 GLdouble left;
 GLdouble right;
 GLdouble bottom;
 GLdouble top;
 GLdouble edge;

 GLuint texture2D;

 bool overscan;
 int  scale;
 bool fullscreen;
 bool stretch;
 bool bilinear;

 uint32 buffer[1365 * 263];  // 1365 x 263 = 358995 pixels

 bool init()
 {
  overscan   = Config::read_setting("overscan");
  scale      = Config::read_setting("scale");
  fullscreen = Config::read_setting("fullscreen");
  stretch    = Config::read_setting("stretch");
  bilinear   = Config::read_setting("bilinear");

  for (int i = 0; i < (1365 * 263); i++) buffer[i] = 0xFF000000;

  SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
  SDL_GL_SetAttribute(SDL_GL_SWAP_CONTROL, 0);

  if (fullscreen == true)
  {
   width = 0;
   height = 0;
   flags = SDL_OPENGL | SDL_FULLSCREEN;
  }
  else // window mode
  {
   if (overscan == false)
   {
    // tv (298+(2/3))x224 (896/3)x224
    width = (896 * scale) / 3;
    height = 224 * scale;
    edge = (376 - ((GLdouble)(width * 376) / (scale * 324))) / 2;
    left = (69 + edge) * 3;
    right = (69 + 376 - edge) * 3;
    bottom = (GLdouble)(263 - 252);
    top = (GLdouble)(263 - 28);
   }
   else
   {
    // overscan 324x243
    width = 324 * scale;
    height = 243 * scale;
    left = (GLdouble)(69 * 3);
    right = (GLdouble)((69 + 376) * 3);
    bottom = (GLdouble)(263 - 260);
    top = (GLdouble)(263 - 17);
   }
   vp_width = width;
   vp_height = height;
   flags = SDL_OPENGL;
  }

  screen = SDL_SetVideoMode(width, height, 0, flags);
  if (screen == 0) return false;
  SDL_WM_SetCaption("PicchioEngine v0.0.8", "PicchioEngine v0.0.8");
  SDL_ShowCursor(SDL_DISABLE);

  if (fullscreen == true)
  {
   width = screen->w;
   height = screen->h;
   if (stretch == false)
   {
    if (overscan == false)
    {
     scale = ((width + 1) * 3) / 896;
     if ((((width + 1) * 3) % 896) == 0) scale--;
     if (scale > (height / 224)) scale = height / 224;
     if (scale == 0)
     {
      SDL_SetError("The screen resolution must be at least of 298x224 pixels");
      return false;
     }
     vp_width = (896 * scale) / 3;
     vp_height = 224 * scale;
     edge = (376 - ((GLdouble)(vp_width * 376) / (scale * 324))) / 2;
     left = (69 + edge) * 3;
     right = (69 + 376 - edge) * 3;
     bottom = (GLdouble)(263 - 252);
     top = (GLdouble)(263 - 28);
    }
    else
    {
     if ((width * 3) < (height * 4))
     {
      scale = width / 324;
     }
     else
     {
      scale = height / 243;
     }
     if (scale == 0)
     {
      SDL_SetError("The screen resolution must be at least of 324x243 pixels");
      return false;
     }
     vp_width = 324 * scale;
     vp_height = 243 * scale;
     left = (GLdouble)(69 * 3);
     right = (GLdouble)((69 + 376) * 3);
     bottom = (GLdouble)(263 - 260);
     top = (GLdouble)(263 - 17);
    }
   }
   else
   {
    if (overscan == false)
    {
     if ((width * 3) < (height * 4))
     {
      vp_width = width;
      vp_height = (width * 3) / 4;
      edge = (376 - ((GLdouble)(896 * 376) / (3 * 324))) / 2;
      left = (69 + edge) * 3;
      right = (69 + 376 - edge) * 3;
      edge = (224 - ((GLdouble)(vp_height * 896) / (vp_width * 3))) / 2;
      bottom = (263 - 252) + edge;
      top = (263 - 28) - edge;
     }
     else
     {
      vp_width = (height * 4) / 3;
      vp_height = height;
      edge = (376 - ((GLdouble)(vp_width * 896 * 376) / (vp_height * 4 * 324))) / 2;
      left = (69 + edge) * 3;
      right = (69 + 376 - edge) * 3;
      bottom = (GLdouble)(263 - 252);
      top = (GLdouble)(263 - 28);
     }
    }
    else
    {
     if ((width * 3) < (height * 4))
     {
      vp_width = width;
      vp_height = (width * 3) / 4;
      edge = (243 - ((GLdouble)(vp_height * 324) / vp_width)) / 2;
      left = (GLdouble)(69 * 3);
      right = (GLdouble)((69 + 376) * 3);
      bottom = (263 - 260) + edge;
      top = (263 - 17) - edge;
     }
     else
     {
      vp_width = (height * 4) / 3;
      vp_height = height;
      edge = (376 - ((GLdouble)(vp_width * 3 * 376) / (vp_height * 4))) / 2;
      left = (69 + edge) * 3;
      right = (69 + 376 - edge) * 3;
      bottom = (GLdouble)(263 - 260);
      top = (GLdouble)(263 - 17);
     }
    }
   }
  }

  glDisable(GL_DITHER);
  glDisable(GL_ALPHA_TEST);  // not necessary but for safety...
  glDisable(GL_DEPTH_TEST);  // not necessary but for safety...
  glDepthMask(GL_FALSE);     // necessary?
  glShadeModel(GL_FLAT);

  vp_x = (width - vp_width) / 2;
  vp_y = (height - vp_height) / 2;
  glViewport(vp_x, vp_y, vp_width, vp_height);

  glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
  glClear(GL_COLOR_BUFFER_BIT);
  SDL_GL_SwapBuffers();
  glClear(GL_COLOR_BUFFER_BIT);

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(left, right, bottom, top, -1.0, 1.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  glEnable(GL_TEXTURE_RECTANGLE_ARB);
  glGenTextures(1, &texture2D);
  glBindTexture(GL_TEXTURE_RECTANGLE_ARB, texture2D);
  glTexParameteri(GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
  glTexParameteri(GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
  glTexParameteri(GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MAG_FILTER, bilinear ? GL_LINEAR : GL_NEAREST);
  glTexParameteri(GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MIN_FILTER, bilinear ? GL_LINEAR : GL_NEAREST);
  glTexImage2D(GL_TEXTURE_RECTANGLE_ARB, 0, GL_RGBA, 1365, 263, 0, GL_RGBA, GL_UNSIGNED_BYTE, 0);

  glFinish();

  std::cout << "  video mode: " 
            << screen->w << "x" << screen->h << ", "
            << (uint)screen->format->BitsPerPixel << "bpp" 
            << std::endl;
  return true;
 }

 void deinit()
 {
  glDeleteTextures(1, &texture2D);
 }

 void update()
 {
  glTexSubImage2D(GL_TEXTURE_RECTANGLE_ARB, 0, 0, 0, 1365, 263, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
  glBegin(GL_QUADS);
    glTexCoord2f(   0.0f, 263.0f); glVertex3f(   0.0f,   0.0f, 0.0f);
    glTexCoord2f(1365.0f, 263.0f); glVertex3f(1365.0f,   0.0f, 0.0f);
    glTexCoord2f(1365.0f,   0.0f); glVertex3f(1365.0f, 263.0f, 0.0f);
    glTexCoord2f(   0.0f,   0.0f); glVertex3f(   0.0f, 263.0f, 0.0f);
  glEnd();
  SDL_GL_SwapBuffers();
 }

 void redraw()
 {
  glBegin(GL_QUADS);
    glTexCoord2f(   0.0f, 263.0f); glVertex3f(   0.0f,   0.0f, 0.0f);
    glTexCoord2f(1365.0f, 263.0f); glVertex3f(1365.0f,   0.0f, 0.0f);
    glTexCoord2f(1365.0f,   0.0f); glVertex3f(1365.0f, 263.0f, 0.0f);
    glTexCoord2f(   0.0f,   0.0f); glVertex3f(   0.0f, 263.0f, 0.0f);
  glEnd();
  SDL_GL_SwapBuffers();
 }
}
