
/************************************

  PicchioEngine

  Copyright(c)2008 Emanuele Bettidi

************************************/

/* Gamepads.cpp */

/* Gamepads - Pad, TurboPad, AvenuePad6 */

#include "Types.h"
#include "Gamepads.h"

gamepad_t Gamepad[5];

void gamepad_t::init()
{
 clr_line = 1;
 sel_line = 1;
 buttons = 0x0FFF;
 mode = MODE_A;
 slow = OFF;
 counter = 0;
 i_turbo = 0;
 ii_turbo = 0;
}

uint8 gamepad_t::read()
{
 if (clr_line == 1) return 0;
 uint16 data = buttons;
 if ((counter & i_turbo)  != 0) data |= I;
 if ((counter & ii_turbo) != 0) data |= II;
 if (slow == ON)
 {
  if ((counter & 2) != 0) data &= ~RUN; else data |= RUN;
 }
 if (mode == MODE_A)
 {
  if (sel_line == 1) data >>= 4;
 }
 else
 {
  if ((counter & 1) == 0)
  {
   if (sel_line == 1) data >>= 4;
  }
  else
  {
   if (sel_line == 0) data >>= 8; else data >>= 12;
  }
 }
 return (data & 0xF);
}

void gamepad_t::write(uint8 new_clr_line, uint8 new_sel_line)
{
 if ((clr_line == 0) && (new_clr_line == 1))
 {
  counter++;
  counter &= 0xF;
 }
 clr_line = new_clr_line;
 sel_line = new_sel_line;
}
