
/************************************

  PicchioEngine

  Copyright(c)2008 Emanuele Bettidi

************************************/

/* MultiTap.cpp */

/* MultiTap/TurboTap */

#include "Types.h"
#include "Config.h"
#include "Gamepads.h"
#include "MultiTap.h"

namespace MultiTap
{
 uint8 read_port(uint8 port);
 void write_port(uint8 port, uint8 clr_line, uint8 sel_line);

 uint8 shift_reg;
 uint8 clr_line;
 uint8 sel_line;

 int Port[5];

 void init()
 {
  Port[0] = Config::read_setting("multitap.port_1");
  Port[1] = Config::read_setting("multitap.port_2");
  Port[2] = Config::read_setting("multitap.port_3");
  Port[3] = Config::read_setting("multitap.port_4");
  Port[4] = Config::read_setting("multitap.port_5");
  shift_reg = 1;
  clr_line = 1;
  sel_line = 1;
 }

 uint8 read_port(uint8 port)
 {
  switch(Port[port])
  {
   case 0: /* none       */ return 0x0F;
   case 1: /* pcepad     */ return Gamepad[port].read();
   case 2: /* turbopad   */ return Gamepad[port].read();
   case 3: /* avenuepad6 */ return Gamepad[port].read();
  }
  return 0x0F;
 }

 void write_port(uint8 port, uint8 clr_line, uint8 sel_line)
 {
  switch(Port[port])
  {
   case 0: /* none       */                                          break;
   case 1: /* pcepad     */ Gamepad[port].write(clr_line, sel_line); break;
   case 2: /* turbopad   */ Gamepad[port].write(clr_line, sel_line); break;
   case 3: /* avenuepad6 */ Gamepad[port].write(clr_line, sel_line); break;
  }
 }

 uint8 read()
 {
  uint8 data = 0;
  uint8 temp = shift_reg;
  for (uint8 i = 0; i < 5; i++)
  {
   if ((temp & 1) != 0) data |= read_port(i);
   temp >>= 1;
  }
  return data;
 }

 void write(uint8 new_clr_line, uint8 new_sel_line)
 {
  if (new_clr_line == 1)
   shift_reg = 1;
  else
  {
   if ((sel_line == 0) && (new_sel_line == 1))
   {
    if (clr_line == 1)
     shift_reg = 3;
    else
    {
     shift_reg <<= 1;
     shift_reg &= 0x1F;
    }
   }
  }
  clr_line = new_clr_line;
  sel_line = new_sel_line;

  uint8 temp = shift_reg;
  for (uint8 i = 0; i < 5; i++)
  {
   if ((temp & 1) != 0)
    write_port(i, 0, sel_line);
   else
    write_port(i, 1, 1);
   temp >>= 1;
  }
 }
}
