
/************************************

  PicchioEngine

  Copyright(c)2008 Emanuele Bettidi

************************************/

/* Timer.cpp */

/* HuC6280 - Timer */

#include "Types.h"
#include "Config.h"
#include "CPU.h"
#include "IntCtrl.h"
#include "Timer.h"

namespace Timer
{
 void reset();

 int32 clock;
 uint8 phase;  // Phase between CPU and Timer. Can be 0, 1 or 2 with same probability.
               // The phase is variable because CPU and Timer use different frequency dividers.
               // The phase is established at the power-up and doesn't vary after a RESET.
 int32 tail;  // reload tail

 /* registers */
 uint8 value;    // timer reload register
 uint8 enable;   // timer enable register
 uint8 count;    // internal counter register
 int32 divider;  // internal divider register

 // const int32 RELOAD_CYCLE = 2;

 void init()
 {
  clock = 0;
  phase = Config::read_setting("timer_phase");
  value = 0x7F;
  count = 0x7F;
  reset();
 }

 void reset()
 {
  tail = -1;
  enable = 0;
  divider = 1023;
 }

 void resync()
 {
  int32 run_time = clock - CPU::clock;
  if (run_time != 0)
  {
   clock -= run_time;
   if ((int8)count < 0)
   {
    count = value;
    IntCtrl::status |= 0x04;
    tail = 2 + 1;
   }
   if (tail >= 0)
   {
    tail -= run_time;
    int32 tirq_delay = (phase & 1) + (CPU::cycle_length >> 2);
    if (tail <= (2 - tirq_delay)) CPU::IRQ_lines |= (IntCtrl::status & 0x04);
   }
   if (enable == 0)
   {
    if (divider > 2) return;
    if (run_time > 7) run_time = 7;
   }
   divider -= run_time;
   while(divider < 0)
   {
    divider += 1024;
    count--;
    if ((int8)count < 0)
    {
     if (divider != 1023)
     {
      count = value;
      IntCtrl::status |= 0x04;
      tail = divider - 1022 + 2;
      int32 tirq_delay = (phase & 1) + (CPU::cycle_length >> 2);
      if (tail <= (2 - tirq_delay)) CPU::IRQ_lines |= 0x04;
     }
    }
   }
  }
 }

 uint8 read()
 {
  resync();
  return (count & 0x7F);
 }

 void write(uint8 reg, uint8 data)
 {
  resync();
  int32 delay = (phase >> 1) - (((phase >> 1) | phase) & (CPU::cycle_length >> 2));
  switch (reg & 0x01)
  {
   case 0: value = data & 0x7F;
           if (tail >= (2 + delay)) count = value;
           break;
   case 1: if (enable == 0)
           {
            if ((data & 0x01) != 0)
            {
             divider = 1025 + delay;
             count = value;
             enable = 1;
            }
           }
           else
           {
            if ((data & 0x01) == 0)
            {
             divider -= delay;
             if ((divider <= 512) && (divider >= 1)) divider = 1;
             divider += delay;
             enable = 0;
            }
           }
           break;
  }
 }

}
