/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import beanes.BeaNES;
import beanes.JoypadInput;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class ControllersPanel
extends JFrame {
    BeaNES nes;
    JButton saveButton = new JButton("Save");
    JButton cancelButton = new JButton("Cancel");
    JTextField[][] inputs = new JTextField[2][8];
    int[][] buttonMap = new int[2][8];

    public ControllersPanel(BeaNES nes) {
        this.nes = nes;
        this.setTitle("Configure Controls");
        this.setLayout(new BorderLayout());
        JTabbedPane controlPanels = new JTabbedPane();
        JPanel buttonPanel = new JPanel();
        JPanel cPanel1 = this.buildControllerPanel(0);
        JPanel cPanel2 = this.buildControllerPanel(1);
        controlPanels.addTab("Controller 1", cPanel1);
        controlPanels.addTab("Controller 2", cPanel2);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.saveButton);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (int cnum = 0; cnum <= 1; ++cnum) {
                    ControllersPanel.this.getNES().getJoypadInput(cnum).unbindKeys();
                    for (int button = 0; button < ControllersPanel.this.buttonMap[cnum].length; ++button) {
                        if (ControllersPanel.this.buttonMap[cnum][button] != -1) {
                            ControllersPanel.this.getNES().getJoypadInput(cnum).bindKey(ControllersPanel.this.buttonMap[cnum][button], button);
                        }
                        String key = "controls[" + cnum + "][" + button + "]";
                        String value = String.valueOf(ControllersPanel.this.buttonMap[cnum][button]);
                        ControllersPanel.this.getNES();
                        BeaNES.getProperties().setProperty(key, value);
                    }
                }
                ControllersPanel.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControllersPanel.this.dispose();
            }
        });
        this.add((Component)controlPanels, "Center");
        this.add((Component)buttonPanel, "South");
        this.setSize(400, 460);
        this.setVisible(true);
    }

    private BeaNES getNES() {
        return this.nes;
    }

    public JPanel buildControllerPanel(final int num) {
        JoypadInput joypad = this.nes.getJoypadInput(num);
        JPanel panel = new JPanel();
        JPanel inputContainer = new JPanel();
        JPanel inputPanel = new JPanel();
        NESControllerPanel cPanel = new NESControllerPanel();
        inputPanel.setLayout(new GridLayout(8, 2));
        JLabel labelUp = new JLabel("Up");
        JLabel labelDown = new JLabel("Down");
        JLabel labelLeft = new JLabel("Left");
        JLabel labelRight = new JLabel("Right");
        JLabel labelSelect = new JLabel("Select");
        JLabel labelStart = new JLabel("Start");
        JLabel labelB = new JLabel("B");
        JLabel labelA = new JLabel("A");
        for (int button = 0; button < this.inputs[num].length; ++button) {
            final int fbutton = button;
            this.buttonMap[num][button] = joypad.getBoundedKey(button);
            String inputText = joypad.getBoundedKey(button) == -1 ? "" : KeyEvent.getKeyText(joypad.getBoundedKey(button));
            this.inputs[num][button] = new JTextField(10);
            this.inputs[num][button].setText(inputText);
            this.inputs[num][button].setEditable(false);
            this.inputs[num][button].addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    ControllersPanel.this.inputs[num][fbutton].setText(KeyEvent.getKeyText(e.getKeyCode()));
                    for (int i = 0; i < ControllersPanel.this.inputs.length; ++i) {
                        for (int j = 0; j < ControllersPanel.this.inputs[i].length; ++j) {
                            if (ControllersPanel.this.buttonMap[i][j] != e.getKeyCode() || num == i && fbutton == j) continue;
                            ControllersPanel.this.buttonMap[i][j] = -1;
                            ControllersPanel.this.inputs[i][j].setText("");
                        }
                    }
                    ControllersPanel.this.buttonMap[num][fbutton] = e.getKeyCode();
                }
            });
        }
        inputPanel.add(labelUp);
        inputPanel.add(this.inputs[num][4]);
        inputPanel.add(labelDown);
        inputPanel.add(this.inputs[num][5]);
        inputPanel.add(labelLeft);
        inputPanel.add(this.inputs[num][6]);
        inputPanel.add(labelRight);
        inputPanel.add(this.inputs[num][7]);
        inputPanel.add(labelSelect);
        inputPanel.add(this.inputs[num][2]);
        inputPanel.add(labelStart);
        inputPanel.add(this.inputs[num][3]);
        inputPanel.add(labelB);
        inputPanel.add(this.inputs[num][1]);
        inputPanel.add(labelA);
        inputPanel.add(this.inputs[num][0]);
        inputContainer.add(inputPanel);
        panel.add((Component)inputContainer, "Center");
        panel.add((Component)cPanel, "South");
        return panel;
    }

    private JTextField getTextInputs(int num, int button) {
        return this.inputs[num][button];
    }

    private class NESControllerPanel
    extends JPanel {
        private Image img;

        public NESControllerPanel() {
            ClassLoader cl = this.getClass().getClassLoader();
            ImageIcon icon = new ImageIcon(cl.getResource("images/NESController.jpg"));
            this.img = icon.getImage();
            Dimension size = new Dimension(this.img.getWidth(null), this.img.getHeight(null));
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            this.setSize(size);
            this.setLayout(null);
        }

        public void paintComponent(Graphics g) {
            g.drawImage(this.img, 0, 0, null);
        }
    }
}

