/*
 * Decompiled with CFR 0.152.
 */
package beanes;

import beanes.BeaNES;

public class CPU {
    private BeaNES nes;
    public static int CPU_MEMORY_SIZE = 65536;
    public static double FREQUENCY = 1789772.5;
    public short[] cpuMemory;
    private short[] opcodeCycles;
    private short[] opcodeSizes;
    private short[] opcodeModes;
    private String[] opcodeNames;
    private String[] addressModeNames;
    private int numCyclesRan;
    private int numInstructionsRan;
    private int debugCounter;
    private int debugInitialInput;
    private int[] joypadsStrobeCount = new int[2];
    private int[] joypadLastWrite = new int[2];
    private int irqRequestType;
    private boolean irqRequested;
    public int regACC;
    public int regX;
    public int regY;
    public int regPC;
    public int regSP;
    public int flagCarry;
    public int flagZero;
    public int flagInterrupt;
    public int flagDecimal;
    public int flagBreak;
    public int flagNotUsed;
    public int flagOverflow;
    public int flagSign;
    public static final int IRQ_NORMAL = 0;
    public static final int IRQ_NMI = 1;
    public static final int IRQ_RESET = 2;
    private static final int ADDR_ZP = 0;
    private static final int ADDR_ZP_X = 1;
    private static final int ADDR_ZP_Y = 2;
    private static final int ADDR_ABS = 3;
    private static final int ADDR_ABS_X = 4;
    private static final int ADDR_ABS_Y = 5;
    private static final int ADDR_IMPLIED = 6;
    private static final int ADDR_ACC = 7;
    private static final int ADDR_IMMEDIATE = 8;
    private static final int ADDR_INDIR = 9;
    private static final int ADDR_INDIR_X = 10;
    private static final int ADDR_INDIR_Y = 11;
    private static final int ADDR_RELATIVE = 12;

    public CPU(BeaNES nes) {
        this.nes = nes;
        this.initOpcodes();
        this.cpuMemory = new short[CPU_MEMORY_SIZE];
        this.hardReset();
    }

    public void reset() {
        this.regACC = 0;
        this.regX = 0;
        this.regY = 0;
        this.regPC = 49152;
        this.regSP = 511;
        this.flagCarry = 0;
        this.flagZero = 0;
        this.flagInterrupt = 1;
        this.flagDecimal = 0;
        this.flagBreak = 0;
        this.flagNotUsed = 1;
        this.flagOverflow = 0;
        this.flagSign = 0;
        this.requestIRQ(2);
    }

    public void hardReset() {
        this.numCyclesRan = 0;
        this.numInstructionsRan = 0;
        this.debugCounter = 0;
        this.debugInitialInput = 0;
        this.joypadsStrobeCount[0] = 0;
        this.joypadsStrobeCount[1] = 0;
        this.joypadLastWrite[0] = -1;
        this.joypadLastWrite[1] = -1;
        this.irqRequestType = 0;
        this.irqRequested = false;
        this.reset();
    }

    public int getFlags() {
        int flags = 0;
        flags = this.flagSign;
        flags = flags << 1 | this.flagOverflow;
        flags = flags << 1 | this.flagNotUsed;
        flags = flags << 1 | this.flagDecimal;
        flags = flags << 1 | this.flagInterrupt;
        flags = flags << 1 | this.flagZero;
        flags = flags << 1 | this.flagCarry;
        return flags;
    }

    public void processIRQ() {
        if (this.irqRequested) {
            int temp = 0;
            temp = this.flagSign | temp << 1;
            temp = this.flagOverflow | temp << 1;
            temp = this.flagNotUsed | temp << 1;
            temp = this.flagBreak | temp << 1;
            temp = this.flagDecimal | temp << 1;
            temp = this.flagInterrupt | temp << 1;
            temp = this.flagZero | temp << 1;
            temp = this.flagCarry | temp << 1;
            switch (this.irqRequestType) {
                case 0: {
                    if (this.flagInterrupt != 0) break;
                    this.push((short)(this.regPC >> 8 & 0xFF));
                    this.push((short)(this.regPC & 0xFF));
                    this.push((short)temp);
                    this.flagInterrupt = 1;
                    this.flagBreak = 0;
                    this.regPC = this.read(65534) | this.read(65535) << 8 & 0xFF00;
                    break;
                }
                case 1: {
                    this.push((short)(this.regPC >> 8 & 0xFF));
                    this.push((short)(this.regPC & 0xFF));
                    this.push((short)temp);
                    this.regPC = this.read(65530) | this.read(65531) << 8 & 0xFF00;
                    break;
                }
                case 2: {
                    this.regPC = this.read(65532) | this.read(65533) << 8 & 0xFF00;
                }
            }
            this.irqRequested = false;
        }
    }

    private int processAddressingMode(int addressingMode) {
        int address = 0;
        switch (addressingMode) {
            case 0: {
                address = this.read(this.regPC) & 0xFF;
                ++this.regPC;
                break;
            }
            case 1: {
                address = this.read(this.regPC) + this.regX & 0xFF;
                ++this.regPC;
                break;
            }
            case 2: {
                address = this.read(this.regPC) + this.regY & 0xFF;
                ++this.regPC;
                break;
            }
            case 3: {
                address = this.read(this.regPC) | this.read(this.regPC + 1) << 8 & 0xFF00;
                ++this.regPC;
                ++this.regPC;
                break;
            }
            case 4: {
                address = (this.read(this.regPC) | this.read(this.regPC + 1) << 8 & 0xFF00) + this.regX & 0xFFFF;
                ++this.regPC;
                ++this.regPC;
                break;
            }
            case 5: {
                address = (this.read(this.regPC) | this.read(this.regPC + 1) << 8 & 0xFF00) + this.regY & 0xFFFF;
                ++this.regPC;
                ++this.regPC;
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                address = this.regACC;
                break;
            }
            case 8: {
                address = this.regPC++;
                break;
            }
            case 9: {
                address = this.read(this.regPC) | this.read(this.regPC + 1) << 8 & 0xFF00;
                address = this.read(address) | this.read(address + 1) << 8 & 0xFF00;
                ++this.regPC;
                ++this.regPC;
                break;
            }
            case 10: {
                address = this.regX + this.read(this.regPC) & 0xFF;
                ++this.regPC;
                this.regPC &= 0xFFFF;
                address = (this.read(address) | this.read(address + 1) << 8 & 0xFF00) & 0xFFFF;
                break;
            }
            case 11: {
                address = this.read(this.regPC);
                ++this.regPC;
                this.regPC &= 0xFFFF;
                address = this.read(address) | this.read(address + 1) << 8 & 0xFF00;
                address += this.regY;
                break;
            }
            case 12: {
                address = this.read(this.regPC);
                ++this.regPC;
                this.regPC &= 0xFFFF;
                address = address < 128 ? this.regPC + address : this.regPC + (address - 256);
            }
        }
        this.regPC &= 0xFFFF;
        return address &= 0xFFFF;
    }

    public int processNextInstruction() {
        boolean cyclesToWait = false;
        int address = 0;
        int temp = 0;
        this.regPC &= 0xFFFF;
        this.processIRQ();
        int opcode = this.read(this.regPC);
        short addressingMode = this.opcodeModes[opcode];
        short cycles = this.opcodeCycles[opcode];
        short size = this.opcodeSizes[opcode];
        ++this.regPC;
        this.regPC &= 0xFFFF;
        address = this.processAddressingMode(addressingMode);
        switch (opcode) {
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 117: 
            case 121: 
            case 125: {
                temp = this.read(address) + this.regACC + this.flagCarry;
                this.flagOverflow = ((this.regACC ^ this.read(address)) & 0x80) == 0 && ((this.regACC ^ temp) & 0x80) != 0 ? 1 : 0;
                this.flagCarry = temp > 255 ? 1 : 0;
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.regACC = temp & 0xFF;
                break;
            }
            case 33: 
            case 37: 
            case 41: 
            case 45: 
            case 49: 
            case 53: 
            case 57: 
            case 61: {
                temp = this.read(address) & this.regACC;
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.regACC = temp & 0xFF;
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 22: 
            case 30: {
                temp = addressingMode == 7 ? this.regACC : this.read(address);
                this.flagCarry = (temp & 0x80) >> 7 & 1;
                temp = temp << 1 & 0xFE;
                this.flagSign = temp >> 7 & 1;
                int n = this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                if (addressingMode == 7) {
                    this.regACC = temp;
                    break;
                }
                this.write(address, (short)temp);
                break;
            }
            case 36: 
            case 44: {
                temp = this.read(address);
                this.flagSign = temp >> 7 & 1;
                this.flagOverflow = temp >> 6 & 1;
                this.flagZero = ((temp &= this.regACC) & 0xFF) == 0 ? 1 : 0;
                break;
            }
            case 48: {
                if (this.flagSign == 0) break;
                this.regPC = address;
                break;
            }
            case 16: {
                if (this.flagSign != 0) break;
                this.regPC = address;
                break;
            }
            case 80: {
                if (this.flagOverflow != 0) break;
                this.regPC = address;
                break;
            }
            case 112: {
                if (this.flagOverflow == 0) break;
                this.regPC = address;
                break;
            }
            case 144: {
                if (this.flagCarry != 0) break;
                this.regPC = address;
                break;
            }
            case 176: {
                if (this.flagCarry == 0) break;
                this.regPC = address;
                break;
            }
            case 208: {
                if (this.flagZero != 0) break;
                this.regPC = address;
                break;
            }
            case 240: {
                if (this.flagZero == 0) break;
                this.regPC = address;
                break;
            }
            case 0: {
                ++this.regPC;
                this.push((short)(this.regPC >> 8 & 0xFF));
                this.push((short)(this.regPC & 0xFF));
                this.flagBreak = 1;
                temp = 0;
                temp = this.flagSign | temp << 1;
                temp = this.flagOverflow | temp << 1;
                temp = this.flagNotUsed | temp << 1;
                temp = this.flagBreak | temp << 1;
                temp = this.flagDecimal | temp << 1;
                temp = this.flagInterrupt | temp << 1;
                temp = this.flagZero | temp << 1;
                temp = this.flagCarry | temp << 1;
                this.push((short)temp);
                this.flagInterrupt = 1;
                this.regPC = this.read(65534) | this.read(65535) << 8 & 0xFF00;
                break;
            }
            case 193: 
            case 197: 
            case 201: 
            case 205: 
            case 209: 
            case 213: 
            case 217: 
            case 221: {
                temp = this.regACC - this.read(address);
                this.flagCarry = temp >= 0 ? 1 : 0;
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                break;
            }
            case 224: 
            case 228: 
            case 236: {
                temp = this.regX - this.read(address);
                this.flagCarry = temp >= 0 ? 1 : 0;
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                break;
            }
            case 192: 
            case 196: 
            case 204: {
                temp = this.regY - this.read(address);
                this.flagCarry = temp >= 0 ? 1 : 0;
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                break;
            }
            case 198: 
            case 206: 
            case 214: 
            case 222: {
                temp = this.read(address) - 1 & 0xFF;
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.write(address, (short)temp);
                break;
            }
            case 65: 
            case 69: 
            case 73: 
            case 77: 
            case 81: 
            case 85: 
            case 89: 
            case 93: {
                temp = (this.read(address) ^ this.regACC) & 0xFF;
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.regACC = temp;
                break;
            }
            case 24: {
                this.flagCarry = 0;
                break;
            }
            case 56: {
                this.flagCarry = 1;
                break;
            }
            case 88: {
                this.flagInterrupt = 0;
                break;
            }
            case 120: {
                this.flagInterrupt = 1;
                break;
            }
            case 184: {
                this.flagOverflow = 0;
                break;
            }
            case 216: {
                this.flagDecimal = 0;
                break;
            }
            case 248: {
                this.flagDecimal = 1;
                break;
            }
            case 230: 
            case 238: 
            case 246: 
            case 254: {
                temp = this.read(address) + 1 & 0xFF;
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.write(address, (short)temp);
                break;
            }
            case 76: 
            case 108: {
                this.regPC = address & 0xFFFF;
                break;
            }
            case 32: {
                this.push((short)(this.regPC - 1 >> 8 & 0xFF));
                this.push((short)(this.regPC - 1 & 0xFF));
                this.regPC = address;
                break;
            }
            case 161: 
            case 165: 
            case 169: 
            case 173: 
            case 177: 
            case 181: 
            case 185: 
            case 189: {
                temp = this.read(address);
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.regACC = temp;
                break;
            }
            case 162: 
            case 166: 
            case 174: 
            case 182: 
            case 190: {
                temp = this.read(address);
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.regX = temp;
                break;
            }
            case 160: 
            case 164: 
            case 172: 
            case 180: 
            case 188: {
                temp = this.read(address);
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.regY = temp;
                break;
            }
            case 70: 
            case 74: 
            case 78: 
            case 86: 
            case 94: {
                temp = addressingMode == 7 ? this.regACC : this.read(address);
                this.flagCarry = temp & 1;
                temp = temp >> 1 & 0x7F;
                this.flagSign = 0;
                int n = this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                if (addressingMode == 7) {
                    this.regACC = temp;
                    break;
                }
                this.write(address, (short)temp);
                break;
            }
            case 234: {
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 29: {
                temp = (this.regACC | this.read(address)) & 0xFF;
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.regACC = temp;
                break;
            }
            case 170: {
                this.regX = this.regACC;
                this.flagSign = this.regACC >> 7 & 1;
                this.flagZero = (this.regACC & 0xFF) == 0 ? 1 : 0;
                break;
            }
            case 138: {
                this.regACC = this.regX;
                this.flagSign = this.regACC >> 7 & 1;
                this.flagZero = (this.regACC & 0xFF) == 0 ? 1 : 0;
                break;
            }
            case 202: {
                temp = this.regX - 1 & 0xFF;
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.regX = temp;
                break;
            }
            case 232: {
                temp = this.regX + 1 & 0xFF;
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.regX = temp;
                break;
            }
            case 168: {
                this.regY = this.regACC;
                this.flagSign = this.regACC >> 7 & 1;
                this.flagZero = (this.regACC & 0xFF) == 0 ? 1 : 0;
                break;
            }
            case 152: {
                this.regACC = this.regY;
                this.flagSign = this.regACC >> 7 & 1;
                this.flagZero = (this.regACC & 0xFF) == 0 ? 1 : 0;
                break;
            }
            case 136: {
                temp = this.regY - 1 & 0xFF;
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.regY = temp;
                break;
            }
            case 200: {
                temp = this.regY + 1 & 0xFF;
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.regY = temp;
                break;
            }
            case 38: 
            case 42: 
            case 46: 
            case 54: 
            case 62: {
                temp = addressingMode == 7 ? this.regACC : this.read(address);
                int ncarry = temp >> 7 & 1;
                temp = temp << 1 & 0xFE | this.flagCarry;
                this.flagCarry = ncarry;
                this.flagSign = temp >> 7 & 1;
                int n = this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                if (addressingMode == 7) {
                    this.regACC = temp;
                    break;
                }
                this.write(address, (short)temp);
                break;
            }
            case 102: 
            case 106: 
            case 110: 
            case 118: 
            case 126: {
                int oldTemp = temp = addressingMode == 7 ? this.regACC : this.read(address);
                int lcarry = temp & 1;
                temp = temp >> 1 & 0x7F | this.flagCarry << 7 & 0xFF;
                this.flagCarry = lcarry;
                this.flagSign = temp >> 7 & 1;
                int n = this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                if (addressingMode == 7) {
                    this.regACC = temp;
                    break;
                }
                this.write(address, (short)temp);
                break;
            }
            case 64: {
                temp = this.pull();
                this.flagCarry = temp & 1;
                this.flagZero = temp >> 1 & 1;
                this.flagInterrupt = temp >> 2 & 1;
                this.flagDecimal = temp >> 3 & 1;
                this.flagBreak = temp >> 4 & 1;
                this.flagNotUsed = temp >> 5 & 1;
                this.flagOverflow = temp >> 6 & 1;
                this.flagSign = temp >> 7 & 1;
                this.regPC = this.pull() & 0xFF | this.pull() << 8 & 0xFF00;
                break;
            }
            case 96: {
                this.regPC = this.pull() & 0xFF | this.pull() << 8 & 0xFF00;
                ++this.regPC;
                break;
            }
            case 225: 
            case 229: 
            case 233: 
            case 237: 
            case 241: 
            case 245: 
            case 249: 
            case 253: {
                temp = this.regACC - this.read(address) - (1 - this.flagCarry);
                this.flagOverflow = ((this.regACC ^ this.read(address)) & 0x80) != 0 && ((this.regACC ^ temp) & 0x80) != 0 ? 1 : 0;
                this.flagCarry = temp < 0 ? 0 : 1;
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.regACC = temp & 0xFF;
                break;
            }
            case 129: 
            case 133: 
            case 141: 
            case 145: 
            case 149: 
            case 153: 
            case 157: {
                this.write(address, (short)this.regACC);
                break;
            }
            case 154: {
                this.regSP = this.regX + 256;
                break;
            }
            case 186: {
                temp = this.regSP - 256;
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.regX = temp;
                break;
            }
            case 72: {
                this.push((short)this.regACC);
                break;
            }
            case 104: {
                temp = this.pull();
                this.flagSign = temp >> 7 & 1;
                this.flagZero = (temp & 0xFF) == 0 ? 1 : 0;
                this.regACC = temp;
                break;
            }
            case 8: {
                this.flagBreak = 1;
                temp = 0;
                temp = this.flagSign | temp << 1;
                temp = this.flagOverflow | temp << 1;
                temp = this.flagNotUsed | temp << 1;
                temp = this.flagBreak | temp << 1;
                temp = this.flagDecimal | temp << 1;
                temp = this.flagInterrupt | temp << 1;
                temp = this.flagZero | temp << 1;
                temp = this.flagCarry | temp << 1;
                this.push((short)temp);
                break;
            }
            case 40: {
                temp = this.pull();
                this.flagCarry = temp & 1;
                this.flagZero = temp >> 1 & 1;
                this.flagInterrupt = temp >> 2 & 1;
                this.flagDecimal = temp >> 3 & 1;
                this.flagBreak = temp >> 4 & 1;
                this.flagNotUsed = temp >> 5 & 1;
                this.flagOverflow = temp >> 6 & 1;
                this.flagSign = temp >> 7 & 1;
                break;
            }
            case 134: 
            case 142: 
            case 150: {
                this.write(address, (short)this.regX);
                break;
            }
            case 132: 
            case 140: 
            case 148: {
                this.write(address, (short)this.regY);
                break;
            }
            default: {
                System.out.println("ILLEGAL OPCODE! " + Integer.toHexString(opcode));
                this.debugCounter = 0;
            }
        }
        if (this.debugCounter > 0) {
            --this.debugCounter;
        }
        ++this.numInstructionsRan;
        return this.opcodeSizes[opcode];
    }

    private int pull() {
        ++this.regSP;
        this.regSP = this.regSP & 0xFF | 0x100;
        return this.nes.getMapper().read(this.regSP);
    }

    private void push(short value) {
        this.nes.getMapper().write(this.regSP, value);
        --this.regSP;
        this.regSP = this.regSP & 0xFF | 0x100;
    }

    public int read(int address) {
        return this.nes.getMapper().read(address);
    }

    public void writeJoypadInput(int num, short value) {
        if (value == 0 && this.joypadLastWrite[0] == 1) {
            this.joypadsStrobeCount[0] = 0;
            this.joypadsStrobeCount[1] = 0;
        }
        this.joypadLastWrite[0] = value;
    }

    public short readJoypadInput(int num) {
        short value = 0;
        switch (this.joypadsStrobeCount[num]) {
            case 0: {
                value = (short)this.nes.getJoypadInput(num).getButtonState(0);
                break;
            }
            case 1: {
                value = (short)this.nes.getJoypadInput(num).getButtonState(1);
                break;
            }
            case 2: {
                value = (short)this.nes.getJoypadInput(num).getButtonState(2);
                break;
            }
            case 3: {
                value = (short)this.nes.getJoypadInput(num).getButtonState(3);
                break;
            }
            case 4: {
                value = (short)this.nes.getJoypadInput(num).getButtonState(4);
                break;
            }
            case 5: {
                value = (short)this.nes.getJoypadInput(num).getButtonState(5);
                break;
            }
            case 6: {
                value = (short)this.nes.getJoypadInput(num).getButtonState(6);
                break;
            }
            case 7: {
                value = (short)this.nes.getJoypadInput(num).getButtonState(7);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                value = 0;
                break;
            }
            case 18: {
                value = (short)(num != 0 ? 1 : 0);
                break;
            }
            case 19: {
                value = (short)(num == 0 ? 1 : 0);
                break;
            }
            default: {
                value = 0;
            }
        }
        int n = num;
        this.joypadsStrobeCount[n] = this.joypadsStrobeCount[n] + 1;
        if (this.joypadsStrobeCount[num] == 24) {
            this.joypadsStrobeCount[num] = 0;
        }
        return value;
    }

    public void requestIRQ(int irqType) {
        if (this.irqRequested && this.irqRequestType == 0) {
            return;
        }
        this.irqRequested = true;
        this.irqRequestType = irqType;
    }

    public void write(int address, short value) {
        this.nes.getMapper().write(address, value);
    }

    public void initOpcodes() {
        this.opcodeCycles = new short[256];
        this.opcodeSizes = new short[256];
        this.opcodeModes = new short[256];
        this.opcodeNames = new String[256];
        this.addressModeNames = new String[20];
        this.opcodeSizes[105] = 2;
        this.opcodeSizes[101] = 2;
        this.opcodeSizes[117] = 2;
        this.opcodeSizes[109] = 3;
        this.opcodeSizes[125] = 3;
        this.opcodeSizes[121] = 3;
        this.opcodeSizes[97] = 2;
        this.opcodeSizes[113] = 2;
        this.opcodeSizes[41] = 2;
        this.opcodeSizes[37] = 2;
        this.opcodeSizes[53] = 2;
        this.opcodeSizes[45] = 3;
        this.opcodeSizes[61] = 3;
        this.opcodeSizes[57] = 3;
        this.opcodeSizes[33] = 2;
        this.opcodeSizes[49] = 2;
        this.opcodeSizes[10] = 1;
        this.opcodeSizes[6] = 2;
        this.opcodeSizes[22] = 2;
        this.opcodeSizes[14] = 3;
        this.opcodeSizes[30] = 3;
        this.opcodeSizes[144] = 2;
        this.opcodeSizes[176] = 2;
        this.opcodeSizes[240] = 2;
        this.opcodeSizes[36] = 2;
        this.opcodeSizes[44] = 3;
        this.opcodeSizes[48] = 2;
        this.opcodeSizes[208] = 2;
        this.opcodeSizes[16] = 2;
        this.opcodeSizes[0] = 1;
        this.opcodeSizes[80] = 2;
        this.opcodeSizes[112] = 2;
        this.opcodeSizes[24] = 1;
        this.opcodeSizes[216] = 1;
        this.opcodeSizes[88] = 1;
        this.opcodeSizes[184] = 1;
        this.opcodeSizes[201] = 2;
        this.opcodeSizes[197] = 2;
        this.opcodeSizes[213] = 2;
        this.opcodeSizes[205] = 3;
        this.opcodeSizes[221] = 3;
        this.opcodeSizes[217] = 3;
        this.opcodeSizes[193] = 2;
        this.opcodeSizes[209] = 2;
        this.opcodeSizes[224] = 2;
        this.opcodeSizes[228] = 2;
        this.opcodeSizes[236] = 3;
        this.opcodeSizes[192] = 2;
        this.opcodeSizes[196] = 2;
        this.opcodeSizes[204] = 3;
        this.opcodeSizes[198] = 2;
        this.opcodeSizes[214] = 2;
        this.opcodeSizes[206] = 3;
        this.opcodeSizes[222] = 3;
        this.opcodeSizes[202] = 1;
        this.opcodeSizes[136] = 1;
        this.opcodeSizes[73] = 2;
        this.opcodeSizes[69] = 2;
        this.opcodeSizes[85] = 2;
        this.opcodeSizes[77] = 3;
        this.opcodeSizes[93] = 3;
        this.opcodeSizes[89] = 3;
        this.opcodeSizes[65] = 2;
        this.opcodeSizes[81] = 2;
        this.opcodeSizes[230] = 2;
        this.opcodeSizes[246] = 2;
        this.opcodeSizes[238] = 3;
        this.opcodeSizes[254] = 3;
        this.opcodeSizes[232] = 1;
        this.opcodeSizes[200] = 1;
        this.opcodeSizes[76] = 3;
        this.opcodeSizes[44] = 3;
        this.opcodeSizes[32] = 3;
        this.opcodeSizes[169] = 2;
        this.opcodeSizes[165] = 2;
        this.opcodeSizes[181] = 2;
        this.opcodeSizes[173] = 3;
        this.opcodeSizes[189] = 3;
        this.opcodeSizes[185] = 3;
        this.opcodeSizes[161] = 2;
        this.opcodeSizes[177] = 2;
        this.opcodeSizes[162] = 2;
        this.opcodeSizes[166] = 2;
        this.opcodeSizes[182] = 2;
        this.opcodeSizes[174] = 3;
        this.opcodeSizes[190] = 3;
        this.opcodeSizes[160] = 2;
        this.opcodeSizes[164] = 2;
        this.opcodeSizes[180] = 2;
        this.opcodeSizes[172] = 3;
        this.opcodeSizes[188] = 3;
        this.opcodeSizes[74] = 1;
        this.opcodeSizes[70] = 2;
        this.opcodeSizes[86] = 2;
        this.opcodeSizes[78] = 3;
        this.opcodeSizes[94] = 3;
        this.opcodeSizes[234] = 1;
        this.opcodeSizes[9] = 2;
        this.opcodeSizes[5] = 2;
        this.opcodeSizes[21] = 2;
        this.opcodeSizes[13] = 3;
        this.opcodeSizes[29] = 3;
        this.opcodeSizes[25] = 3;
        this.opcodeSizes[1] = 2;
        this.opcodeSizes[17] = 2;
        this.opcodeSizes[72] = 1;
        this.opcodeSizes[8] = 1;
        this.opcodeSizes[104] = 1;
        this.opcodeSizes[42] = 1;
        this.opcodeSizes[38] = 2;
        this.opcodeSizes[54] = 2;
        this.opcodeSizes[46] = 3;
        this.opcodeSizes[62] = 3;
        this.opcodeSizes[106] = 1;
        this.opcodeSizes[102] = 2;
        this.opcodeSizes[118] = 2;
        this.opcodeSizes[110] = 3;
        this.opcodeSizes[126] = 3;
        this.opcodeSizes[64] = 1;
        this.opcodeSizes[96] = 1;
        this.opcodeSizes[233] = 2;
        this.opcodeSizes[229] = 2;
        this.opcodeSizes[245] = 2;
        this.opcodeSizes[237] = 3;
        this.opcodeSizes[253] = 3;
        this.opcodeSizes[249] = 3;
        this.opcodeSizes[225] = 2;
        this.opcodeSizes[241] = 2;
        this.opcodeSizes[56] = 1;
        this.opcodeSizes[248] = 1;
        this.opcodeSizes[120] = 1;
        this.opcodeSizes[133] = 2;
        this.opcodeSizes[149] = 2;
        this.opcodeSizes[141] = 3;
        this.opcodeSizes[157] = 3;
        this.opcodeSizes[153] = 3;
        this.opcodeSizes[129] = 2;
        this.opcodeSizes[145] = 2;
        this.opcodeSizes[134] = 2;
        this.opcodeSizes[150] = 2;
        this.opcodeSizes[142] = 3;
        this.opcodeSizes[132] = 2;
        this.opcodeSizes[148] = 2;
        this.opcodeSizes[140] = 3;
        this.opcodeSizes[170] = 1;
        this.opcodeSizes[168] = 1;
        this.opcodeSizes[186] = 1;
        this.opcodeSizes[138] = 1;
        this.opcodeSizes[154] = 1;
        this.opcodeSizes[152] = 1;
        this.opcodeCycles[105] = 2;
        this.opcodeCycles[101] = 3;
        this.opcodeCycles[117] = 4;
        this.opcodeCycles[109] = 4;
        this.opcodeCycles[125] = 4;
        this.opcodeCycles[121] = 4;
        this.opcodeCycles[97] = 6;
        this.opcodeCycles[113] = 5;
        this.opcodeCycles[41] = 2;
        this.opcodeCycles[37] = 3;
        this.opcodeCycles[53] = 4;
        this.opcodeCycles[45] = 4;
        this.opcodeCycles[61] = 4;
        this.opcodeCycles[57] = 4;
        this.opcodeCycles[33] = 6;
        this.opcodeCycles[49] = 5;
        this.opcodeCycles[10] = 2;
        this.opcodeCycles[6] = 5;
        this.opcodeCycles[22] = 6;
        this.opcodeCycles[14] = 6;
        this.opcodeCycles[30] = 7;
        this.opcodeCycles[144] = 2;
        this.opcodeCycles[176] = 2;
        this.opcodeCycles[240] = 2;
        this.opcodeCycles[36] = 3;
        this.opcodeCycles[44] = 4;
        this.opcodeCycles[48] = 2;
        this.opcodeCycles[208] = 2;
        this.opcodeCycles[16] = 2;
        this.opcodeCycles[0] = 7;
        this.opcodeCycles[80] = 2;
        this.opcodeCycles[112] = 2;
        this.opcodeCycles[24] = 2;
        this.opcodeCycles[216] = 2;
        this.opcodeCycles[88] = 2;
        this.opcodeCycles[184] = 2;
        this.opcodeCycles[201] = 3;
        this.opcodeCycles[197] = 3;
        this.opcodeCycles[213] = 4;
        this.opcodeCycles[205] = 4;
        this.opcodeCycles[221] = 4;
        this.opcodeCycles[217] = 4;
        this.opcodeCycles[193] = 6;
        this.opcodeCycles[209] = 5;
        this.opcodeCycles[224] = 2;
        this.opcodeCycles[228] = 3;
        this.opcodeCycles[236] = 4;
        this.opcodeCycles[192] = 2;
        this.opcodeCycles[196] = 3;
        this.opcodeCycles[204] = 4;
        this.opcodeCycles[198] = 5;
        this.opcodeCycles[214] = 6;
        this.opcodeCycles[206] = 6;
        this.opcodeCycles[222] = 7;
        this.opcodeCycles[202] = 2;
        this.opcodeCycles[136] = 2;
        this.opcodeCycles[73] = 2;
        this.opcodeCycles[69] = 3;
        this.opcodeCycles[85] = 4;
        this.opcodeCycles[77] = 4;
        this.opcodeCycles[93] = 4;
        this.opcodeCycles[89] = 4;
        this.opcodeCycles[65] = 6;
        this.opcodeCycles[81] = 5;
        this.opcodeCycles[230] = 5;
        this.opcodeCycles[246] = 6;
        this.opcodeCycles[238] = 6;
        this.opcodeCycles[254] = 7;
        this.opcodeCycles[232] = 2;
        this.opcodeCycles[200] = 2;
        this.opcodeCycles[76] = 3;
        this.opcodeCycles[44] = 5;
        this.opcodeCycles[32] = 6;
        this.opcodeCycles[169] = 2;
        this.opcodeCycles[165] = 3;
        this.opcodeCycles[181] = 4;
        this.opcodeCycles[173] = 4;
        this.opcodeCycles[189] = 4;
        this.opcodeCycles[185] = 4;
        this.opcodeCycles[161] = 6;
        this.opcodeCycles[177] = 5;
        this.opcodeCycles[162] = 2;
        this.opcodeCycles[166] = 3;
        this.opcodeCycles[182] = 4;
        this.opcodeCycles[174] = 4;
        this.opcodeCycles[190] = 4;
        this.opcodeCycles[160] = 2;
        this.opcodeCycles[164] = 3;
        this.opcodeCycles[180] = 4;
        this.opcodeCycles[172] = 4;
        this.opcodeCycles[188] = 4;
        this.opcodeCycles[74] = 2;
        this.opcodeCycles[70] = 5;
        this.opcodeCycles[86] = 6;
        this.opcodeCycles[78] = 6;
        this.opcodeCycles[94] = 7;
        this.opcodeCycles[234] = 2;
        this.opcodeCycles[9] = 2;
        this.opcodeCycles[5] = 3;
        this.opcodeCycles[21] = 4;
        this.opcodeCycles[13] = 4;
        this.opcodeCycles[29] = 4;
        this.opcodeCycles[25] = 4;
        this.opcodeCycles[1] = 6;
        this.opcodeCycles[17] = 5;
        this.opcodeCycles[72] = 3;
        this.opcodeCycles[8] = 3;
        this.opcodeCycles[104] = 4;
        this.opcodeCycles[42] = 2;
        this.opcodeCycles[38] = 5;
        this.opcodeCycles[54] = 6;
        this.opcodeCycles[46] = 6;
        this.opcodeCycles[62] = 7;
        this.opcodeCycles[106] = 2;
        this.opcodeCycles[102] = 5;
        this.opcodeCycles[118] = 6;
        this.opcodeCycles[110] = 6;
        this.opcodeCycles[126] = 7;
        this.opcodeCycles[64] = 6;
        this.opcodeCycles[96] = 6;
        this.opcodeCycles[233] = 2;
        this.opcodeCycles[229] = 3;
        this.opcodeCycles[245] = 4;
        this.opcodeCycles[237] = 4;
        this.opcodeCycles[253] = 4;
        this.opcodeCycles[249] = 4;
        this.opcodeCycles[225] = 6;
        this.opcodeCycles[241] = 5;
        this.opcodeCycles[56] = 2;
        this.opcodeCycles[248] = 2;
        this.opcodeCycles[120] = 2;
        this.opcodeCycles[133] = 3;
        this.opcodeCycles[149] = 4;
        this.opcodeCycles[141] = 4;
        this.opcodeCycles[157] = 5;
        this.opcodeCycles[153] = 5;
        this.opcodeCycles[129] = 6;
        this.opcodeCycles[145] = 6;
        this.opcodeCycles[134] = 3;
        this.opcodeCycles[150] = 4;
        this.opcodeCycles[142] = 4;
        this.opcodeCycles[132] = 3;
        this.opcodeCycles[148] = 4;
        this.opcodeCycles[140] = 4;
        this.opcodeCycles[170] = 2;
        this.opcodeCycles[168] = 2;
        this.opcodeCycles[186] = 2;
        this.opcodeCycles[138] = 2;
        this.opcodeCycles[154] = 2;
        this.opcodeCycles[152] = 2;
        this.opcodeModes[105] = 8;
        this.opcodeModes[101] = 0;
        this.opcodeModes[117] = 1;
        this.opcodeModes[109] = 3;
        this.opcodeModes[125] = 4;
        this.opcodeModes[121] = 5;
        this.opcodeModes[97] = 10;
        this.opcodeModes[113] = 11;
        this.opcodeModes[41] = 8;
        this.opcodeModes[37] = 0;
        this.opcodeModes[53] = 1;
        this.opcodeModes[45] = 3;
        this.opcodeModes[61] = 4;
        this.opcodeModes[57] = 5;
        this.opcodeModes[33] = 10;
        this.opcodeModes[49] = 11;
        this.opcodeModes[10] = 7;
        this.opcodeModes[6] = 0;
        this.opcodeModes[22] = 1;
        this.opcodeModes[14] = 3;
        this.opcodeModes[30] = 4;
        this.opcodeModes[36] = 0;
        this.opcodeModes[44] = 3;
        this.opcodeModes[16] = 12;
        this.opcodeModes[48] = 12;
        this.opcodeModes[80] = 12;
        this.opcodeModes[112] = 12;
        this.opcodeModes[144] = 12;
        this.opcodeModes[176] = 12;
        this.opcodeModes[208] = 12;
        this.opcodeModes[240] = 12;
        this.opcodeModes[0] = 6;
        this.opcodeModes[201] = 8;
        this.opcodeModes[197] = 0;
        this.opcodeModes[213] = 1;
        this.opcodeModes[205] = 3;
        this.opcodeModes[221] = 4;
        this.opcodeModes[217] = 5;
        this.opcodeModes[193] = 10;
        this.opcodeModes[209] = 11;
        this.opcodeModes[224] = 8;
        this.opcodeModes[228] = 0;
        this.opcodeModes[236] = 3;
        this.opcodeModes[192] = 8;
        this.opcodeModes[196] = 0;
        this.opcodeModes[204] = 3;
        this.opcodeModes[198] = 0;
        this.opcodeModes[214] = 1;
        this.opcodeModes[206] = 3;
        this.opcodeModes[222] = 4;
        this.opcodeModes[73] = 8;
        this.opcodeModes[69] = 0;
        this.opcodeModes[85] = 1;
        this.opcodeModes[77] = 3;
        this.opcodeModes[93] = 4;
        this.opcodeModes[89] = 5;
        this.opcodeModes[65] = 10;
        this.opcodeModes[81] = 11;
        this.opcodeModes[24] = 6;
        this.opcodeModes[56] = 6;
        this.opcodeModes[88] = 6;
        this.opcodeModes[120] = 6;
        this.opcodeModes[184] = 6;
        this.opcodeModes[216] = 6;
        this.opcodeModes[248] = 6;
        this.opcodeModes[230] = 0;
        this.opcodeModes[246] = 1;
        this.opcodeModes[238] = 3;
        this.opcodeModes[254] = 4;
        this.opcodeModes[76] = 3;
        this.opcodeModes[108] = 9;
        this.opcodeModes[32] = 3;
        this.opcodeModes[169] = 8;
        this.opcodeModes[165] = 0;
        this.opcodeModes[181] = 1;
        this.opcodeModes[173] = 3;
        this.opcodeModes[189] = 4;
        this.opcodeModes[185] = 5;
        this.opcodeModes[161] = 10;
        this.opcodeModes[177] = 11;
        this.opcodeModes[162] = 8;
        this.opcodeModes[166] = 0;
        this.opcodeModes[182] = 2;
        this.opcodeModes[174] = 3;
        this.opcodeModes[190] = 5;
        this.opcodeModes[160] = 8;
        this.opcodeModes[164] = 0;
        this.opcodeModes[180] = 1;
        this.opcodeModes[172] = 3;
        this.opcodeModes[188] = 4;
        this.opcodeModes[74] = 7;
        this.opcodeModes[70] = 0;
        this.opcodeModes[86] = 1;
        this.opcodeModes[78] = 3;
        this.opcodeModes[94] = 4;
        this.opcodeModes[234] = 6;
        this.opcodeModes[9] = 8;
        this.opcodeModes[5] = 0;
        this.opcodeModes[21] = 1;
        this.opcodeModes[13] = 3;
        this.opcodeModes[29] = 4;
        this.opcodeModes[25] = 5;
        this.opcodeModes[1] = 10;
        this.opcodeModes[17] = 11;
        this.opcodeModes[170] = 6;
        this.opcodeModes[138] = 6;
        this.opcodeModes[202] = 6;
        this.opcodeModes[232] = 6;
        this.opcodeModes[168] = 6;
        this.opcodeModes[152] = 6;
        this.opcodeModes[136] = 6;
        this.opcodeModes[200] = 6;
        this.opcodeModes[42] = 7;
        this.opcodeModes[38] = 0;
        this.opcodeModes[54] = 1;
        this.opcodeModes[46] = 3;
        this.opcodeModes[62] = 4;
        this.opcodeModes[106] = 7;
        this.opcodeModes[102] = 0;
        this.opcodeModes[118] = 1;
        this.opcodeModes[110] = 3;
        this.opcodeModes[126] = 4;
        this.opcodeModes[64] = 6;
        this.opcodeModes[96] = 6;
        this.opcodeModes[233] = 8;
        this.opcodeModes[229] = 0;
        this.opcodeModes[245] = 1;
        this.opcodeModes[237] = 3;
        this.opcodeModes[253] = 4;
        this.opcodeModes[249] = 5;
        this.opcodeModes[225] = 10;
        this.opcodeModes[241] = 11;
        this.opcodeModes[133] = 0;
        this.opcodeModes[149] = 1;
        this.opcodeModes[141] = 3;
        this.opcodeModes[157] = 4;
        this.opcodeModes[153] = 5;
        this.opcodeModes[129] = 10;
        this.opcodeModes[145] = 11;
        this.opcodeModes[154] = 6;
        this.opcodeModes[186] = 6;
        this.opcodeModes[72] = 6;
        this.opcodeModes[104] = 6;
        this.opcodeModes[8] = 6;
        this.opcodeModes[40] = 6;
        this.opcodeModes[134] = 0;
        this.opcodeModes[150] = 2;
        this.opcodeModes[142] = 3;
        this.opcodeModes[132] = 0;
        this.opcodeModes[148] = 1;
        this.opcodeModes[140] = 3;
        this.opcodeNames[105] = "ADC";
        this.opcodeNames[101] = "ADC";
        this.opcodeNames[117] = "ADC";
        this.opcodeNames[109] = "ADC";
        this.opcodeNames[125] = "ADC";
        this.opcodeNames[121] = "ADC";
        this.opcodeNames[97] = "ADC";
        this.opcodeNames[113] = "ADC";
        this.opcodeNames[41] = "AND";
        this.opcodeNames[37] = "AND";
        this.opcodeNames[53] = "AND";
        this.opcodeNames[45] = "AND";
        this.opcodeNames[61] = "AND";
        this.opcodeNames[57] = "AND";
        this.opcodeNames[33] = "AND";
        this.opcodeNames[49] = "AND";
        this.opcodeNames[10] = "ASL";
        this.opcodeNames[6] = "ASL";
        this.opcodeNames[22] = "ASL";
        this.opcodeNames[14] = "ASL";
        this.opcodeNames[30] = "ASL";
        this.opcodeNames[36] = "BIT";
        this.opcodeNames[44] = "BIT";
        this.opcodeNames[16] = "BPL";
        this.opcodeNames[48] = "BMI";
        this.opcodeNames[80] = "BVC";
        this.opcodeNames[112] = "BVS";
        this.opcodeNames[144] = "BCC";
        this.opcodeNames[176] = "BCS";
        this.opcodeNames[208] = "BNE";
        this.opcodeNames[240] = "BEQ";
        this.opcodeNames[0] = "BRK";
        this.opcodeNames[201] = "CMP";
        this.opcodeNames[197] = "CMP";
        this.opcodeNames[213] = "CMP";
        this.opcodeNames[205] = "CMP";
        this.opcodeNames[221] = "CMP";
        this.opcodeNames[217] = "CMP";
        this.opcodeNames[193] = "CMP";
        this.opcodeNames[209] = "CMP";
        this.opcodeNames[224] = "CPX";
        this.opcodeNames[228] = "CPX";
        this.opcodeNames[236] = "CPX";
        this.opcodeNames[192] = "CPY";
        this.opcodeNames[196] = "CPY";
        this.opcodeNames[204] = "CPY";
        this.opcodeNames[198] = "DEC";
        this.opcodeNames[214] = "DEC";
        this.opcodeNames[206] = "DEC";
        this.opcodeNames[222] = "DEC";
        this.opcodeNames[73] = "EOR";
        this.opcodeNames[69] = "EOR";
        this.opcodeNames[85] = "EOR";
        this.opcodeNames[77] = "EOR";
        this.opcodeNames[93] = "EOR";
        this.opcodeNames[89] = "EOR";
        this.opcodeNames[65] = "EOR";
        this.opcodeNames[81] = "EOR";
        this.opcodeNames[24] = "CLC";
        this.opcodeNames[56] = "SEC";
        this.opcodeNames[88] = "CLI";
        this.opcodeNames[120] = "SEI";
        this.opcodeNames[184] = "CLV";
        this.opcodeNames[216] = "CLD";
        this.opcodeNames[248] = "SED";
        this.opcodeNames[230] = "INC";
        this.opcodeNames[246] = "INC";
        this.opcodeNames[238] = "INC";
        this.opcodeNames[254] = "INC";
        this.opcodeNames[76] = "JMP";
        this.opcodeNames[108] = "JMP";
        this.opcodeNames[32] = "JSR";
        this.opcodeNames[169] = "LDA";
        this.opcodeNames[165] = "LDA";
        this.opcodeNames[181] = "LDA";
        this.opcodeNames[173] = "LDA";
        this.opcodeNames[189] = "LDA";
        this.opcodeNames[185] = "LDA";
        this.opcodeNames[161] = "LDA";
        this.opcodeNames[177] = "LDA";
        this.opcodeNames[162] = "LDX";
        this.opcodeNames[166] = "LDX";
        this.opcodeNames[182] = "LDX";
        this.opcodeNames[174] = "LDX";
        this.opcodeNames[190] = "LDX";
        this.opcodeNames[160] = "LDY";
        this.opcodeNames[164] = "LDY";
        this.opcodeNames[180] = "LDY";
        this.opcodeNames[172] = "LDY";
        this.opcodeNames[188] = "LDY";
        this.opcodeNames[74] = "LSR";
        this.opcodeNames[70] = "LSR";
        this.opcodeNames[86] = "LSR";
        this.opcodeNames[78] = "LSR";
        this.opcodeNames[94] = "LSR";
        this.opcodeNames[234] = "NOP";
        this.opcodeNames[9] = "ORA";
        this.opcodeNames[5] = "ORA";
        this.opcodeNames[21] = "ORA";
        this.opcodeNames[13] = "ORA";
        this.opcodeNames[29] = "ORA";
        this.opcodeNames[25] = "ORA";
        this.opcodeNames[1] = "ORA";
        this.opcodeNames[17] = "ORA";
        this.opcodeNames[170] = "TAX";
        this.opcodeNames[138] = "TXA";
        this.opcodeNames[202] = "DEX";
        this.opcodeNames[232] = "INX";
        this.opcodeNames[168] = "TAY";
        this.opcodeNames[152] = "TYA";
        this.opcodeNames[136] = "DEY";
        this.opcodeNames[200] = "INY";
        this.opcodeNames[42] = "ROL";
        this.opcodeNames[38] = "ROL";
        this.opcodeNames[54] = "ROL";
        this.opcodeNames[46] = "ROL";
        this.opcodeNames[62] = "ROL";
        this.opcodeNames[106] = "ROR";
        this.opcodeNames[102] = "ROR";
        this.opcodeNames[118] = "ROR";
        this.opcodeNames[110] = "ROR";
        this.opcodeNames[126] = "ROR";
        this.opcodeNames[64] = "RTI";
        this.opcodeNames[96] = "RTS";
        this.opcodeNames[233] = "SBC";
        this.opcodeNames[229] = "SBC";
        this.opcodeNames[245] = "SBC";
        this.opcodeNames[237] = "SBC";
        this.opcodeNames[253] = "SBC";
        this.opcodeNames[249] = "SBC";
        this.opcodeNames[225] = "SBC";
        this.opcodeNames[241] = "SBC";
        this.opcodeNames[133] = "STA";
        this.opcodeNames[149] = "STA";
        this.opcodeNames[141] = "STA";
        this.opcodeNames[157] = "STA";
        this.opcodeNames[153] = "STA";
        this.opcodeNames[129] = "STA";
        this.opcodeNames[145] = "STA";
        this.opcodeNames[154] = "TXS";
        this.opcodeNames[186] = "TSX";
        this.opcodeNames[72] = "PHA";
        this.opcodeNames[104] = "PLA";
        this.opcodeNames[8] = "PHP";
        this.opcodeNames[40] = "PLP";
        this.opcodeNames[134] = "STX";
        this.opcodeNames[150] = "STX";
        this.opcodeNames[142] = "STX";
        this.opcodeNames[132] = "STY";
        this.opcodeNames[148] = "STY";
        this.opcodeNames[140] = "STY";
        this.addressModeNames[0] = "Zero Page";
        this.addressModeNames[1] = "Zero Page,X";
        this.addressModeNames[2] = "Zero Page,Y";
        this.addressModeNames[3] = "Absolute";
        this.addressModeNames[4] = "Absolute,X";
        this.addressModeNames[5] = "Absolute,Y";
        this.addressModeNames[6] = "Implied";
        this.addressModeNames[7] = "Accumulator";
        this.addressModeNames[8] = "Immediate";
        this.addressModeNames[9] = "Indirect";
        this.addressModeNames[10] = "Indirect,X";
        this.addressModeNames[11] = "Indirect,Y";
        this.addressModeNames[12] = "Relative";
    }
}

