/*
 * Decompiled with CFR 0.152.
 */
package beanes;

import GUI.AboutPanel;
import GUI.ControllersPanel;
import GUI.VideoPanel;
import beanes.BeaNES;
import beanes.BeaNESProperties;
import beanes.ROM;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class GUI
extends JFrame {
    private BeaNES nes;
    final JMenuBar menuBar = new JMenuBar();
    private boolean fullScreen = false;

    public GUI() {
        this.nes = new BeaNES(this);
        this.createMenuBar();
        this.setTitle("BeaNES-0.0.1");
        this.add(this.nes.getVideoOutput());
        this.nes.getVideoOutput().initializeImage();
        this.addKeyListener(this.nes.getJoypadInput(0));
        this.addKeyListener(this.nes.getJoypadInput(1));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                GUI.this.nes;
                BeaNES.getProperties().store();
            }
        });
        this.pack();
        this.setDefaultCloseOperation(3);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    GUI.this.setFullScreen(!GUI.this.isFullScreen());
                }
            }
        });
    }

    public void start() {
        this.setVisible(true);
    }

    private void createMenuBar() {
        boolean selected;
        JMenu nesMenu = new JMenu("NES");
        JMenu optionsMenu = new JMenu("Options");
        JMenu helpMenu = new JMenu("Help");
        JMenuItem loadROMMenuItem = new JMenuItem("Load ROM");
        JMenuItem hardResetMenuItem = new JMenuItem("Hard Reset");
        JMenuItem videoMenuItem = new JMenuItem("Video Settings");
        JMenuItem controlsMenuItem = new JMenuItem("Controller Settings");
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        final JCheckBoxMenuItem fullScreen = new JCheckBoxMenuItem("Full Screen");
        final JCheckBoxMenuItem throttle = new JCheckBoxMenuItem("Throttle CPU");
        final JCheckBoxMenuItem showFPS = new JCheckBoxMenuItem("Show FPS");
        JMenuItem aboutMenuItem = new JMenuItem("About Authors /Contact Authors");
        nesMenu.add(loadROMMenuItem);
        nesMenu.add(exitMenuItem);
        optionsMenu.add(videoMenuItem);
        optionsMenu.add(controlsMenuItem);
        optionsMenu.add(throttle);
        optionsMenu.add(fullScreen);
        optionsMenu.add(showFPS);
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(nesMenu);
        this.menuBar.add(optionsMenu);
        this.menuBar.add(helpMenu);
        throttle.setSelected(this.nes.getClock().isThrottle());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                GUI.this.togglePause();
            }
        });
        videoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VideoPanel vp = new VideoPanel(GUI.this.nes);
            }
        });
        controlsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControllersPanel cp = new ControllersPanel(GUI.this.nes);
            }
        });
        loadROMMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUI.this.loadROM();
            }
        });
        exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(1);
            }
        });
        throttle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean value = !GUI.this.nes.getClock().isThrottle();
                GUI.this.nes.getClock().setThrottle(value);
                throttle.setSelected(value);
                BeaNES.getProperties().setProperty(BeaNESProperties.PROPERTY_THROTTLE, Boolean.toString(throttle.isSelected()));
            }
        });
        fullScreen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean value = !GUI.this.isFullScreen();
                GUI.this.setFullScreen(value);
                fullScreen.setSelected(value);
                GUI.this.nes.getClock().setThrottle(value);
                throttle.setSelected(value);
            }
        });
        showFPS.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUI.this.nes.getVideoOutput().setShowFPS(!GUI.this.nes.getVideoOutput().isShowFPS());
                showFPS.setSelected(GUI.this.nes.getVideoOutput().isShowFPS());
                BeaNES.getProperties().setProperty(BeaNESProperties.PROPERTY_SHOW_FPS, Boolean.toString(showFPS.isSelected()));
            }
        });
        aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutPanel about = new AboutPanel();
            }
        });
        try {
            throttle.setSelected(this.nes.getVideoOutput().isShowFPS());
            selected = Boolean.valueOf(BeaNES.getProperties().getProperty(BeaNESProperties.PROPERTY_THROTTLE));
            this.nes.getClock().setThrottle(selected);
            throttle.setSelected(selected);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            showFPS.setSelected(this.nes.getVideoOutput().isShowFPS());
            selected = Boolean.valueOf(BeaNES.getProperties().getProperty(BeaNESProperties.PROPERTY_SHOW_FPS));
            this.nes.getVideoOutput().setShowFPS(selected);
            showFPS.setSelected(selected);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.setJMenuBar(this.menuBar);
    }

    private void loadROM() {
        GUI gUI = this;
        String currDir = gUI.nes.getProperties().getProperty(BeaNESProperties.PROPERTY_ROMPATH);
        JFileChooser chooser = new JFileChooser(currDir);
        chooser.setDialogTitle("Select ROM");
        chooser.showOpenDialog(this);
        File romFile = chooser.getSelectedFile();
        if (romFile != null) {
            this.nes.stop();
            GUI gUI2 = this;
            gUI2.nes.getProperties().setProperty(BeaNESProperties.PROPERTY_ROMPATH, romFile.getAbsolutePath());
            this.nes.loadROM(new ROM(this.nes, romFile));
            this.nes.start();
            this.menuBar.setVisible(this.nes.getClock().isPaused());
        }
    }

    public void togglePause() {
        this.nes.getClock().setPaused(!this.nes.getClock().isPaused());
        this.menuBar.setVisible(this.nes.getClock().isPaused());
    }

    public BeaNES getNES() {
        return this.nes;
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public void setFullScreen(boolean fullScreen) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        if (fullScreen) {
            this.setVisible(false);
            this.dispose();
            this.setUndecorated(true);
            GUI.setDefaultLookAndFeelDecorated(false);
            this.setVisible(true);
            gd.setFullScreenWindow(this);
            gd.setDisplayMode(this.nes.getFullScreenDisplayMode());
            this.fullScreen = fullScreen;
            if (this.nes.getClock().isPaused()) {
                this.togglePause();
            }
        } else {
            this.fullScreen = false;
            this.setVisible(false);
            this.dispose();
            this.setUndecorated(false);
            GUI.setDefaultLookAndFeelDecorated(true);
            this.setVisible(true);
            gd.setFullScreenWindow(null);
        }
    }
}

