/*
 * Decompiled with CFR 0.152.
 */
package beanes;

import beanes.BeaNES;
import beanes.sound.DMChannel;
import beanes.sound.NoiseChannel;
import beanes.sound.SquareChannel;
import beanes.sound.TriangleChannel;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class PAPU
implements Runnable {
    public static double PAPU_FREQUENCY = 1789772.5;
    private BeaNES nes;
    private Thread thread;
    private SquareChannel square1;
    private SquareChannel square2;
    private NoiseChannel noise;
    private TriangleChannel triangle;
    private DMChannel dm;
    private Mixer mixer;
    private SourceDataLine dataLine;
    private AudioFormat audioFormat;
    private int refreshRate = 10;
    private int cycleRate;
    private int sampleRate = 44100;
    private int bufferIndex;
    private int bufferSize = 2048;
    private byte[] sampleBuffer;
    private int timeCounter = 0;
    public static final int[] lengthLookupTable = new int[]{10, 254, 20, 2, 40, 4, 80, 6, 160, 8, 60, 10, 14, 12, 26, 14, 12, 16, 24, 18, 48, 20, 96, 22, 192, 24, 72, 26, 16, 28, 32, 30};

    public PAPU(BeaNES nes) {
        this.nes = nes;
        this.square1 = new SquareChannel(this);
        this.square2 = new SquareChannel(this);
        this.noise = new NoiseChannel(this);
        this.triangle = new TriangleChannel(this);
        this.dm = new DMChannel(this);
        this.cycleRate = (int)(PAPU_FREQUENCY * 65536.0 / (double)this.sampleRate);
        this.sampleBuffer = new byte[this.bufferSize];
        this.bufferIndex = 0;
        this.mixer = AudioSystem.getMixer(AudioSystem.getMixerInfo()[1]);
        this.audioFormat = new AudioFormat(this.sampleRate, 16, 1, true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.audioFormat, 44100);
        try {
            this.dataLine = (SourceDataLine)AudioSystem.getLine(info);
            this.dataLine.open(this.audioFormat);
            this.dataLine.start();
        }
        catch (Exception e) {
            System.out.println("could not open audio data line");
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public synchronized void run() {
        int sleepTime = 1000 / this.refreshRate;
        long currTime = 0L;
        int waitTime = 0;
        currTime = System.currentTimeMillis() / 1000L;
        while (currTime == System.currentTimeMillis() / 1000L) {
            ++waitTime;
        }
        while (true) {
            currTime = System.currentTimeMillis() / 1000L;
            this.square1.process();
            this.sampleBuffer[this.bufferIndex] = this.square1.sample;
            ++this.bufferIndex;
            if (this.bufferIndex < this.sampleBuffer.length) continue;
            this.bufferIndex = 0;
            this.dataLine.write(this.sampleBuffer, 0, this.bufferSize);
        }
    }

    public void test() {
        double frequency = 880.0;
        for (int i = 0; i < this.sampleBuffer.length; ++i) {
            ++this.timeCounter;
            this.sampleBuffer[i] = (byte)(Math.sin(Math.PI * (double)this.timeCounter * frequency / (double)this.sampleRate) * 127.0);
        }
    }

    public void write(int address, short value) {
        switch (address) {
            case 16384: 
            case 16385: 
            case 16386: 
            case 16387: {
                this.square1.write(address, value);
                break;
            }
            case 16388: 
            case 16389: 
            case 16390: 
            case 16391: {
                this.square2.write(address, value);
                break;
            }
            case 16392: 
            case 16393: 
            case 16394: 
            case 16395: {
                this.triangle.write(address, value);
                break;
            }
            case 16396: 
            case 16397: 
            case 16398: 
            case 16399: {
                this.noise.write(address, value);
                break;
            }
            case 16400: 
            case 16401: 
            case 16402: 
            case 16403: {
                this.dm.write(address, value);
                break;
            }
            case 16405: {
                this.dm.write(address, value);
                break;
            }
        }
    }
}

