/*
 * Decompiled with CFR 0.152.
 */
package beanes;

import beanes.BeaNES;
import beanes.MemoryMapper;
import beanes.mappers.AOROMMapper;
import beanes.mappers.CNROMMapper;
import beanes.mappers.GNROMMapper;
import beanes.mappers.NESMapper;
import beanes.mappers.UNIROMMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ROM {
    public static final int HORIZONTAL_MIRRORING = 0;
    public static final int VERTICAL_MIRRORING = 1;
    public static final int FOURSCREEN_MIRRORING = 2;
    public static final int SINGLESCREEN_MIRRORING = 3;
    public static final int SINGLESCREEN_MIRRORING2 = 4;
    public static final int SINGLESCREEN_MIRRORING3 = 5;
    public static final int SINGLESCREEN_MIRRORING4 = 6;
    public static final int CHRROM_MIRRORING = 7;
    private static final String[] mirrorDescriptions = new String[]{"Vertical Mirroring", "Horizontal Mirroring", "Fourscreen Mirroring", "Singlescreen Mirroring", "Singlescreen Mirroring2", "Singlescreen Mirroring3", "Singlescreen Mirroring4", "CHRROM Mirroring"};
    private File romFile;
    private BeaNES nes;
    private short[][] rom;
    private short[][] vrom;
    public int numPRGBanks = 0;
    public int numCHRBanks = 0;
    private int mapperType = 0;
    private int mirrorMode = 0;
    private boolean fourscreenMode = false;
    private boolean trainer = false;
    private MemoryMapper memoryMapper;
    private String[] mapperNames = new String[92];

    public ROM(BeaNES nes, File romFile) {
        this.nes = nes;
        this.romFile = romFile;
        for (int i = 0; i < 92; ++i) {
            this.mapperNames[i] = "Unknown Mapper";
        }
        this.mapperNames[0] = "Mapper 0";
        this.mapperNames[1] = "Nintendo MMC1";
        this.mapperNames[2] = "UNROM";
        this.mapperNames[3] = "CNROM";
        this.mapperNames[4] = "Nintendo MMC3";
        this.mapperNames[5] = "Nintendo MMC5";
        this.mapperNames[6] = "FFE F4xxx";
        this.mapperNames[7] = "AOROM";
        this.mapperNames[8] = "FFE F3xxx";
        this.mapperNames[9] = "Nintendo MMC2";
        this.mapperNames[10] = "Nintendo MMC4";
        this.mapperNames[11] = "ColorDreams Chip";
        this.mapperNames[12] = "FFE F6xxx";
        this.mapperNames[15] = "100-in-1 switch";
        this.mapperNames[16] = "Bandai chip";
        this.mapperNames[17] = "FFE F8xxx";
        this.mapperNames[18] = "Jaleco SS8806 chip";
        this.mapperNames[19] = "Namcot 106 chip";
        this.mapperNames[20] = "Nintendo DiskSystem";
        this.mapperNames[21] = "Konami VRC4a";
        this.mapperNames[22] = "Konami VRC2a";
        this.mapperNames[23] = "Konami VRC2a";
        this.mapperNames[24] = "Konami VRC6";
        this.mapperNames[25] = "Konami VRC4b";
        this.mapperNames[32] = "Irem G-101 chip";
        this.mapperNames[33] = "Taito TC0190/TC0350";
        this.mapperNames[34] = "32kB ROM switch";
        this.mapperNames[64] = "Tengen RAMBO-1 chip";
        this.mapperNames[65] = "Irem H-3001 chip";
        this.mapperNames[66] = "GNROM switch";
        this.mapperNames[67] = "SunSoft3 chip";
        this.mapperNames[68] = "SunSoft4 chip";
        this.mapperNames[69] = "SunSoft5 FME-7 chip";
        this.mapperNames[71] = "Camerica chip";
        this.mapperNames[78] = "Irem 74HC161/32-based";
        this.mapperNames[91] = "Pirate HK-SF3 chip";
    }

    public void load() {
        System.out.println("Loading ROM file " + this.romFile.getName());
        int i = 0;
        int read = 0;
        try {
            FileInputStream in = new FileInputStream(this.romFile);
            short[] romData = new short[(int)this.romFile.length() + 1];
            while (read > -1 && (read = in.read()) != -1) {
                romData[i] = (short)read;
                ++i;
            }
            System.out.println("ROM Size " + this.romFile.length() + "bytes");
            if (romData[0] == 78 && romData[1] == 69 && romData[2] == 83 && romData[3] == 26) {
                int j;
                this.numPRGBanks = romData[4];
                this.numCHRBanks = romData[5] * 2;
                this.trainer = (romData[6] & 4) != 0;
                this.mapperType = romData[6] >> 4 | romData[7] & 0xF0;
                this.mirrorMode = (romData[6] & 1) != 0 ? 1 : 0;
                this.fourscreenMode = (romData[6] & 8) != 0;
                int offset = 16;
                this.rom = new short[this.numPRGBanks][16384];
                this.vrom = new short[this.numCHRBanks][4096];
                System.out.println("iNES formatted ROM");
                System.out.println("Mapper " + this.mapperType + ": " + this.getMapperName());
                System.out.println("Mirror Mode " + this.mirrorMode + ": " + mirrorDescriptions[this.mirrorMode]);
                System.out.println("Four Screen Mode " + (this.fourscreenMode ? "true" : Boolean.valueOf(false)));
                System.out.println("Loading PRG ROM Banks");
                for (i = 0; i < this.numPRGBanks; ++i) {
                    for (j = 0; j < 16384 && offset + j < romData.length; ++j) {
                        this.rom[i][j] = romData[offset + j];
                    }
                    offset += 16384;
                }
                System.out.println("Loading CHR ROM Banks");
                for (i = 0; i < this.numCHRBanks; ++i) {
                    for (j = 0; j < 4096 && offset + j < romData.length; ++j) {
                        this.vrom[i][j] = romData[offset + j];
                    }
                    offset += 4096;
                    for (int k = 0; k < 256; ++k) {
                        short[] data = new short[16];
                        for (int n = 0; n < 16; ++n) {
                            data[n] = this.vrom[i][k * 16 + n];
                        }
                    }
                }
                switch (this.mapperType) {
                    case 2: {
                        this.memoryMapper = new UNIROMMapper(this.nes);
                        break;
                    }
                    case 3: {
                        this.memoryMapper = new CNROMMapper(this.nes);
                        break;
                    }
                    case 7: {
                        this.memoryMapper = new AOROMMapper(this.nes);
                        break;
                    }
                    case 66: {
                        this.memoryMapper = new GNROMMapper(this.nes);
                        break;
                    }
                    default: {
                        this.memoryMapper = new NESMapper(this.nes);
                    }
                }
                this.memoryMapper.loadROM(this);
            } else {
                System.out.println("Not an iNES formatted ROM");
            }
            System.out.println("Loaded ROM (" + this.numPRGBanks + " PRG Banks and " + this.numCHRBanks + " CHR banks)");
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public short[] getROMBank(int bank) {
        return this.rom[bank];
    }

    public short[] getVROMBank(int bank) {
        return this.vrom[bank];
    }

    public short read(int bank, int address) {
        try {
            return this.rom[bank][address];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("ERRROR: Reading ROM bank " + bank + ":" + Integer.toHexString(address));
            return -1;
        }
    }

    public void write(int bank, int address, short value) {
        this.rom[bank][address] = value;
    }

    public MemoryMapper getMapper() {
        return this.memoryMapper;
    }

    public int getMirroringMode() {
        return this.mirrorMode;
    }

    public String getMapperName() {
        if (this.mapperType > this.mapperNames.length || this.mapperType < 0) {
            return "Unknown Mapper";
        }
        return this.mapperNames[this.mapperType];
    }
}

