/*
 * Decompiled with CFR 0.152.
 */
package beanes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

public class BeaNESProperties
extends Properties {
    public static String PROPERTY_ROMPATH = "romPath";
    public static String PROPERTY_FULLSCREEN_RESOLUTION_MODE = "fullscreenResolutionMode";
    public static String PROPERTY_SHOW_FPS = "showFPS";
    public static String PROPERTY_THROTTLE = "throttle";
    public static String PROPERTY_CONTROLLER1 = "controller1";
    public static String PROPERTY_CONTROLLER2 = "controller2";

    public BeaNESProperties() {
        this.findRootPath();
        this.load();
        this.setProperty("propertiesFile", this.getProperty("rootPath") + "/properties.conf");
    }

    public void store() {
        try {
            String path = this.getProperty("rootPath") + "/properties.conf";
            FileOutputStream out = new FileOutputStream(path);
            this.store(out, "BeaNES Settings");
            out.close();
        }
        catch (FileNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void load() {
        try {
            FileInputStream in = new FileInputStream(this.getProperty("rootPath") + "/properties.conf");
            this.load(in);
            in.close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public boolean propertiesFileExist() {
        File f = new File(this.getProperty("rootPath") + "/properties.conf");
        return f.exists();
    }

    private void findRootPath() {
        String classPath = System.getProperty("java.class.path");
        String path = "";
        String pathSeparator = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(classPath, pathSeparator);
        path = tokenizer.hasMoreElements() ? (String)tokenizer.nextElement() : classPath;
        File f = new File(path);
        try {
            this.setProperty("rootPath", f.getParent());
        }
        catch (NullPointerException e) {
            System.out.println("occurs because executing in same path" + path);
        }
    }
}

