/*
 * Decompiled with CFR 0.152.
 */
package beanes;

import beanes.BeaNES;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class JoypadInput
extends KeyAdapter {
    private BeaNES nes;
    public static final int BUTTON_A = 0;
    public static final int BUTTON_B = 1;
    public static final int BUTTON_SELECT = 2;
    public static final int BUTTON_START = 3;
    public static final int BUTTON_UP = 4;
    public static final int BUTTON_DOWN = 5;
    public static final int BUTTON_LEFT = 6;
    public static final int BUTTON_RIGHT = 7;
    public static final int BUTTON_UNBOUNDED = -1;
    private int[] keyboardMap = new int[255];
    private int[] buttonStates = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int num;

    public JoypadInput(BeaNES nes, int num) {
        this.num = num;
        this.nes = nes;
        this.unbindKeys();
        if (nes.getProperties().propertiesFileExist()) {
            for (int button = 0; button < 8; ++button) {
                String key = "controls[" + num + "][" + button + "]";
                String value = nes.getProperties().getProperty(key);
                if (value == null) continue;
                int code = Integer.parseInt(value);
                this.bindKey(code, button);
            }
        } else if (num == 0) {
            this.bindKey(38, 4);
            this.bindKey(40, 5);
            this.bindKey(37, 6);
            this.bindKey(39, 7);
            this.bindKey(90, 2);
            this.bindKey(88, 3);
            this.bindKey(67, 1);
            this.bindKey(86, 0);
        } else if (num == 1) {
            this.bindKey(87, 4);
            this.bindKey(83, 5);
            this.bindKey(65, 6);
            this.bindKey(68, 7);
            this.bindKey(72, 2);
            this.bindKey(74, 3);
            this.bindKey(75, 1);
            this.bindKey(76, 0);
        }
    }

    public void bindKey(int key, int button) {
        if (key >= 0 && key < this.keyboardMap.length) {
            this.keyboardMap[key] = button;
        }
    }

    public void unbindButton(int button) {
        for (int i = 0; i < this.keyboardMap.length; ++i) {
            if (this.keyboardMap[i] != button) continue;
            this.keyboardMap[i] = -1;
        }
    }

    public void unbindKey(int key) {
        this.keyboardMap[key] = -1;
    }

    public void unbindKeys() {
        for (int i = 0; i < this.keyboardMap.length; ++i) {
            this.unbindKey(i);
        }
    }

    public int getBoundedButton(int key) {
        return this.keyboardMap[key];
    }

    public int getBoundedKey(int button) {
        for (int i = 0; i < this.keyboardMap.length; ++i) {
            if (this.keyboardMap[i] != button) continue;
            return i;
        }
        return -1;
    }

    public int getButtonState(int button) {
        if (button < this.buttonStates.length && button >= 0) {
            return this.buttonStates[button];
        }
        return 0;
    }

    public synchronized void keyPressed(KeyEvent e) {
        int button = this.keyboardMap[e.getKeyCode()];
        if (button < this.buttonStates.length && button >= 0) {
            this.buttonStates[button] = 1;
        }
    }

    public synchronized void keyReleased(KeyEvent e) {
        int button = this.keyboardMap[e.getKeyCode()];
        if (button < this.buttonStates.length && button >= 0) {
            this.buttonStates[button] = 0;
        }
    }
}

