/*
 * Decompiled with CFR 0.152.
 */
package beanes;

import beanes.BeaNES;
import beanes.CPU;

public class PPU {
    BeaNES nes;
    public static int PPU_MEMORY_SIZE = 32768;
    public static int SPRITE_MEMORY_SIZE = 65536;
    public int HORIZONTAL_MIRRORING = 0;
    public int VERTICAL_MIRRORING = 1;
    public short[] ppuMemory;
    public short[] spriteMemory;
    private int[] vramMirror;
    private int[] ntMirror;
    private boolean[] solidBGLine;
    private boolean[] solidSPLine;
    private int[] raster;
    private boolean firstWrite = true;
    private int mirroringMode = -1;
    private short controlRegister1;
    private short controlRegister2;
    private short statusRegister;
    private short sramAddress;
    private short ppuLatch;
    private int loopyX;
    private int loopyT;
    private int loopyV;
    private int scanlineCycles;
    private int scanline;
    private int vblankWait;
    private int[] rgbPalette = new int[]{0x808080, 15782, 4784, 4456598, 10551390, 13041704, 12191232, 9180928, 6041344, 1066240, 346624, 18222, 16742, 0, 328965, 328965, 0xC7C7C7, 30719, 2184703, 8534010, 15413173, 16722256, 0xFF2000, 14037504, 12870144, 3506176, 364288, 35413, 39372, 0x212121, 592137, 592137, 0xFFFFFF, 1038335, 6923007, 13926655, 16729587, 16736651, 0xFF8833, 16751634, 16432160, 10478350, 2879541, 848036, 392191, 0x5E5E5E, 855309, 855309, 0xFFFFFF, 10943743, 11791615, 14330859, 16754937, 16755635, 16765616, 16773030, 16775068, 14149781, 10939823, 10679002, 0x99FFFC, 0xDDDDDD, 0x111111, 0x111111};

    public PPU(BeaNES nes) {
        this.nes = nes;
        this.ppuMemory = new short[PPU_MEMORY_SIZE];
        this.spriteMemory = new short[SPRITE_MEMORY_SIZE];
    }

    public void hardReset() {
        this.solidBGLine = new boolean[256];
        this.solidSPLine = new boolean[256];
        this.firstWrite = true;
        this.setMirroringMode(this.nes.getROM().getMirroringMode());
    }

    public void setMirroringMode(int mode) {
        System.out.println("Setting mirroring mode " + mode);
        if (this.mirroringMode == mode) {
            return;
        }
        this.mirroringMode = mode;
        this.vramMirror = new int[32768];
        this.ntMirror = new int[4];
        this.writeMirror(0, 0, this.vramMirror.length);
        this.writeMirror(16160, 16128, 32);
        this.writeMirror(16192, 16128, 32);
        this.writeMirror(16256, 16128, 32);
        this.writeMirror(16320, 16128, 32);
        this.writeMirror(12288, 8192, 3840);
        this.writeMirror(16384, 0, 16384);
        switch (mode) {
            case 1: {
                this.writeMirror(10240, 8192, 1024);
                this.writeMirror(11264, 9216, 1024);
                this.ntMirror[0] = 0;
                this.ntMirror[1] = 1;
                this.ntMirror[2] = 0;
                this.ntMirror[3] = 1;
                break;
            }
            case 0: {
                this.writeMirror(9216, 8192, 1024);
                this.writeMirror(11264, 10240, 1024);
                this.ntMirror[0] = 0;
                this.ntMirror[1] = 0;
                this.ntMirror[2] = 1;
                this.ntMirror[3] = 1;
                break;
            }
            case 3: {
                this.writeMirror(9216, 8192, 1024);
                this.writeMirror(10240, 8192, 1024);
                this.writeMirror(11264, 8192, 1024);
                this.ntMirror[0] = 0;
                this.ntMirror[1] = 0;
                this.ntMirror[2] = 0;
                this.ntMirror[3] = 0;
                break;
            }
            case 4: {
                this.writeMirror(9216, 9216, 1024);
                this.writeMirror(10240, 9216, 1024);
                this.writeMirror(11264, 9216, 1024);
                this.ntMirror[0] = 1;
                this.ntMirror[1] = 1;
                this.ntMirror[2] = 1;
                this.ntMirror[3] = 1;
                break;
            }
            default: {
                this.ntMirror[0] = 0;
                this.ntMirror[1] = 1;
                this.ntMirror[2] = 2;
                this.ntMirror[3] = 3;
            }
        }
    }

    public int runCycles(int cycles) {
        int cyclesRan = cycles;
        while (cycles > 0) {
            ++this.scanlineCycles;
            if (this.scanlineCycles == 341) {
                this.scanlineCycles = 0;
                if (this.vblankWait < 19) {
                    ++this.vblankWait;
                } else {
                    if (this.scanline == 0) {
                        if ((this.controlRegister2 & 0x18) != 0) {
                            this.loopyV = this.loopyT;
                        }
                        this.statusRegister = (short)(this.statusRegister & 0x7F);
                        this.statusRegister = (short)(this.statusRegister & 0xBF);
                    }
                    if (this.scanline < 240 && (this.controlRegister2 & 0x18) != 0) {
                        this.renderScanline();
                    }
                    if (this.scanline == 243) {
                        this.statusRegister = (short)(this.statusRegister | 0x80);
                        this.vblankWait = 0;
                        this.scanline = -1;
                        if ((this.controlRegister1 >> 7 & 1) != 0) {
                            CPU cPU = this.nes.getCPU();
                            this.nes.getCPU();
                            cPU.requestIRQ(1);
                        }
                        this.nes.getVideoOutput().renderImage(this.raster);
                        this.nes.getClock().signalVBlank();
                    }
                    ++this.scanline;
                }
            }
            --cycles;
        }
        return cyclesRan++;
    }

    public void renderScanline() {
        this.loopyV &= 0xFBE0;
        this.loopyV |= this.loopyT & 0x41F;
        if ((this.controlRegister2 & 8) != 0) {
            this.renderBackground();
        }
        if ((this.controlRegister2 & 0x10) != 0) {
            this.renderSprites();
        }
        if ((this.loopyV & 0x7000) == 28672) {
            this.loopyV &= 0x8FFF;
            if ((this.loopyV & 0x3E0) == 928) {
                this.loopyV ^= 0x800;
                this.loopyV &= 0xFC1F;
            } else {
                this.loopyV = (this.loopyV & 0x3E0) == 992 ? (this.loopyV &= 0xFC1F) : (this.loopyV += 32);
            }
        } else {
            this.loopyV += 4096;
        }
    }

    public void renderBackground() {
        int i;
        int indexX = this.loopyV & 0x1F;
        int indexY = (this.loopyV & 0x3E0) >> 5;
        int ntAddr = 8192 + (this.loopyV & 0xFFF);
        int atAddr = 8192 + (this.loopyV & 0xC00) + 960 + ((indexY & 0xFFFC) << 1) + (indexX >> 2);
        int attribute = 0;
        int colorAddr = 0;
        int color = 0;
        int patternAddr = 0;
        short patternMSB = 0;
        short patternLSB = 0;
        int pattern = 0;
        int col = -this.loopyX;
        attribute = (indexY & 2) == 0 ? ((indexX & 2) == 0 ? (this.ppuMemory[this.vramMirror[atAddr]] & 3) << 2 : this.ppuMemory[this.vramMirror[atAddr]] & 0xC) : ((indexX & 2) == 0 ? (this.ppuMemory[this.vramMirror[atAddr]] & 0x30) >> 2 : (this.ppuMemory[this.vramMirror[atAddr]] & 0xC0) >> 4);
        for (i = 0; i < this.solidBGLine.length; ++i) {
            this.solidBGLine[i] = false;
        }
        for (i = 0; i < 33; ++i) {
            patternAddr = (this.controlRegister1 >> 4 & 1) * 4096 + (this.ppuMemory[this.vramMirror[ntAddr]] << 4) + ((this.loopyV & 0x7000) >> 12);
            patternLSB = this.ppuMemory[this.vramMirror[patternAddr]];
            patternMSB = this.ppuMemory[this.vramMirror[patternAddr + 8]];
            for (int j = 7; j >= 0; --j) {
                pattern = patternMSB >> j << 1 & 2 | patternLSB >> j & 1;
                colorAddr = pattern == 0 ? 16144 : 16128 + (attribute | pattern);
                color = this.rgbPalette[this.ppuMemory[this.vramMirror[colorAddr]]];
                int point = this.scanline * 256 + col;
                if (col >= 0 && col < 256) {
                    boolean bl = this.solidBGLine[col] = pattern != 0;
                    if (point < this.raster.length && point < 61440 && (this.controlRegister2 & 8) != 0) {
                        this.raster[point] = color;
                    }
                }
                ++col;
            }
            ++ntAddr;
            if ((++indexX & 1) != 0) continue;
            if ((indexX & 3) == 0) {
                if ((indexX & 0x1F) == 0) {
                    ntAddr ^= 0x400;
                    atAddr ^= 0x400;
                    ntAddr -= 32;
                    atAddr -= 8;
                    indexX -= 32;
                }
                ++atAddr;
            }
            if ((indexY & 2) == 0) {
                if ((indexX & 2) == 0) {
                    attribute = (this.ppuMemory[this.vramMirror[atAddr]] & 3) << 2;
                    continue;
                }
                attribute = this.ppuMemory[this.vramMirror[atAddr]] & 0xC;
                continue;
            }
            attribute = (indexX & 2) == 0 ? (this.ppuMemory[this.vramMirror[atAddr]] & 0x30) >> 2 : (this.ppuMemory[this.vramMirror[atAddr]] & 0xC0) >> 4;
        }
    }

    public void renderSprites() {
        int i;
        int numDetected = 0;
        int height = (this.controlRegister1 & 0x20) != 0 ? 16 : 8;
        this.statusRegister = (short)(this.statusRegister & 0xDF);
        for (i = 0; i < this.solidSPLine.length; ++i) {
            this.solidSPLine[i] = false;
        }
        for (i = 0; i < 64; ++i) {
            short patternMSB;
            short patternLSB;
            int patternAddr;
            int y = this.spriteMemory[i * 4] + 1;
            short patternIndex = this.spriteMemory[i * 4 + 1];
            short attributes = this.spriteMemory[i * 4 + 2];
            short x = this.spriteMemory[i * 4 + 3];
            boolean vflip = (attributes & 0x80) != 0;
            boolean hflip = (attributes & 0x40) != 0;
            boolean bgPriority = (attributes & 0x20) != 0;
            int colorH = attributes << 2 & 0xC;
            int line = this.scanline - y;
            if (line < 0 || line >= height) continue;
            int n = line = vflip ? height - 1 - line : line;
            if (++numDetected > 8) {
                this.statusRegister = (short)(this.statusRegister | 0x20);
            }
            if (height == 8) {
                patternAddr = (this.controlRegister1 >> 3 & 1) * 4096 + patternIndex * 16 + line;
                patternLSB = this.ppuMemory[this.vramMirror[patternAddr]];
                patternMSB = this.ppuMemory[this.vramMirror[patternAddr + 8]];
            } else {
                patternAddr = patternIndex << 4;
                if ((patternIndex & 1) == 1) {
                    patternAddr += 4096;
                    if (line <= 7) {
                        patternAddr -= 16;
                    }
                } else if (line > 7) {
                    patternAddr += 16;
                }
                patternLSB = this.ppuMemory[this.vramMirror[patternAddr += line & 7]];
                patternMSB = this.ppuMemory[this.vramMirror[patternAddr + 8]];
            }
            for (int j = 7; j >= 0; --j) {
                int col;
                int pointX = x + 7 - j;
                int point = this.scanline * 256 + pointX;
                int n2 = col = hflip ? 7 - j : j;
                if (pointX >= 256 || this.solidSPLine[pointX] || point >= this.raster.length && point < 61440) continue;
                int pattern = (patternMSB >> col & 1) << 1 | patternLSB >> col & 1;
                int colorAddr = colorH | pattern;
                int color = this.rgbPalette[this.ppuMemory[this.vramMirror[16144 + colorAddr]]];
                if (i == 0 && this.solidBGLine[pointX] && pattern != 0 && (this.controlRegister2 & 8) != 0) {
                    this.statusRegister = (short)(this.statusRegister | 0x40);
                }
                if ((this.controlRegister2 & 0x10) == 0 || bgPriority && this.solidBGLine[pointX] || pattern == 0) continue;
                this.raster[point] = color;
            }
        }
    }

    public void setRaster(int[] raster) {
        this.raster = raster;
    }

    public short externalRead(int address) {
        short value = 0;
        switch (address) {
            case 8192: {
                value = this.controlRegister1;
                break;
            }
            case 8193: {
                value = this.controlRegister2;
                break;
            }
            case 8194: {
                this.firstWrite = true;
                value = this.statusRegister;
                this.statusRegister = (short)(this.statusRegister & 0x7F);
                break;
            }
            case 8196: {
                value = this.spriteMemory[this.sramAddress];
                this.sramAddress = (short)(this.sramAddress + 1);
                this.sramAddress = (short)(this.sramAddress & 0xFF);
                break;
            }
            case 8199: {
                value = this.ppuLatch;
                this.ppuLatch = this.readVRAM();
            }
        }
        return value;
    }

    public void externalWrite(int address, short value) {
        switch (address) {
            case 8192: {
                this.controlRegister1 = value;
                this.loopyT &= 0xF3FF;
                this.loopyT |= (value & 3) << 10;
                break;
            }
            case 8193: {
                this.controlRegister2 = value;
                break;
            }
            case 8194: {
                break;
            }
            case 8195: {
                this.sramAddress = value;
                break;
            }
            case 8196: {
                this.spriteMemory[this.sramAddress] = value;
                this.sramAddress = (short)(this.sramAddress + 1);
                this.sramAddress = (short)(this.sramAddress & 0xFF);
                break;
            }
            case 8197: {
                if (this.firstWrite) {
                    this.loopyT &= 0xFFE0;
                    this.loopyT |= (value & 0xF8) >> 3;
                    this.loopyX = value & 7;
                } else {
                    this.loopyT &= 0xFC1F;
                    this.loopyT |= (value & 0xF8) << 2;
                    this.loopyT &= 0x8FFF;
                    this.loopyT |= (value & 7) << 12;
                }
                this.firstWrite = !this.firstWrite;
                break;
            }
            case 8198: {
                if (this.firstWrite) {
                    this.loopyT &= 0xFF;
                    this.loopyT |= (value & 0x3F) << 8;
                } else {
                    this.loopyT &= 0xFF00;
                    this.loopyT |= value;
                    this.loopyV = this.loopyT;
                }
                this.firstWrite = !this.firstWrite;
                break;
            }
            case 8199: {
                this.writeVRAM(value);
                break;
            }
            case 16404: {
                this.spriteMemory[this.sramAddress] = value;
                int baseAddress = value * 256;
                for (int i = this.sramAddress; i <= 255; ++i) {
                    short data;
                    this.spriteMemory[i] = data = this.nes.getMapper().read(baseAddress + i);
                }
                break;
            }
        }
    }

    public void writeVRAM(short value) {
        int address = this.vramMirror[this.loopyV];
        this.ppuMemory[address] = value;
        this.loopyV += (this.controlRegister1 >> 2 & 1) == 0 ? 1 : 32;
    }

    public short readVRAM() {
        short value = this.ppuMemory[this.vramMirror[this.loopyV]];
        this.loopyV += (this.controlRegister1 >> 2 & 1) == 0 ? 1 : 32;
        return value;
    }

    public void writeMirror(int src, int dest, int length) {
        for (int i = 0; i < length; ++i) {
            this.vramMirror[src + i] = dest + i;
        }
    }
}

