/*
 * Decompiled with CFR 0.152.
 */
package beanes.sound;

import beanes.PAPU;
import beanes.sound.SoundChannel;

public class SquareChannel
extends SoundChannel {
    private int dutyMode;
    private boolean lengthCounterEnable;
    private boolean envDisable;
    private int envDecayRate;
    private int lengthCounterHalt;
    private int envelope;
    private boolean sweepEnable;
    private int sweepCounter;
    private int sweepMode;
    private int sweepShiftCount;
    private int pulseTimer;
    private int lengthCounter;
    private byte volume = (byte)120;
    public byte sample;
    public static final int[] DUTY_LOOKUP = new int[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1};

    public SquareChannel(PAPU papu) {
        super(papu);
    }

    public void write(int address, short value) {
        switch (address) {
            case 16384: 
            case 16388: {
                this.dutyMode = value >> 6 & 3;
                this.lengthCounterEnable = (value & 0x20) == 0;
                this.envDisable = (value & 0x10) != 0;
                this.envDecayRate = value & 0xF;
                break;
            }
            case 16385: 
            case 16389: {
                this.sweepEnable = (value & 0x80) != 0;
                this.sweepCounter = value >> 4 & 7;
                this.sweepMode = value >> 3 & 1;
                this.sweepShiftCount = value & 7;
                break;
            }
            case 16386: 
            case 16390: {
                this.pulseTimer &= 0x7000;
                this.pulseTimer |= value;
                break;
            }
            case 16387: 
            case 16391: {
                this.pulseTimer &= 0xFF;
                this.pulseTimer |= (value & 7) << 8;
                this.lengthCounter = value >> 3 & 0x1F;
            }
        }
        this.process();
    }

    public void clockLengthCounter() {
        if (this.lengthCounterEnable && this.lengthCounter > 0) {
            --this.lengthCounter;
            if (this.lengthCounter == 0) {
                this.process();
            }
        }
    }

    public void process() {
        boolean output = false;
        this.sample = this.lengthCounter > 0 && this.pulseTimer > 7 ? (this.sweepMode == 0 && this.pulseTimer + (this.pulseTimer >> this.sweepShiftCount) > 4095 ? (byte)0 : (byte)(this.volume * DUTY_LOOKUP[this.dutyMode << 3])) : (byte)0;
        this.pulseTimer = this.pulseTimer - (this.pulseTimer >> this.sweepShiftCount) - 1;
    }
}

