/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import beanes.BeaNES;
import beanes.BeaNESProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class VideoPanel
extends JFrame {
    private BeaNES nes;
    private Vector<String> dmCols = new Vector();
    private Vector<Vector> dmRows = new Vector();
    private JTable dmTable;
    private JScrollPane dmScroll;
    private JButton saveButton = new JButton("save");
    private DisplayMode[] dms;

    public VideoPanel(BeaNES nes) {
        this.nes = nes;
        this.dmCols.add("Width");
        this.dmCols.add("Height");
        this.dmCols.add("Bit Depth");
        this.dmCols.add("Refresh Rate");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = ge.getScreenDevices();
        this.dms = devices[0].getDisplayModes();
        for (int k = 0; k < this.dms.length; ++k) {
            Vector<Integer> row = new Vector<Integer>();
            row.add(this.dms[k].getWidth());
            row.add(this.dms[k].getHeight());
            row.add(this.dms[k].getBitDepth());
            row.add(this.dms[k].getRefreshRate());
            this.dmRows.add(row);
        }
        int selectedRow = 0;
        try {
            selectedRow = Integer.valueOf(BeaNES.getProperties().getProperty(BeaNESProperties.PROPERTY_FULLSCREEN_RESOLUTION_MODE));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.dmTable = new JTable(this.dmRows, this.dmCols);
        this.dmScroll = new JScrollPane(this.dmTable);
        this.dmTable.setRowSelectionInterval(selectedRow, selectedRow);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VideoPanel.this.getNES().setFullScreenDisplayMode(VideoPanel.this.dms[VideoPanel.this.getDMTable().getSelectedRow()]);
                BeaNES.getProperties().setProperty(BeaNESProperties.PROPERTY_FULLSCREEN_RESOLUTION_MODE, Integer.toString(VideoPanel.this.getDMTable().getSelectedRow()));
                VideoPanel.this.setVisible(false);
            }
        });
        this.add(this.dmScroll);
        this.setLayout(new BorderLayout());
        JPanel southPanel = new JPanel();
        southPanel.add(this.saveButton);
        this.add((Component)southPanel, "South");
        this.add((Component)this.dmScroll, "Center");
        this.setSize(new Dimension(500, 300));
        this.setMinimumSize(new Dimension(500, 300));
        this.setVisible(true);
    }

    private BeaNES getNES() {
        return this.nes;
    }

    private JTable getDMTable() {
        return this.dmTable;
    }
}

