/*
 * Decompiled with CFR 0.152.
 */
package beanes;

import beanes.BeaNESProperties;
import beanes.CPU;
import beanes.Clock;
import beanes.GUI;
import beanes.JoypadInput;
import beanes.MemoryMapper;
import beanes.PAPU;
import beanes.PPU;
import beanes.ROM;
import beanes.VideoOutput;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;

public class BeaNES {
    public static final String PROGRAM_NAME = "BeaNES";
    public static final String PROGRAM_VERSION = "0.0.1";
    public static final String PROGRAM_STRING = "BeaNES-0.0.1";
    private Clock clock;
    private VideoOutput video;
    private JoypadInput[] joypads = new JoypadInput[2];
    private DisplayMode fullScreenDisplayMode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
    private PPU ppu;
    private PAPU papu;
    private ROM rom;
    private GUI gui;
    private CPU cpu;
    private static BeaNESProperties properties;

    public BeaNES(GUI g) {
        this.gui = g;
        properties = new BeaNESProperties();
        this.clock = new Clock(this);
        this.cpu = new CPU(this);
        this.ppu = new PPU(this);
        this.video = new VideoOutput(this);
        this.papu = new PAPU(this);
        for (int i = 0; i < this.joypads.length; ++i) {
            this.joypads[i] = new JoypadInput(this, i);
        }
    }

    public void start() {
        this.hardReset();
    }

    public void stop() {
        this.clock.stop();
    }

    public CPU getCPU() {
        return this.cpu;
    }

    public PPU getPPU() {
        return this.ppu;
    }

    public PAPU getPAPU() {
        return this.papu;
    }

    public void hardReset() {
        this.stop();
        this.cpu.hardReset();
        this.ppu.hardReset();
        this.clock.start();
    }

    public void reset() {
        this.cpu.reset();
    }

    public Clock getClock() {
        return this.clock;
    }

    public VideoOutput getVideoOutput() {
        return this.video;
    }

    public JoypadInput getJoypadInput(int num) {
        return this.joypads[num];
    }

    public GUI getGUI() {
        return this.gui;
    }

    public void loadROM(ROM rom) {
        this.rom = rom;
        rom.load();
        rom.getMapper().loadROM(rom);
    }

    public ROM getROM() {
        return this.rom;
    }

    public MemoryMapper getMapper() {
        return this.rom.getMapper();
    }

    public DisplayMode getFullScreenDisplayMode() {
        return this.fullScreenDisplayMode;
    }

    public void setFullScreenDisplayMode(DisplayMode dm) {
        this.fullScreenDisplayMode = dm;
    }

    public static void main(String[] args) {
        GUI gui = new GUI();
        gui.start();
    }

    public static BeaNESProperties getProperties() {
        return properties;
    }
}

