/*
 * Decompiled with CFR 0.152.
 */
package beanes;

import beanes.BeaNES;

public class Clock
implements Runnable {
    private BeaNES nes;
    private Thread thread;
    private long currVBlankTime;
    private long lastVBlankTime;
    private boolean paused = false;
    private boolean throttle = true;
    private boolean running = false;

    public Clock(BeaNES nes) {
        this.nes = nes;
    }

    public void start() {
        this.running = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.thread != null;
    }

    public synchronized void run() {
        long cpuNewCycles = 0L;
        long ppuNewCycles = 341L;
        while (this.running) {
            while (this.paused) {
            }
            while (ppuNewCycles <= cpuNewCycles * 3L) {
                ppuNewCycles += (long)this.nes.getPPU().runCycles(24);
            }
            while (cpuNewCycles <= ppuNewCycles / 3L) {
                cpuNewCycles += (long)this.nes.getCPU().processNextInstruction();
            }
        }
        this.thread = null;
    }

    public boolean isThrottle() {
        return this.throttle;
    }

    public void setThrottle(boolean value) {
        this.throttle = value;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean value) {
        this.paused = value;
    }

    public void signalVBlank() {
        if (this.throttle) {
            do {
                this.currVBlankTime = System.nanoTime();
            } while (this.currVBlankTime - this.lastVBlankTime < 16666667L);
            this.lastVBlankTime = this.currVBlankTime;
        }
    }
}

