/*
 * Decompiled with CFR 0.152.
 */
package beanes;

import beanes.BeaNES;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.VolatileImage;
import javax.swing.JComponent;

public class VideoOutput
extends JComponent {
    BeaNES nes;
    private int width = 256;
    private int height = 256;
    private BufferedImage img;
    private DataBufferInt dbi;
    private VolatileImage vimg;
    private Font font = new Font("sansserif", 0, 10);
    private int fpsCounter = 0;
    private long prevFrameTime = 0L;
    private boolean showFPS = true;
    private String fps = "FPS: -";
    private int[] raster;

    public VideoOutput(BeaNES nes) {
        this.nes = nes;
        this.setPreferredSize(new Dimension(this.width, this.height));
    }

    public boolean isShowFPS() {
        return this.showFPS;
    }

    public void setShowFPS(boolean value) {
        this.showFPS = value;
    }

    public void initializeImage() {
        this.img = new BufferedImage(this.width, this.height, 1);
        this.dbi = (DataBufferInt)this.img.getRaster().getDataBuffer();
        this.raster = this.dbi.getData();
        this.nes.getPPU().setRaster(this.raster);
    }

    public void renderImage(int[] image) {
        this.raster = image;
        if (this.showFPS && --this.fpsCounter <= 0) {
            long ct = System.nanoTime() / 1000L;
            long frameT = (ct - this.prevFrameTime) / 45L;
            this.fps = frameT == 0L ? "FPS: -" : "FPS: " + 1000000L / frameT;
            this.fpsCounter = 45;
            this.prevFrameTime = ct;
        }
        this.invalidate();
        Graphics g = this.getGraphics();
        if (g != null) {
            this.update(g);
            g.dispose();
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.createBackBuffer();
        do {
            GraphicsConfiguration gc;
            int valCode;
            if ((valCode = this.vimg.validate(gc = this.getGraphicsConfiguration())) == 2) {
                this.createBackBuffer();
            }
            Graphics2D offscreenGraphics = (Graphics2D)this.vimg.getGraphics();
            offscreenGraphics.drawImage(this.img, 0, 0, this.getWidth(), this.getHeight(), null);
            offscreenGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            offscreenGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            offscreenGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            if (g == null || this.vimg == null) continue;
            g.drawImage(this.vimg, 0, 0, this);
            g.setFont(this.font);
            g.setColor(Color.WHITE);
            if (!this.showFPS) continue;
            g.drawString(this.fps, 0, 10);
        } while (this.vimg.contentsLost());
    }

    public void createBackBuffer() {
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        this.vimg = this.getWidth() != 0 && this.getHeight() != 0 ? gc.createCompatibleVolatileImage(this.getWidth(), this.getHeight()) : gc.createCompatibleVolatileImage(this.width, this.height);
    }
}

