/*
 * Decompiled with CFR 0.152.
 */
package beanes.mappers;

import beanes.BeaNES;
import beanes.mappers.NESMapper;

public class AOROMMapper
extends NESMapper {
    int offset = 0;
    int mirroring = -1;
    short[] prgROM;

    public AOROMMapper(BeaNES nes) {
        super(nes);
        int banks = nes.getROM().numPRGBanks;
        this.prgROM = new short[banks * 16384];
        for (int i = 0; i < banks; ++i) {
            System.arraycopy(nes.getROM().getROMBank(i), 0, this.prgROM, i * 16384, 16384);
        }
    }

    public short read(int address) {
        if (address < 32768) {
            return super.read(address);
        }
        return this.prgROM[address + this.offset];
    }

    public void write(int address, short value) {
        if (address < 32768) {
            super.write(address, value);
        } else {
            this.offset = (value & 0xF) - 1 << 15;
            if (this.mirroring != (value & 0x10)) {
                this.mirroring = value & 0x10;
                if (this.mirroring == 0) {
                    this.nes.getPPU().setMirroringMode(3);
                } else {
                    this.nes.getPPU().setMirroringMode(4);
                }
            }
        }
    }
}

