/*
 * Decompiled with CFR 0.152.
 */
package beanes.mappers;

import beanes.BeaNES;
import beanes.mappers.NESMapper;

public class GNROMMapper
extends NESMapper {
    public GNROMMapper(BeaNES nes) {
        super(nes);
    }

    public void write(int address, short value) {
        if (address < 32768) {
            super.write(address, value);
        } else {
            int bank1 = (value >> 4 & 3) * 2 % this.nes.getROM().numPRGBanks;
            int bank2 = ((value >> 4 & 3) * 2 + 1) % this.nes.getROM().numPRGBanks;
            this.loadROMBank(bank1, 32768);
            this.loadROMBank(bank2, 49152);
            if (this.nes.getROM().numCHRBanks == 0) {
                return;
            }
            int vbank = (value & 3) * 2 % this.nes.getROM().numCHRBanks;
            this.loadVROMBank(vbank, 0);
            this.loadVROMBank(vbank + 1, 4096);
        }
    }
}

