/*
 * Decompiled with CFR 0.152.
 */
package beanes.mappers;

import beanes.BeaNES;
import beanes.MemoryMapper;
import beanes.ROM;

public class NESMapper
implements MemoryMapper {
    protected BeaNES nes;

    public NESMapper(BeaNES nes) {
        this.nes = nes;
    }

    public short read(int address) {
        short value = 0;
        if (address < 8192) {
            value = this.nes.getCPU().cpuMemory[address & 0x7FF];
        } else if (address <= 8199) {
            value = this.nes.getPPU().externalRead(address);
        } else {
            if (address <= 16405) {
                return value;
            }
            if (address <= 16406) {
                value = this.nes.getCPU().readJoypadInput(0);
            } else if (address <= 16407) {
                value = 0;
                value = this.nes.getCPU().readJoypadInput(1);
            } else if (address > 16407) {
                value = this.nes.getCPU().cpuMemory[address];
            } else {
                System.out.println("Illegal PPU adress read " + Integer.toHexString(address));
                System.exit(1);
            }
        }
        return value;
    }

    public void write(int address, short value) {
        if (address < 8192) {
            this.nes.getCPU().cpuMemory[address & 0x7FF] = value;
        } else {
            if (address <= 8199) {
                this.nes.getPPU().externalWrite(address, value);
                return;
            }
            if (address >= 16384 && address <= 16403) {
                this.nes.getPAPU().write(address, value);
                return;
            }
            if (address == 16404) {
                this.nes.getPPU().externalWrite(address, value);
            } else if (address == 16405) {
                this.nes.getPAPU().write(address, value);
            } else if (address == 16406) {
                this.nes.getCPU().writeJoypadInput(0, value);
            } else if (address == 16407) {
                this.nes.getCPU().writeJoypadInput(1, value);
            } else if (address > 16407) {
                this.nes.getCPU().cpuMemory[address] = value;
            } else {
                System.out.println("Illegal PPU adress write " + Integer.toHexString(address));
                System.exit(1);
            }
        }
    }

    public void loadROM(ROM rom) {
        this.loadROMBank(0, 32768);
        if (rom.numPRGBanks < 2) {
            this.loadROMBank(0, 49152);
        } else {
            this.loadROMBank(1, 49152);
        }
        if (rom.numCHRBanks >= 2) {
            this.loadVROMBank(0, 0);
            this.loadVROMBank(1, 4096);
        }
    }

    public void loadROMBank(int bank, int address) {
        System.arraycopy(this.nes.getROM().getROMBank(bank), 0, this.nes.getCPU().cpuMemory, address, 16384);
    }

    public void loadVROMBank(int bank, int address) {
        System.arraycopy(this.nes.getROM().getVROMBank(bank), 0, this.nes.getPPU().ppuMemory, address, 4096);
    }
}

