/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.compiler.CodeBlock;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.IExecutable;
import jpcsp.Allegrex.compiler.RuntimeContext;

public class InterpretExecutable
implements IExecutable {
    private CodeBlock codeBlock;
    private boolean isAnalyzed;
    private boolean isSimple;

    public InterpretExecutable(CodeBlock codeBlock) {
        this.codeBlock = codeBlock;
        this.isAnalyzed = false;
    }

    @Override
    public int exec() throws Exception {
        int returnAddress;
        if (!this.isAnalyzed) {
            this.isSimple = Compiler.getInstance().checkSimpleInterpretedCodeBlock(this.codeBlock);
            this.isAnalyzed = true;
        }
        if (this.isSimple) {
            Common.Instruction[] insns = this.codeBlock.getInterpretedInstructions();
            int[] opcodes = this.codeBlock.getInterpretedOpcodes();
            for (int i = 0; i < insns.length; ++i) {
                insns[i].interpret(RuntimeContext.processor, opcodes[i]);
            }
            returnAddress = RuntimeContext.cpu._ra;
        } else {
            returnAddress = RuntimeContext.executeInterpreter(this.codeBlock.getStartAddress());
        }
        return returnAddress;
    }

    @Override
    public void setExecutable(IExecutable e) {
    }
}

