/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler.nativeCode;

import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.nativeCode.AbstractNativeCodeSequence;
import jpcsp.Allegrex.compiler.nativeCode.INativeCodeSequence;

public class MemcpySequence
extends AbstractNativeCodeSequence
implements INativeCodeSequence {
    public static void call(int dstAddrReg, int srcAddrReg, int lengthReg) {
        int dstAddr = MemcpySequence.getRegisterValue(dstAddrReg);
        int srcAddr = MemcpySequence.getRegisterValue(srcAddrReg);
        int length = MemcpySequence.getRegisterValue(lengthReg);
        MemcpySequence.getMemory().memcpy(dstAddr, srcAddr, length);
        MemcpySequence.setRegisterValue(dstAddrReg, dstAddr + length);
        MemcpySequence.setRegisterValue(srcAddrReg, srcAddr + length);
        MemcpySequence.setRegisterValue(lengthReg, 0);
    }

    public static void call(int dstAddrReg, int srcAddrReg, int lengthReg, int dstOffset, int srcOffset) {
        int dstAddr = MemcpySequence.getRegisterValue(dstAddrReg);
        int srcAddr = MemcpySequence.getRegisterValue(srcAddrReg);
        int length = MemcpySequence.getRegisterValue(lengthReg);
        MemcpySequence.getMemory().memcpy(dstAddr + dstOffset, srcAddr + srcOffset, length);
        MemcpySequence.setRegisterValue(dstAddrReg, dstAddr + length);
        MemcpySequence.setRegisterValue(srcAddrReg, srcAddr + length);
        MemcpySequence.setRegisterValue(lengthReg, 0);
    }

    public static void call(int dstAddrReg, int srcAddrReg, int targetAddrReg, int targetReg) {
        int dstAddr = MemcpySequence.getRegisterValue(dstAddrReg);
        int srcAddr = MemcpySequence.getRegisterValue(srcAddrReg);
        int targetAddr = MemcpySequence.getRegisterValue(targetAddrReg);
        int length = targetAddr - MemcpySequence.getRegisterValue(targetReg);
        MemcpySequence.getMemory().memcpy(dstAddr, srcAddr, length);
        MemcpySequence.setRegisterValue(dstAddrReg, dstAddr + length);
        MemcpySequence.setRegisterValue(srcAddrReg, srcAddr + length);
    }

    public static void call(int dstAddrReg, int srcAddrReg, int targetAddrReg, int targetReg, int dstOffset, int srcOffset, int valueReg, int valueBytes) {
        int value;
        int dstAddr = MemcpySequence.getRegisterValue(dstAddrReg);
        int srcAddr = MemcpySequence.getRegisterValue(srcAddrReg);
        int targetAddr = MemcpySequence.getRegisterValue(targetAddrReg);
        int length = targetAddr - MemcpySequence.getRegisterValue(targetReg);
        MemcpySequence.getMemory().memcpy(dstAddr + dstOffset, srcAddr + srcOffset, length);
        MemcpySequence.setRegisterValue(dstAddrReg, dstAddr + length);
        MemcpySequence.setRegisterValue(srcAddrReg, srcAddr + length);
        int valueAddr = srcAddr + length - valueBytes;
        switch (valueBytes) {
            case 1: {
                value = MemcpySequence.getMemory().read8(valueAddr);
                break;
            }
            case 2: {
                value = MemcpySequence.getMemory().read16(valueAddr);
                break;
            }
            case 4: {
                value = MemcpySequence.getMemory().read32(valueAddr);
                break;
            }
            default: {
                value = 0;
                Compiler.log.error((Object)("MemcpySequence.call(): Unimplemented valueBytes=" + valueBytes));
            }
        }
        MemcpySequence.setRegisterValue(valueReg, value);
    }

    public static void callWithStep(int dstAddrReg, int srcAddrReg, int lengthReg, int step, int lengthOffset) {
        int dstAddr = MemcpySequence.getRegisterValue(dstAddrReg);
        int srcAddr = MemcpySequence.getRegisterValue(srcAddrReg);
        int length = (MemcpySequence.getRegisterValue(lengthReg) + lengthOffset) * step;
        MemcpySequence.getMemory().memcpy(dstAddr, srcAddr, length);
        MemcpySequence.setRegisterValue(dstAddrReg, dstAddr + length);
        MemcpySequence.setRegisterValue(srcAddrReg, srcAddr + length);
        MemcpySequence.setRegisterValue(lengthReg, 0);
    }

    public static void callWithCountStep(int dstAddrReg, int srcAddrReg, int lengthReg, int count, int step) {
        int dstAddr = MemcpySequence.getRegisterValue(dstAddrReg);
        int srcAddr = MemcpySequence.getRegisterValue(srcAddrReg);
        int length = (count - MemcpySequence.getRegisterValue(lengthReg)) * step;
        MemcpySequence.getMemory().memcpy(dstAddr, srcAddr, length);
        MemcpySequence.setRegisterValue(dstAddrReg, dstAddr + length);
        MemcpySequence.setRegisterValue(srcAddrReg, srcAddr + length);
        MemcpySequence.setRegisterValue(lengthReg, count);
    }

    public static void callFixedLength(int dstAddrReg, int srcAddrReg, int dstOffset, int srcOffset, int length) {
        int dstAddr = MemcpySequence.getRegisterValue(dstAddrReg) + dstOffset;
        int srcAddr = MemcpySequence.getRegisterValue(srcAddrReg) + srcOffset;
        MemcpySequence.getMemory().memcpy(dstAddr, srcAddr, length);
    }

    public static void callFixedLength(int dstAddrReg, int srcAddrReg, int dstOffset, int srcOffset, int length, int updatedSrcAddrReg) {
        int dstAddr = MemcpySequence.getRegisterValue(dstAddrReg) + dstOffset;
        int srcAddr = MemcpySequence.getRegisterValue(srcAddrReg) + srcOffset;
        MemcpySequence.getMemory().memcpy(dstAddr, srcAddr, length);
        MemcpySequence.setRegisterValue(updatedSrcAddrReg, srcAddr);
    }

    public static void callIndirectLength(int dstAddrReg, int srcAddrReg, int lengthAddrReg, int lengthAddrOffset) {
        int dstAddr = MemcpySequence.getRegisterValue(dstAddrReg);
        int srcAddr = MemcpySequence.getRegisterValue(srcAddrReg);
        int length = MemcpySequence.getMemory().read32(MemcpySequence.getRegisterValue(lengthAddrReg) + lengthAddrOffset);
        MemcpySequence.getMemory().memcpy(dstAddr, srcAddr, length);
        MemcpySequence.setRegisterValue(dstAddrReg, dstAddr + length);
        MemcpySequence.setRegisterValue(srcAddrReg, srcAddr + length);
    }
}

