/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger.DisassemblerModule;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.settings.Settings;

public class VfpuFrame
extends JFrame {
    private static final long serialVersionUID = -3354614570041807689L;
    JTextField[][][] registers = new JTextField[8][4][4];
    JPanel[] panels = new JPanel[8];
    private static VfpuFrame instance;

    public static VfpuFrame getInstance() {
        if (instance == null) {
            instance = new VfpuFrame();
        }
        return instance;
    }

    private VfpuFrame() {
        this.setDefaultCloseOperation(2);
        this.setTitle("VFPU registers");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                if (Settings.getInstance().readBool("gui.saveWindowPos")) {
                    Settings.getInstance().writeWindowPos("vfpuregisters", VfpuFrame.this.getLocation());
                    Settings.getInstance().writeWindowSize("vfpuregisters", VfpuFrame.this.getSize());
                }
            }
        });
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.registers[i][j][k] = new JTextField();
                }
            }
        }
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        for (int i = 0; i < this.panels.length; ++i) {
            JPanel panel;
            this.panels[i] = panel = new JPanel();
            GroupLayout l = new GroupLayout(panel);
            panel.setLayout(l);
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Block " + i), null));
            l.setHorizontalGroup(l.createSequentialGroup().addGroup(l.createParallelGroup().addComponent(this.registers[i][0][0]).addComponent(this.registers[i][1][0]).addComponent(this.registers[i][2][0]).addComponent(this.registers[i][3][0])).addGroup(l.createParallelGroup().addComponent(this.registers[i][0][1]).addComponent(this.registers[i][1][1]).addComponent(this.registers[i][2][1]).addComponent(this.registers[i][3][1])).addGroup(l.createParallelGroup().addComponent(this.registers[i][0][2]).addComponent(this.registers[i][1][2]).addComponent(this.registers[i][2][2]).addComponent(this.registers[i][3][2])).addGroup(l.createParallelGroup().addComponent(this.registers[i][0][3]).addComponent(this.registers[i][1][3]).addComponent(this.registers[i][2][3]).addComponent(this.registers[i][3][3])));
            l.setVerticalGroup(l.createSequentialGroup().addGroup(l.createParallelGroup().addComponent(this.registers[i][0][0]).addComponent(this.registers[i][0][1]).addComponent(this.registers[i][0][2]).addComponent(this.registers[i][0][3])).addGroup(l.createParallelGroup().addComponent(this.registers[i][1][0]).addComponent(this.registers[i][1][1]).addComponent(this.registers[i][1][2]).addComponent(this.registers[i][1][3])).addGroup(l.createParallelGroup().addComponent(this.registers[i][2][0]).addComponent(this.registers[i][2][1]).addComponent(this.registers[i][2][2]).addComponent(this.registers[i][2][3])).addGroup(l.createParallelGroup().addComponent(this.registers[i][3][0]).addComponent(this.registers[i][3][1]).addComponent(this.registers[i][3][2]).addComponent(this.registers[i][3][3])));
        }
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.panels[0]).addComponent(this.panels[1])).addGroup(layout.createSequentialGroup().addComponent(this.panels[2]).addComponent(this.panels[3])).addGroup(layout.createSequentialGroup().addComponent(this.panels[4]).addComponent(this.panels[5])).addGroup(layout.createSequentialGroup().addComponent(this.panels[6]).addComponent(this.panels[7])));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.panels[0]).addComponent(this.panels[2]).addComponent(this.panels[4]).addComponent(this.panels[6])).addGroup(layout.createSequentialGroup().addComponent(this.panels[1]).addComponent(this.panels[3]).addComponent(this.panels[5]).addComponent(this.panels[7])));
        this.setSize(Settings.getInstance().readWindowSize("vfpuregisters", 100, 100));
        this.setLocation(Settings.getInstance().readWindowPos("vfpuregisters"));
    }

    public void updateRegisters(CpuState cpu) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.registers[i][k][j].setText("" + cpu.getVprFloat(i, j, k));
                    this.registers[i][k][j].setCaretPosition(0);
                }
            }
        }
    }

    @Override
    public void dispose() {
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }
}

