/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IError;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.io.IURLProtocolHandler;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.MainGUI;
import jpcsp.State;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class UmdVideoPlayer
implements KeyListener {
    private static Logger log = Logger.getLogger((String)"videoplayer");
    private static final int BASE_VIDEO_WIDTH = 480;
    private static final int BASE_VIDEO_HEIGTH = 272;
    private String fileName;
    private UmdIsoReader iso;
    private UmdIsoFile isoFile;
    private List<MpsStreamInfo> mpsStreams;
    private int currentStreamIndex;
    private JLabel display;
    private int screenWidth;
    private int screenHeigth;
    private IContainer container;
    private IVideoResampler resampler;
    private int videoStreamId;
    private IStreamCoder videoCoder;
    private int audioStreamId;
    private IStreamCoder audioCoder;
    private IPacket packet;
    private long firstTimestampInStream;
    private long systemClockStartTime;
    private IConverter converter;
    private BufferedImage image;
    private volatile boolean seekFrameFastForward;
    private volatile boolean seekFrameRewind;
    private volatile FrameSeekState frameSeekState;
    private volatile boolean startNewPicture;
    private volatile boolean videoPaused;
    private volatile boolean done;
    private volatile boolean endOfVideo;
    private volatile boolean threadExit;
    private MpsDisplayThread displayThread;
    private MpsInput mpsInput;
    private SourceDataLine mLine;

    private static String getTimestampString(int timestamp) {
        int seconds = timestamp / 90000;
        int minutes = seconds / 60;
        seconds -= minutes * 60;
        int hours = minutes / 60;
        minutes -= hours * 60;
        if (hours == 0) {
            return String.format("%02d:%02d", minutes, seconds);
        }
        return String.format("%d:%02d:%02d", hours, minutes, seconds);
    }

    public UmdVideoPlayer(MainGUI gui, UmdIsoReader iso) {
        this.iso = iso;
        this.display = new JLabel();
        gui.remove(Modules.sceDisplayModule.getCanvas());
        gui.getContentPane().add((Component)this.display, "Center");
        gui.addKeyListener(this);
        this.setVideoPlayerResizeScaleFactor(gui, 1);
        this.init();
    }

    @Override
    public void keyPressed(KeyEvent keyCode2) {
        if (keyCode2.getKeyCode() == 39) {
            this.stopDisplayThread();
            this.goToNextMpsStream();
        } else if (keyCode2.getKeyCode() == 37 && this.currentStreamIndex > 0) {
            this.stopDisplayThread();
            this.goToPreviousMpsStream();
        } else if (keyCode2.getKeyCode() == 87 && !this.videoPaused) {
            this.pauseVideo();
        } else if (keyCode2.getKeyCode() == 83) {
            this.resumeVideo();
        } else if (keyCode2.getKeyCode() == 65) {
            this.rewind();
        } else if (keyCode2.getKeyCode() == 68) {
            this.fastForward();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyCode2) {
    }

    @Override
    public void keyTyped(KeyEvent keyCode2) {
    }

    private void init() {
        this.image = null;
        this.done = false;
        this.threadExit = false;
        this.isoFile = null;
        this.mpsStreams = new LinkedList<MpsStreamInfo>();
        this.currentStreamIndex = 0;
        this.parsePlaylistFile();
        log.info((Object)"Setting aspect ratio to 16:9");
        if (this.currentStreamIndex < this.mpsStreams.size()) {
            MpsStreamInfo info = this.mpsStreams.get(this.currentStreamIndex);
            this.fileName = "UMD_VIDEO/STREAM/" + info.getName() + ".MPS";
            log.info((Object)("Loading stream: " + this.fileName));
            try {
                this.isoFile = this.iso.getFile(this.fileName);
                String cpiFileName = "UMD_VIDEO/CLIPINF/" + info.getName() + ".CLP";
                UmdIsoFile cpiFile = this.iso.getFile(cpiFileName);
                if (cpiFile != null) {
                    log.info((Object)("Found CLIPINF data for this stream: " + cpiFileName));
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                Emulator.log.error((Object)e);
            }
        }
        if (this.isoFile != null) {
            this.startVideo();
        }
    }

    public void setVideoPlayerResizeScaleFactor(MainGUI gui, int factor) {
        this.screenWidth = 480 * factor;
        this.screenHeigth = 272 * factor;
        Insets insets = gui.getInsets();
        Dimension minSize = new Dimension(this.screenWidth + insets.left + insets.right, this.screenHeigth + insets.top + insets.bottom);
        gui.setMinimumSize(minSize);
    }

    private int endianSwap32(int x) {
        return Integer.reverseBytes(x);
    }

    private short endianSwap16(short x) {
        return Short.reverseBytes(x);
    }

    private void parsePlaylistFile() {
        try {
            UmdIsoFile file = this.iso.getFile("UMD_VIDEO/PLAYLIST.UMD");
            int umdvMagic = file.readInt();
            int umdvVersion = file.readInt();
            int globalDataOffset = this.endianSwap32(file.readInt());
            file.seek(globalDataOffset);
            int playListSize = this.endianSwap32(file.readInt());
            int playListTracksNum = this.endianSwap16(file.readShort());
            file.skipBytes(2);
            if (umdvMagic != 1447316821) {
                log.warn((Object)"Accessing invalid PLAYLIST.UMD file!");
            } else {
                log.info((Object)("Accessing valid PLAYLIST.UMD file: playListSize=" + playListSize + ", playListTracksNum=" + playListTracksNum));
            }
            for (int i = 0; i < playListTracksNum; ++i) {
                file.skipBytes(2);
                file.skipBytes(2);
                file.skipBytes(2);
                file.skipBytes(30);
                file.skipBytes(2);
                file.skipBytes(2);
                short releaseDateYear = this.endianSwap16(file.readShort());
                byte releaseDateDay = file.readByte();
                byte releaseDateMonth = file.readByte();
                file.skipBytes(4);
                file.skipBytes(4);
                file.skipBytes(1);
                file.skipBytes(732);
                int streamHeight = file.readByte() * 16;
                file.skipBytes(2);
                file.skipBytes(4);
                file.skipBytes(1);
                int streamWidth = file.readByte() * 16;
                file.skipBytes(1);
                byte streamNameCharsNum = file.readByte();
                byte[] stringBuf = new byte[5];
                file.read(stringBuf, 0, 5);
                String streamName = new String(stringBuf);
                file.skipBytes(3);
                file.skipBytes(2);
                int streamFirstTimestamp = this.endianSwap32(file.readInt());
                file.skipBytes(2);
                int streamLastTimestamp = this.endianSwap32(file.readInt());
                file.skipBytes(2);
                short streamMarkerDataLength = this.endianSwap16(file.readShort());
                int streamMarkersNum = this.endianSwap16(file.readShort());
                MpsStreamMarkerInfo[] streamMarkers = new MpsStreamMarkerInfo[streamMarkersNum];
                for (int j = 0; j < streamMarkersNum; ++j) {
                    file.skipBytes(1);
                    byte streamMarkerCharsNum = file.readByte();
                    file.skipBytes(4);
                    int streamMarkerTimestamp = this.endianSwap32(file.readInt());
                    file.skipBytes(2);
                    file.skipBytes(4);
                    byte[] markerBuf = new byte[24];
                    file.read(markerBuf, 0, 24);
                    String markerName = new String(markerBuf, 0, (int)streamMarkerCharsNum);
                    if (j + 1 == streamMarkersNum) {
                        file.skip(2L);
                    }
                    streamMarkers[j] = new MpsStreamMarkerInfo(markerName, streamMarkerTimestamp);
                }
                MpsStreamInfo info = new MpsStreamInfo(streamName, streamWidth, streamHeight, streamFirstTimestamp, streamLastTimestamp, streamMarkers);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("StreamInfo #%d: %s", i, info));
                }
                this.mpsStreams.add(info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean goToNextMpsStream() {
        if (this.currentStreamIndex + 1 >= this.mpsStreams.size()) {
            return false;
        }
        ++this.currentStreamIndex;
        MpsStreamInfo info = this.mpsStreams.get(this.currentStreamIndex);
        this.fileName = "UMD_VIDEO/STREAM/" + info.getName() + ".MPS";
        log.info((Object)("Loading stream: " + this.fileName));
        try {
            this.isoFile = this.iso.getFile(this.fileName);
            String cpiFileName = "UMD_VIDEO/CLIPINF/" + info.getName() + ".CLP";
            UmdIsoFile cpiFile = this.iso.getFile(cpiFileName);
            if (cpiFile != null) {
                log.info((Object)("Found CLIPINF data for this stream: " + cpiFileName));
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Emulator.log.error((Object)e);
        }
        if (this.isoFile != null) {
            this.startVideo();
            this.initVideo();
        }
        return true;
    }

    private boolean goToPreviousMpsStream() {
        if (this.currentStreamIndex <= 0) {
            return false;
        }
        --this.currentStreamIndex;
        MpsStreamInfo info = this.mpsStreams.get(this.currentStreamIndex);
        this.fileName = "UMD_VIDEO/STREAM/" + info.getName() + ".MPS";
        log.info((Object)("Loading stream: " + this.fileName));
        try {
            this.isoFile = this.iso.getFile(this.fileName);
            String cpiFileName = "UMD_VIDEO/CLIPINF/" + info.getName() + ".CLP";
            UmdIsoFile cpiFile = this.iso.getFile(cpiFileName);
            if (cpiFile != null) {
                log.info((Object)("Found CLIPINF data for this stream: " + cpiFileName));
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Emulator.log.error((Object)e);
        }
        if (this.isoFile != null) {
            this.startVideo();
            this.initVideo();
        }
        return true;
    }

    public void initVideo() {
        this.done = false;
        this.videoPaused = false;
        if (this.displayThread == null) {
            this.displayThread = new MpsDisplayThread();
            this.displayThread.setDaemon(true);
            this.displayThread.setName("UMD Video Player Thread");
            this.displayThread.start();
        }
    }

    public void pauseVideo() {
        this.videoPaused = true;
    }

    public void resumeVideo() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Resume video", new Object[0]));
        }
        this.firstTimestampInStream = Global.NO_PTS;
        this.videoPaused = false;
        this.seekFrameFastForward = false;
        this.seekFrameRewind = false;
        this.frameSeekState = FrameSeekState.noSeek;
    }

    public void fastForward() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Fast forward", new Object[0]));
        }
        this.seekFrameFastForward = true;
        this.seekFrameRewind = false;
    }

    public void rewind() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Rewind", new Object[0]));
        }
        this.seekFrameFastForward = false;
        this.seekFrameRewind = true;
    }

    public boolean startVideo() {
        this.endOfVideo = false;
        this.videoPaused = false;
        this.closeVideo();
        this.closeAudio();
        try {
            this.container = IContainer.make();
        }
        catch (Throwable e) {
            Emulator.log.error((Object)e);
            return false;
        }
        try {
            this.isoFile.seek(0L);
        }
        catch (IOException e) {
            Emulator.log.error((Object)e);
            return false;
        }
        this.mpsInput = new MpsInput(this.isoFile);
        if (this.container.open((IURLProtocolHandler)this.mpsInput, IContainer.Type.READ, null) < 0) {
            Emulator.log.error((Object)("could not open file: " + this.fileName));
            return false;
        }
        int numStreams = this.container.getNumStreams();
        this.videoStreamId = -1;
        this.videoCoder = null;
        this.audioStreamId = -1;
        this.audioCoder = null;
        boolean audioMuted = Settings.getInstance().readBool("emu.mutesound");
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = this.container.getStream((long)i);
            IStreamCoder coder = stream.getStreamCoder();
            if (coder.getCodecType() == ICodec.Type.CODEC_TYPE_VIDEO) {
                this.videoStreamId = i;
                this.videoCoder = coder;
                continue;
            }
            if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_AUDIO || audioMuted) continue;
            this.audioStreamId = i;
            this.audioCoder = coder;
        }
        if (this.videoCoder != null && this.videoCoder.open(null, null) < 0) {
            Emulator.log.error((Object)("could not open video decoder for container: " + this.fileName));
            return false;
        }
        if (this.audioCoder != null && this.audioCoder.open(null, null) < 0) {
            Emulator.log.info((Object)("AT3+ audio format is not yet supported by Jpcsp (file=" + this.fileName + ")"));
            return false;
        }
        this.resampler = null;
        if (this.videoCoder != null) {
            this.converter = ConverterFactory.createConverter((String)"XUGGLER-BGR-24", (IPixelFormat.Type)IPixelFormat.Type.BGR24, (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight());
            if (this.videoCoder.getPixelType() != IPixelFormat.Type.BGR24) {
                this.resampler = IVideoResampler.make((int)this.screenWidth, (int)this.screenHeigth, (IPixelFormat.Type)IPixelFormat.Type.BGR24, (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight(), (IPixelFormat.Type)this.videoCoder.getPixelType());
                if (this.resampler == null) {
                    Emulator.log.error((Object)("could not create color space resampler for: " + this.fileName));
                    return false;
                }
            }
        }
        if (this.audioCoder != null) {
            this.openAudio(this.audioCoder);
        }
        this.packet = IPacket.make();
        this.firstTimestampInStream = Global.NO_PTS;
        this.systemClockStartTime = 0L;
        return true;
    }

    private void closeVideo() {
        if (this.container != null) {
            this.container.close();
            this.container = null;
        }
        if (this.videoCoder != null) {
            this.videoCoder.close();
            this.videoCoder = null;
        }
        if (this.resampler != null) {
            this.resampler.delete();
            this.resampler = null;
        }
        if (this.converter != null) {
            this.converter.delete();
            this.converter = null;
        }
        if (this.packet != null) {
            this.packet.delete();
            this.packet = null;
        }
        this.frameSeekState = FrameSeekState.noSeek;
        this.startNewPicture = false;
    }

    private void stopDisplayThread() {
        this.done = true;
        while (this.displayThread != null && !this.threadExit) {
            Utilities.sleep(1, 0);
        }
        this.displayThread = null;
    }

    public void stopVideo() {
        this.stopDisplayThread();
        this.closeVideo();
        this.closeAudio();
        if (this.isoFile != null) {
            try {
                this.isoFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void stepVideo() {
        if (this.container.readNextPacket(this.packet) >= 0) {
            int bytesDecoded;
            int offset;
            if (this.packet.getStreamIndex() == this.videoStreamId && this.videoCoder != null) {
                IVideoPicture picture = IVideoPicture.make((IPixelFormat.Type)this.videoCoder.getPixelType(), (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight());
                offset = 0;
                while (offset < this.packet.getSize()) {
                    bytesDecoded = this.videoCoder.decodeVideo(picture, this.packet, offset);
                    if (bytesDecoded < 0) {
                        return;
                    }
                    offset += bytesDecoded;
                    if (this.startNewPicture && this.frameSeekState == FrameSeekState.waitForKeyFrameStart && picture.isKeyFrame()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Start of key frame detected", new Object[0]));
                        }
                        this.frameSeekState = FrameSeekState.waitForKeyFrameEnd;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("startNewPicture=%b, isKeyFrame=%b, isComplete=%b, frameSeekState=%s, timestamp=%d", new Object[]{this.startNewPicture, picture.isKey(), picture.isComplete(), this.frameSeekState, picture.getTimeStamp() > 0L ? picture.getTimeStamp() : 0L}));
                    }
                    if (picture.isComplete()) {
                        this.startNewPicture = true;
                        if (this.frameSeekState == FrameSeekState.waitForKeyFrameEnd) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("End of key frame detected", new Object[0]));
                            }
                            this.frameSeekState = FrameSeekState.noSeek;
                        }
                        if (this.frameSeekState != FrameSeekState.noSeek) continue;
                        IVideoPicture newPic = picture;
                        if (this.resampler != null && this.resampler.resample(newPic = IVideoPicture.make((IPixelFormat.Type)this.resampler.getOutputPixelFormat(), (int)this.screenWidth, (int)this.screenHeigth), picture) < 0) {
                            return;
                        }
                        if (newPic.getPixelType() != IPixelFormat.Type.BGR24) {
                            return;
                        }
                        if (this.firstTimestampInStream == Global.NO_PTS) {
                            this.firstTimestampInStream = picture.getTimeStamp();
                            this.systemClockStartTime = System.currentTimeMillis();
                        } else {
                            long systemClockCurrentTime = System.currentTimeMillis();
                            long millisecondsClockTimeSinceStartofVideo = systemClockCurrentTime - this.systemClockStartTime;
                            long millisecondsStreamTimeSinceStartOfVideo = (picture.getTimeStamp() - this.firstTimestampInStream) / 1000L;
                            long millisecondsTolerance = 50L;
                            long millisecondsToSleep = millisecondsStreamTimeSinceStartOfVideo - (millisecondsClockTimeSinceStartofVideo + 50L);
                            if (!(this.seekFrameFastForward || this.seekFrameRewind || this.videoPaused || millisecondsToSleep <= 0L)) {
                                Utilities.sleep((int)millisecondsToSleep, 0);
                            }
                        }
                        if (this.converter == null || newPic == null) continue;
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("Displaying picture", new Object[0]));
                        }
                        this.image = this.converter.toImage(newPic);
                        continue;
                    }
                    this.startNewPicture = false;
                }
            } else if (this.packet.getStreamIndex() == this.audioStreamId && this.audioCoder != null) {
                IAudioSamples samples = IAudioSamples.make((long)1024L, (long)this.audioCoder.getChannels());
                for (offset = 0; offset < this.packet.getSize(); offset += bytesDecoded) {
                    bytesDecoded = this.audioCoder.decodeAudio(samples, this.packet, offset);
                    if (bytesDecoded >= 0) continue;
                    return;
                }
            }
            if (this.frameSeekState == FrameSeekState.noSeek) {
                long seekDts;
                long seekTimestamp;
                if (this.seekFrameFastForward) {
                    int result;
                    int fastForwardMillis = 50;
                    IRational timestamp = IRational.make((int)fastForwardMillis, (int)1000);
                    IStream stream = this.container.getStream((long)this.videoStreamId);
                    long currentDts = stream.getCurrentDts();
                    IRational timeBase = stream.getTimeBase();
                    seekTimestamp = (long)timestamp.divide(timeBase).getValue();
                    seekDts = currentDts + seekTimestamp;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("FastForward %d ms from %d to %d", fastForwardMillis, currentDts, seekDts));
                    }
                    if ((result = this.container.seekKeyFrame(this.videoStreamId, seekDts, 0)) < 0) {
                        log.debug((Object)String.format("seekKeyFrame returned %s", IError.make((int)result)));
                    }
                    this.frameSeekState = FrameSeekState.waitForKeyFrameStart;
                    this.startNewPicture = false;
                } else if (this.seekFrameRewind) {
                    int rewindMillis = 250;
                    IRational timestamp = IRational.make((int)rewindMillis, (int)1000);
                    IStream stream = this.container.getStream((long)this.videoStreamId);
                    long currentDts = stream.getCurrentDts();
                    IRational timeBase = stream.getTimeBase();
                    seekTimestamp = (long)timestamp.divide(timeBase).getValue();
                    seekDts = Math.max(currentDts - seekTimestamp, 0L);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Rewind %d ms from %d to %d", rewindMillis, currentDts, seekDts));
                    }
                    this.container.seekKeyFrame(this.videoStreamId, 0L, IContainer.SEEK_FLAG_BACKWARDS);
                    int result = this.container.seekKeyFrame(this.videoStreamId, seekDts, IContainer.SEEK_FLAG_BACKWARDS);
                    if (result < 0) {
                        log.debug((Object)String.format("seekKeyFrame returned %s", IError.make((int)result)));
                    }
                    this.frameSeekState = FrameSeekState.waitForKeyFrameStart;
                    this.startNewPicture = false;
                }
            }
        } else {
            this.endOfVideo = true;
        }
    }

    private void openAudio(IStreamCoder aAudioCoder) {
        AudioFormat audioFormat = new AudioFormat(aAudioCoder.getSampleRate(), (int)IAudioSamples.findSampleBitDepth((IAudioSamples.Format)aAudioCoder.getSampleFormat()), aAudioCoder.getChannels(), true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            this.mLine = (SourceDataLine)AudioSystem.getLine(info);
            this.mLine.open(audioFormat);
            this.mLine.start();
        }
        catch (IllegalArgumentException iae) {
            this.audioCoder = null;
        }
        catch (LineUnavailableException e) {
            return;
        }
    }

    private void playAudio(IAudioSamples aSamples) {
        byte[] rawBytes = aSamples.getData().getByteArray(0, aSamples.getSize());
        this.mLine.write(rawBytes, 0, aSamples.getSize());
    }

    private void closeAudio() {
        if (this.mLine != null) {
            this.mLine.drain();
            this.mLine.close();
            this.mLine = null;
        }
    }

    public void takeScreenshot() {
        int tag = 0;
        String screenshotName = State.title + "-" + "Shot" + "-" + tag + ".png";
        File screenshot = new File(screenshotName);
        File directory = new File(System.getProperty("user.dir"));
        for (File file : directory.listFiles()) {
            if (!file.getName().contains(State.title + "-" + "Shot")) continue;
            screenshotName = State.title + "-" + "Shot" + "-" + ++tag + ".png";
            screenshot = new File(screenshotName);
        }
        try {
            BufferedImage img = (BufferedImage)this.getImage();
            ImageIO.write((RenderedImage)img, "png", screenshot);
            img.flush();
        }
        catch (Exception e) {
            return;
        }
    }

    private Image getImage() {
        return this.image;
    }

    private static class MpsInput
    implements IURLProtocolHandler {
        private UmdIsoFile file;

        public MpsInput(UmdIsoFile file) {
            this.file = file;
        }

        public boolean isStreamed(String url, int flags) {
            return false;
        }

        public int open(String url, int flags) {
            return 0;
        }

        public int read(byte[] buf, int size) {
            int length = -1;
            try {
                length = this.file.read(buf, 0, size);
                if (length == 0 && size > 0) {
                    length = -1;
                }
            }
            catch (IOException e) {
                log.error((Object)"read", (Throwable)e);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("MpsInput read %d bytes, %d requested", length, size));
            }
            return length;
        }

        public long seek(long offset, int whence) {
            long seek = -1L;
            try {
                switch (whence) {
                    case 0: {
                        seek = offset;
                        break;
                    }
                    case 1: {
                        seek = this.file.getFilePointer() + offset;
                        break;
                    }
                    case 2: {
                        seek = this.file.length() + offset;
                        break;
                    }
                    case 65536: {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("MpsInput seek SEEK_SIZE returning %d", this.file.length()));
                        }
                        return this.file.length();
                    }
                    default: {
                        log.error((Object)String.format("Unknown seek whence %d", whence));
                        return -1L;
                    }
                }
                this.file.seek(seek);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("MpsInput seek offset=%d, whence=%d, returning %d", offset, whence, seek));
            }
            return seek;
        }

        public int write(byte[] buf, int size) {
            return -1;
        }

        public int close() {
            try {
                this.file.close();
            }
            catch (IOException e) {
                log.error((Object)"close", (Throwable)e);
            }
            this.file = null;
            return 0;
        }
    }

    private class MpsDisplayThread
    extends Thread {
        private MpsDisplayThread() {
        }

        @Override
        public void run() {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Starting Mps Display thread", new Object[0]));
            }
            UmdVideoPlayer.this.threadExit = false;
            while (!UmdVideoPlayer.this.done) {
                while (!UmdVideoPlayer.this.endOfVideo && !UmdVideoPlayer.this.done) {
                    if (!UmdVideoPlayer.this.videoPaused) {
                        UmdVideoPlayer.this.stepVideo();
                        if (UmdVideoPlayer.this.display == null || UmdVideoPlayer.this.image == null) continue;
                        UmdVideoPlayer.this.display.setIcon(new ImageIcon(UmdVideoPlayer.this.getImage()));
                        continue;
                    }
                    Utilities.sleep(10, 0);
                }
                if (UmdVideoPlayer.this.done) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Switching to next stream", new Object[0]));
                }
                if (UmdVideoPlayer.this.goToNextMpsStream()) continue;
                UmdVideoPlayer.this.done = true;
            }
            UmdVideoPlayer.this.threadExit = true;
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Exiting Mps Display thread", new Object[0]));
            }
        }
    }

    protected class MpsStreamMarkerInfo {
        private String streamMarkerName;
        private int streamMarkerTimestamp;

        public MpsStreamMarkerInfo(String name, int timestamp) {
            this.streamMarkerName = name;
            this.streamMarkerTimestamp = timestamp;
        }

        public String getName() {
            return this.streamMarkerName;
        }

        public int getTimestamp() {
            return this.streamMarkerTimestamp;
        }

        public String toString() {
            return String.format("'%s' %s(timeStamp=%d)", this.getName(), UmdVideoPlayer.getTimestampString(this.getTimestamp()), this.getTimestamp());
        }
    }

    protected class MpsStreamInfo {
        private String streamName;
        private int streamWidth;
        private int streamHeigth;
        private int streamFirstTimestamp;
        private int streamLastTimestamp;
        private MpsStreamMarkerInfo[] streamMarkers;

        public MpsStreamInfo(String name, int width, int heigth, int firstTimestamp, int lastTimestamp, MpsStreamMarkerInfo[] markers) {
            this.streamName = name;
            this.streamWidth = width;
            this.streamHeigth = heigth;
            this.streamFirstTimestamp = firstTimestamp;
            this.streamLastTimestamp = lastTimestamp;
            this.streamMarkers = markers;
        }

        public String getName() {
            return this.streamName;
        }

        public int getWidth() {
            return this.streamWidth;
        }

        public int getHeigth() {
            return this.streamHeigth;
        }

        public int getFirstTimestamp() {
            return this.streamFirstTimestamp;
        }

        public int getLastTimestamp() {
            return this.streamLastTimestamp;
        }

        public MpsStreamMarkerInfo[] getMarkers() {
            return this.streamMarkers;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(String.format("name='%s', %dx%d, %s(%d to %d), markers=[", this.getName(), this.getWidth(), this.getHeigth(), UmdVideoPlayer.getTimestampString(this.getLastTimestamp() - this.getFirstTimestamp()), this.getFirstTimestamp(), this.getLastTimestamp()));
            for (int i = 0; i < this.streamMarkers.length; ++i) {
                if (i > 0) {
                    s.append(", ");
                }
                s.append(this.streamMarkers[i]);
            }
            s.append("]");
            return s.toString();
        }
    }

    private static enum FrameSeekState {
        noSeek,
        waitForKeyFrameStart,
        waitForKeyFrameEnd;

    }
}

