/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import jpcsp.HLE.ISerializeArray;
import jpcsp.HLE.ISerializeString;

public class SerializeMemory {
    public static void serialize(Object object, Field objectField, DataOutputStream dataOutputStream) throws Throwable {
        Class<?> objectClass = object.getClass();
        if (objectClass == Integer.TYPE) {
            dataOutputStream.writeInt((Integer)object);
            return;
        }
        if (objectClass == Short.TYPE) {
            dataOutputStream.writeShort(((Short)object).shortValue());
            return;
        }
        if (objectClass == Float.TYPE) {
            dataOutputStream.writeFloat(((Float)object).floatValue());
            return;
        }
        if (objectClass == Long.TYPE) {
            dataOutputStream.writeLong((Long)object);
            return;
        }
        if (objectClass == String.class) {
            ISerializeString serializeString = objectClass.getAnnotation(ISerializeString.class);
            String string = (String)object;
            int size = serializeString.size();
            byte padWith = serializeString.padWith();
            byte[] data = string.getBytes(Charset.forName(serializeString.charset()));
            if (data.length >= size - 1) {
                throw new Exception(String.format("(Field '%s') contains a value too long %d", objectField, data.length));
            }
            for (int n = 0; n < size; ++n) {
                if (n < data.length) {
                    dataOutputStream.writeByte(data[n]);
                    continue;
                }
                dataOutputStream.writeByte(padWith);
            }
            return;
        }
        if (objectClass.isArray()) {
            int arrayLength;
            ISerializeArray serializeArray = objectClass.getAnnotation(ISerializeArray.class);
            int count = serializeArray.size();
            if (count != (arrayLength = Array.getLength(object))) {
                throw new Exception(String.format("(Field '%s') has a length mismatch %d != %d", objectField, count, arrayLength));
            }
            for (int n = 0; n < count; ++n) {
                SerializeMemory.serialize(Array.get(object, n), null, dataOutputStream);
            }
            return;
        }
        for (Field field : objectClass.getFields()) {
            int fieldModifiers = field.getModifiers();
            if ((fieldModifiers & 8) != 0) continue;
            SerializeMemory.serialize(field.get(object), field, dataOutputStream);
        }
    }

    public static void serialize(Object object, OutputStream outputStream) {
        try {
            SerializeMemory.serialize(object, null, new DataOutputStream(outputStream));
        }
        catch (Throwable o) {
            throw new RuntimeException(o.getCause());
        }
    }

    public static <T> T unserialize(Class<T> objectClass, Field objectField, DataInputStream dataInputStream) throws Throwable {
        if (objectClass == Integer.TYPE) {
            return (T)Integer.valueOf(dataInputStream.readInt());
        }
        if (objectClass == Short.TYPE) {
            return (T)Short.valueOf(dataInputStream.readShort());
        }
        if (objectClass == Float.TYPE) {
            return (T)Float.valueOf(dataInputStream.readFloat());
        }
        if (objectClass == Long.TYPE) {
            return (T)Long.valueOf(dataInputStream.readLong());
        }
        if (objectClass.isArray()) {
            ISerializeArray serializeArray = objectClass.getAnnotation(ISerializeArray.class);
            int count = serializeArray.size();
            Class<?> elementType = objectClass.getComponentType();
            Object object = Array.newInstance(objectClass, count);
            for (int n = 0; n < count; ++n) {
                Array.set(object, n, SerializeMemory.unserialize(elementType, null, dataInputStream));
            }
        }
        T object = objectClass.newInstance();
        for (Field field : objectClass.getFields()) {
            int fieldModifiers = field.getModifiers();
            if ((fieldModifiers & 8) != 0) continue;
            field.set(object, SerializeMemory.unserialize(field.get(object).getClass(), field, dataInputStream));
        }
        return object;
    }

    public static <T> T unserialize(Class<T> objectClass, InputStream inputStream) {
        try {
            return SerializeMemory.unserialize(objectClass, null, new DataInputStream(inputStream));
        }
        catch (Throwable o) {
            throw new RuntimeException(o.getCause());
        }
    }
}

