/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.pspGeListOptParam;
import jpcsp.HLE.modules150.sceGe_user;
import jpcsp.Memory;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;

public class PspGeList {
    private VideoEngine videoEngine;
    private static final int pcAddressMask = 0x3FFFFFFC;
    private Memory mem;
    public int list_addr;
    private int stall_addr;
    public int cbid;
    public int arg_addr;
    public pspGeListOptParam optParams;
    private int pc;
    private int[] stack = new int[64];
    private int stackIndex;
    public int status;
    public int id;
    public List<Integer> blockedThreadIds;
    private boolean finished;
    private boolean paused;
    private boolean ended;
    private boolean reset;
    private boolean restarted;
    private Semaphore sync;
    private IMemoryReader memoryReader;

    public PspGeList(int id) {
        this.videoEngine = VideoEngine.getInstance();
        this.mem = Memory.getInstance();
        this.id = id;
        this.blockedThreadIds = new LinkedList<Integer>();
        this.reset();
    }

    private void init() {
        this.stackIndex = 0;
        this.blockedThreadIds.clear();
        this.finished = true;
        this.paused = false;
        this.reset = true;
        this.ended = true;
        this.restarted = false;
        this.memoryReader = null;
        this.pc = 0;
    }

    public void init(int list_addr, int stall_addr, int cbid, int arg_addr) {
        this.init();
        this.list_addr = list_addr &= 0x3FFFFFFC;
        this.stall_addr = stall_addr &= 0x3FFFFFFC;
        this.cbid = cbid;
        this.arg_addr = arg_addr;
        if (Memory.isAddressGood(arg_addr)) {
            this.optParams = new pspGeListOptParam();
            this.optParams.read(this.mem, arg_addr);
        }
        this.setPc(list_addr);
        this.status = this.pc == stall_addr ? 3 : 1;
        this.finished = false;
        this.reset = false;
        this.ended = false;
        this.sync = new Semaphore(0);
    }

    public void reset() {
        this.status = 0;
        this.init();
    }

    public void pushSignalCallback(int listId, int behavior, int signal) {
        Modules.sceGe_userModule.triggerSignalCallback(this.cbid, listId, this.list_addr, behavior, signal);
    }

    public void pushFinishCallback(int listId, int arg) {
        Modules.sceGe_userModule.triggerFinishCallback(this.cbid, listId, this.list_addr, arg);
    }

    private void pushStack(int value) {
        this.stack[this.stackIndex++] = value;
    }

    private int popStack() {
        return this.stack[--this.stackIndex];
    }

    public int getAddressRel(int argument) {
        return this.mem.normalizeAddress(this.videoEngine.getBase() | argument);
    }

    public int getAddressRelOffset(int argument) {
        return this.mem.normalizeAddress((this.videoEngine.getBase() | argument) + this.videoEngine.getBaseOffset());
    }

    public boolean isStackEmpty() {
        return this.stackIndex <= 0;
    }

    public void setPc(int pc) {
        if (this.pc != (pc &= 0x3FFFFFFC)) {
            int oldPc = this.pc;
            this.pc = pc;
            this.resetMemoryReader(oldPc);
        }
    }

    public int getPc() {
        return this.pc;
    }

    public void jumpAbsolute(int argument) {
        this.setPc(this.mem.normalizeAddress(argument));
    }

    public void jumpRelative(int argument) {
        this.setPc(this.getAddressRel(argument));
    }

    public void jumpRelativeOffset(int argument) {
        this.setPc(this.getAddressRelOffset(argument));
    }

    public void callAbsolute(int argument) {
        this.pushStack(this.pc);
        this.pushStack(this.videoEngine.getBaseOffset());
        this.jumpAbsolute(argument);
    }

    public void callRelative(int argument) {
        this.pushStack(this.pc);
        this.pushStack(this.videoEngine.getBaseOffset());
        this.jumpRelative(argument);
    }

    public void callRelativeOffset(int argument) {
        this.pushStack(this.pc);
        this.pushStack(this.videoEngine.getBaseOffset());
        this.jumpRelativeOffset(argument);
    }

    public void ret() {
        if (!this.isStackEmpty()) {
            this.videoEngine.setBaseOffset(this.popStack());
            this.setPc(this.popStack());
        }
    }

    private void sync() {
        if (this.sync != null) {
            this.sync.release();
        }
    }

    public boolean waitForSync(int millis) {
        while (true) {
            try {
                int availablePermits = this.sync.drainPermits();
                if (availablePermits <= 0 && !this.sync.tryAcquire(millis, TimeUnit.MILLISECONDS)) {
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return true;
    }

    public void setStallAddr(int stall_addr) {
        if (this.stall_addr != (stall_addr &= 0x3FFFFFFC)) {
            this.stall_addr = stall_addr;
            this.sync();
        }
    }

    public int getStallAddr() {
        return this.stall_addr;
    }

    public boolean isStallReached() {
        return this.pc == this.stall_addr && this.stall_addr != 0;
    }

    public void startList() {
        this.paused = false;
        this.videoEngine.pushDrawList(this);
    }

    public void startListHead() {
        this.paused = false;
        this.videoEngine.pushDrawListHead(this);
    }

    public void pauseList() {
        this.paused = true;
    }

    public void restartList() {
        this.paused = false;
        this.restarted = true;
        this.sync();
    }

    public void clearRestart() {
        this.restarted = false;
    }

    public void clearPaused() {
        this.paused = false;
    }

    public boolean isRestarted() {
        return this.restarted;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public void finishList() {
        this.finished = true;
    }

    public void endList() {
        this.ended = this.isFinished();
    }

    public boolean isDone() {
        return this.status == 0 || this.status == 5;
    }

    public boolean isReset() {
        return this.reset;
    }

    private void resetMemoryReader(int oldPc) {
        if (this.memoryReader != null && this.pc >= oldPc) {
            this.memoryReader.skip(this.pc - oldPc >> 2);
        } else {
            this.memoryReader = MemoryReader.getMemoryReader(this.pc, 4);
        }
    }

    public void setMemoryReader(IMemoryReader memoryReader) {
        this.memoryReader = memoryReader;
    }

    public int readNextInstruction() {
        this.pc += 4;
        return this.memoryReader.readNext();
    }

    public String toString() {
        return String.format("PspGeList[id=0x%x, status=%s, list=0x%08X, pc=0x%08X, stall=0x%08X, cbid=0x%X, ended=%b, finished=%b, paused=%b, restarted=%b, reset=%b]", this.id, sceGe_user.PSP_GE_LIST_STRINGS[this.status], this.list_addr, this.pc, this.stall_addr, this.cbid, this.ended, this.finished, this.paused, this.restarted, this.reset);
    }
}

