/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;
import jpcsp.HLE.modules150.SysMemUserForUser;

public class SceKernelFplInfo
extends pspAbstractMemoryMappedStructureVariableLength {
    public final String name;
    public final int attr;
    public final int blockSize;
    public final int numBlocks;
    public int freeBlocks;
    public int numWaitThreads;
    private final SysMemUserForUser.SysMemInfo sysMemInfo;
    public final int uid;
    public final int partitionid;
    public int[] blockAddress;
    public boolean[] blockAllocated;

    private SceKernelFplInfo(String name, int partitionid, int attr, int blockSize, int numBlocks, int memType, int memAlign) {
        this.name = name;
        this.attr = attr;
        this.blockSize = blockSize;
        this.numBlocks = numBlocks;
        this.freeBlocks = numBlocks;
        this.numWaitThreads = 0;
        this.uid = SceUidManager.getNewUid("ThreadMan-Fpl");
        this.partitionid = partitionid;
        this.blockAddress = new int[numBlocks];
        this.blockAllocated = new boolean[numBlocks];
        for (int i = 0; i < numBlocks; ++i) {
            this.blockAllocated[i] = false;
        }
        int alignedBlockSize = blockSize + (memAlign - 1) & ~(memAlign - 1);
        int totalFplSize = alignedBlockSize * numBlocks;
        this.sysMemInfo = Modules.SysMemUserForUserModule.malloc(partitionid, String.format("ThreadMan-Fpl-0x%x-%s", this.uid, name), memType, totalFplSize, 0);
        if (this.sysMemInfo == null) {
            throw new RuntimeException("SceKernelFplInfo: not enough free mem");
        }
        for (int i = 0; i < numBlocks; ++i) {
            this.blockAddress[i] = this.sysMemInfo.addr + alignedBlockSize * i;
        }
    }

    public static SceKernelFplInfo tryCreateFpl(String name, int partitionid, int attr, int blockSize, int numBlocks, int memType, int memAlign) {
        SceKernelFplInfo info = null;
        int alignedBlockSize = blockSize + (memAlign - 1) & ~(memAlign - 1);
        int totalFplSize = alignedBlockSize * numBlocks;
        int maxFreeSize = Modules.SysMemUserForUserModule.maxFreeMemSize();
        if (totalFplSize <= maxFreeSize) {
            info = new SceKernelFplInfo(name, partitionid, attr, blockSize, numBlocks, memType, memAlign);
        } else {
            Modules.log.warn((Object)("tryCreateFpl not enough free mem (want=" + totalFplSize + ", free=" + maxFreeSize + ", diff=" + (totalFplSize - maxFreeSize) + ")"));
        }
        return info;
    }

    @Override
    protected void write() {
        super.write();
        this.writeStringNZ(32, this.name);
        this.write32(this.attr);
        this.write32(this.blockSize);
        this.write32(this.numBlocks);
        this.write32(this.freeBlocks);
        this.write32(this.numWaitThreads);
    }

    public boolean isBlockAllocated(int blockId) {
        return this.blockAllocated[blockId];
    }

    public void freeBlock(int blockId) {
        if (!this.isBlockAllocated(blockId)) {
            throw new IllegalArgumentException("Block " + blockId + " is not allocated");
        }
        this.blockAllocated[blockId] = false;
        ++this.freeBlocks;
    }

    public int allocateBlock(int blockId) {
        if (this.isBlockAllocated(blockId)) {
            throw new IllegalArgumentException("Block " + blockId + " is already allocated");
        }
        this.blockAllocated[blockId] = true;
        --this.freeBlocks;
        return this.blockAddress[blockId];
    }

    public int findFreeBlock() {
        for (int i = 0; i < this.numBlocks; ++i) {
            if (this.isBlockAllocated(i)) continue;
            return i;
        }
        return -1;
    }

    public int findBlockByAddress(int addr) {
        for (int i = 0; i < this.numBlocks; ++i) {
            if (this.blockAddress[i] != addr) continue;
            return i;
        }
        return -1;
    }

    public void deleteSysMemInfo() {
        Modules.SysMemUserForUserModule.free(this.sysMemInfo);
    }
}

