/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.SceKernelMsgPacket;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;
import jpcsp.Memory;

public class SceKernelMbxInfo
extends pspAbstractMemoryMappedStructureVariableLength {
    public final String name;
    public final int attr;
    public int numWaitThreads;
    private int numMessages;
    private int firstMessageAddr;
    public final int uid;
    public int lastMessageAddr;

    public SceKernelMbxInfo(String name, int attr) {
        this.name = name;
        this.attr = attr;
        this.numWaitThreads = 0;
        this.numMessages = 0;
        this.firstMessageAddr = 0;
        this.lastMessageAddr = 0;
        this.uid = SceUidManager.getNewUid("ThreadMan-Mbx");
    }

    @Override
    protected void write() {
        super.write();
        this.writeStringNZ(32, this.name);
        this.write32(this.attr);
        this.write32(this.numWaitThreads);
        this.write32(this.numMessages);
        this.write32(this.firstMessageAddr);
    }

    public int removeMsg(Memory mem) {
        int msgAddr = this.firstMessageAddr;
        if (msgAddr != 0) {
            SceKernelMsgPacket packet = new SceKernelMsgPacket();
            packet.read(mem, msgAddr);
            this.firstMessageAddr = packet.nextMsgPacketAddr;
            if (this.firstMessageAddr == 0) {
                this.lastMessageAddr = 0;
            }
            packet.nextMsgPacketAddr = 0;
            packet.write(mem);
            --this.numMessages;
        }
        return msgAddr;
    }

    private void insertMsgAfter(Memory mem, int msgAddr, int refMsgAddr) {
        SceKernelMsgPacket msgPacket = new SceKernelMsgPacket();
        msgPacket.read(mem, msgAddr);
        if (this.lastMessageAddr == 0) {
            msgPacket.nextMsgPacketAddr = 0;
            this.firstMessageAddr = msgAddr;
            this.lastMessageAddr = msgAddr;
        } else if (refMsgAddr == 0) {
            msgPacket.nextMsgPacketAddr = this.firstMessageAddr;
            this.firstMessageAddr = msgAddr;
        } else {
            SceKernelMsgPacket refMsgPacket = new SceKernelMsgPacket();
            refMsgPacket.read(mem, refMsgAddr);
            msgPacket.nextMsgPacketAddr = refMsgPacket.nextMsgPacketAddr;
            refMsgPacket.nextMsgPacketAddr = msgAddr;
            refMsgPacket.write(mem);
            if (this.lastMessageAddr == refMsgAddr) {
                this.lastMessageAddr = msgAddr;
            }
        }
        msgPacket.write(mem);
        ++this.numMessages;
    }

    public void addMsg(Memory mem, int msgAddr) {
        if (msgAddr != 0) {
            this.insertMsgAfter(mem, msgAddr, this.lastMessageAddr);
        }
    }

    public void addMsgByPriority(Memory mem, int msgAddr) {
        if (msgAddr != 0) {
            SceKernelMsgPacket msgPacket = new SceKernelMsgPacket();
            msgPacket.read(mem, msgAddr);
            SceKernelMsgPacket currentMsgPacket = new SceKernelMsgPacket();
            int currentMsgAddr = this.firstMessageAddr;
            int previousMsgAddr = 0;
            for (int i = 0; i < this.numMessages; ++i) {
                currentMsgPacket.read(mem, currentMsgAddr);
                if (msgPacket.compare(msgPacket, currentMsgPacket) < 0) break;
                previousMsgAddr = currentMsgAddr;
            }
            this.insertMsgAfter(mem, msgAddr, previousMsgAddr);
        }
    }

    public boolean hasMessage() {
        return this.firstMessageAddr != 0;
    }
}

