/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.modules150.sceNet;
import jpcsp.HLE.modules150.sceNetAdhoc;

public class pspNetMacAddress
extends pspAbstractMemoryMappedStructure {
    public final byte[] macAddress = new byte[6];

    public pspNetMacAddress() {
    }

    public pspNetMacAddress(byte[] macAddress) {
        this.setMacAddress(macAddress);
    }

    @Override
    protected void read() {
        for (int i = 0; i < this.macAddress.length; ++i) {
            this.macAddress[i] = (byte)this.read8();
        }
    }

    @Override
    protected void write() {
        for (int i = 0; i < this.macAddress.length; ++i) {
            this.write8(this.macAddress[i]);
        }
    }

    public void setMacAddress(byte[] macAddress) {
        this.setMacAddress(macAddress, 0);
    }

    public void setMacAddress(byte[] macAddress, int offset) {
        System.arraycopy(macAddress, offset, this.macAddress, 0, Math.min(macAddress.length - offset, this.macAddress.length));
    }

    @Override
    public int sizeof() {
        return this.macAddress.length;
    }

    public boolean isAnyMacAddress() {
        for (int i = 0; i < this.macAddress.length; ++i) {
            if (this.macAddress[i] == -1) continue;
            return false;
        }
        return true;
    }

    public boolean isEmptyMacAddress() {
        for (int i = 0; i < this.macAddress.length; ++i) {
            if (this.macAddress[i] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof pspNetMacAddress) {
            pspNetMacAddress macAddress = (pspNetMacAddress)object;
            return sceNetAdhoc.isSameMacAddress(macAddress.macAddress, this.macAddress);
        }
        return super.equals(object);
    }

    public boolean equals(byte[] macAddress) {
        return sceNetAdhoc.isSameMacAddress(macAddress, this.macAddress);
    }

    @Override
    public String toString() {
        if (this.getBaseAddress() == 0) {
            return sceNet.convertMacAddressToString(this.macAddress);
        }
        if (this.isEmptyMacAddress()) {
            return super.toString();
        }
        return String.format("%s(%s)", super.toString(), sceNet.convertMacAddressToString(this.macAddress));
    }
}

