/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.nio.charset.Charset;
import java.util.SortedMap;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import org.apache.log4j.Logger;

@HLELogging
public class sceCcc
extends HLEModule {
    public static Logger log = Modules.getLogger("sceCcc");
    protected static final Charset charsetUTF8 = sceCcc.getCharset("UTF-8");
    protected static final Charset charsetUTF16 = sceCcc.getCharset("UTF-16LE");
    protected static final Charset charsetSJIS = sceCcc.getCharset("Shift_JIS");
    protected int errorCharUTF8;
    protected int errorCharUTF16;
    protected int errorCharSJIS;

    @Override
    public String getName() {
        return "sceCcc";
    }

    @Override
    public void stop() {
        this.errorCharUTF8 = 0;
        this.errorCharUTF16 = 0;
        this.errorCharSJIS = 0;
        super.stop();
    }

    protected static Charset getCharset(String charsetName) {
        if (!Charset.isSupported(charsetName)) {
            log.warn((Object)String.format("Charset not supported by this JVM: %s", charsetName));
            if (log.isInfoEnabled()) {
                SortedMap<String, Charset> availableCharsets = Charset.availableCharsets();
                log.info((Object)"Supported Charsets:");
                for (String availableCharsetName : availableCharsets.keySet()) {
                    log.info((Object)availableCharsetName);
                }
            }
            return Charset.defaultCharset();
        }
        return Charset.forName(charsetName);
    }

    protected static byte[] addByteToArray(byte[] array, byte b) {
        byte[] newArray = new byte[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = b;
        return newArray;
    }

    protected static byte[] getBytesUTF16(int addr) {
        int utf16;
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(addr, 2);
        byte[] bytes = new byte[]{};
        while ((utf16 = memoryReader.readNext()) != 0) {
            bytes = sceCcc.addByteToArray(bytes, (byte)utf16);
            bytes = sceCcc.addByteToArray(bytes, (byte)(utf16 >> 8));
        }
        return bytes;
    }

    protected static String getStringUTF16(int addr) {
        return new String(sceCcc.getBytesUTF16(addr), charsetUTF16);
    }

    protected static byte[] getBytesUTF8(int addr) {
        int utf8;
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(addr, 1);
        byte[] bytes = new byte[]{};
        while ((utf8 = memoryReader.readNext()) != 0) {
            bytes = sceCcc.addByteToArray(bytes, (byte)utf8);
        }
        return bytes;
    }

    protected static String getStringUTF8(int addr) {
        return new String(sceCcc.getBytesUTF8(addr), charsetUTF8);
    }

    protected static String getStringSJIS(int addr) {
        return new String(sceCcc.getBytesUTF8(addr), charsetSJIS);
    }

    protected int writeStringBytes(byte[] bytes, int addr, int maxSize, int trailingNulls) {
        int bytesWritten = 0;
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(addr, 1);
        if (bytes != null) {
            int length = Math.min(bytes.length, maxSize - 1);
            for (int i = 0; i < length; ++i) {
                memoryWriter.writeNext(bytes[i] & 0xFF);
            }
            bytesWritten += length;
        }
        for (int i = 0; i < trailingNulls; ++i) {
            memoryWriter.writeNext(0);
        }
        memoryWriter.flush();
        return bytesWritten;
    }

    @HLEUnimplemented
    @HLEFunction(nid=13711247, version=150)
    public int sceCccUTF8toUTF16() {
        return 0;
    }

    @HLEFunction(nid=109855520, version=150)
    public int sceCccEncodeSJIS(TPointer32 dstAddr, int ucs4char) {
        char[] chars = Character.toChars(ucs4char);
        if (chars == null) {
            return 0;
        }
        String s = new String(chars);
        byte[] bytes = s.getBytes(charsetSJIS);
        int addr = dstAddr.getValue();
        int length = this.writeStringBytes(bytes, addr, 100, 0);
        dstAddr.setValue(addr + length);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceCccEncodeSJIS encoding '%s' into %d bytes", s, length));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=167832825, version=150)
    public int sceCccSwprintfSJIS() {
        return 0;
    }

    @HLEFunction(nid=400676883, version=150)
    public int sceCccSetErrorCharUTF8(int errorChar) {
        int previousErrorChar = this.errorCharUTF8;
        this.errorCharUTF8 = errorChar;
        return previousErrorChar;
    }

    @HLEUnimplemented
    @HLEFunction(nid=988566132, version=150)
    public int sceCccSwprintfUTF8() {
        return 0;
    }

    @HLEFunction(nid=1102521509, version=150)
    public int sceCccUTF16toUTF8(TPointer dstAddr, int dstSize, TPointer srcAddr) {
        String dstString = sceCcc.getStringUTF16(srcAddr.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceCccUTF16toUTF8 string='%s'", dstString));
        }
        byte[] dstBytes = dstString.getBytes(charsetUTF8);
        return this.writeStringBytes(dstBytes, dstAddr.getAddress(), dstSize, 1);
    }

    @HLEFunction(nid=1272885928, version=150)
    public int sceCccStrlenUTF16(TPointer strUTF16) {
        String str = sceCcc.getStringUTF16(strUTF16.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceCccStrlenUTF16 str='%s'", str));
        }
        return str.length();
    }

    @HLEUnimplemented
    @HLEFunction(nid=1740573977, version=150)
    public int sceCccIsValidSJIS() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1824208544, version=150)
    public int sceCccVswprintfUTF8() {
        return 0;
    }

    @HLEFunction(nid=1870851587, version=150)
    public int sceCccUTF8toSJIS(TPointer dstAddr, int dstSize, TPointer srcAddr) {
        String dstString = sceCcc.getStringUTF8(srcAddr.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceCccUTF8toSJIS string='%s'", dstString));
        }
        byte[] dstBytes = dstString.getBytes(charsetSJIS);
        return this.writeStringBytes(dstBytes, dstAddr.getAddress(), dstSize, 1);
    }

    @HLEUnimplemented
    @HLEFunction(nid=1894558224, version=150)
    public int sceCccUCStoJIS() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1994604188, version=150)
    public int sceCccIsValidUCS2() {
        return 0;
    }

    @HLEFunction(nid=-2079918999, version=150)
    public int sceCccEncodeUTF16(TPointer32 dstAddr, int ucs4char) {
        char[] chars = Character.toChars(ucs4char);
        if (chars == null) {
            return 0;
        }
        String s = new String(chars);
        byte[] bytes = s.getBytes(charsetUTF16);
        int addr = dstAddr.getValue();
        int length = this.writeStringBytes(bytes, addr, 100, 0);
        dstAddr.setValue(addr + length);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceCccEncodeUTF16 encoding '%s' into %d bytes", s, length));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1873667387, version=150)
    public int sceCccIsValidUTF8() {
        return 0;
    }

    @HLEFunction(nid=-1832888239, version=150)
    public int sceCccEncodeUTF8(TPointer32 dstAddr, int ucs4char) {
        char[] chars = Character.toChars(ucs4char);
        if (chars == null) {
            return 0;
        }
        String s = new String(chars);
        byte[] bytes = s.getBytes(charsetUTF8);
        int addr = dstAddr.getValue();
        int length = this.writeStringBytes(bytes, addr, 100, 0);
        dstAddr.setValue(addr + length);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceCccEncodeUTF8 encoding '%s' into %d bytes", s, length));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1791071216, version=150)
    public int sceCccDecodeSJIS() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1563045367, version=150)
    public int sceCccIsValidJIS() {
        return 0;
    }

    @HLEFunction(nid=-1506906496, version=150)
    public int sceCccSJIStoUTF8(TPointer dstUTF8, int dstSize, TPointer srcSJIS) {
        String str = sceCcc.getStringSJIS(srcSJIS.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceCccSJIStoUTF8 str='%s'", str));
        }
        byte[] bytesUTF8 = str.getBytes(charsetUTF8);
        return this.writeStringBytes(bytesUTF8, dstUTF8.getAddress(), dstSize, 1);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1261319233, version=150)
    public int sceCccSetTable(TPointer jis2ucs, TPointer ucs2jis) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1210859246, version=150)
    public int sceCccStrlenUTF8(TPointer strUTF8) {
        String str = sceCcc.getStringUTF16(strUTF8.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceCccStrlenUTF8 str='%s'", str));
        }
        return str.length();
    }

    @HLEFunction(nid=-1203278604, version=150)
    public int sceCccSetErrorCharUTF16(int errorChar) {
        int previousErrorChar = this.errorCharUTF16;
        this.errorCharUTF16 = errorChar;
        return previousErrorChar;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1122898189, version=150)
    public int sceCccIsValidUnicode() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1111173479, version=150)
    public int sceCccVswprintfSJIS() {
        return 0;
    }

    @HLEFunction(nid=-1095470556, version=150)
    public int sceCccSJIStoUTF16(TPointer dstUTF16, int dstSize, TPointer srcSJIS) {
        String str = sceCcc.getStringSJIS(srcSJIS.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceCccSJIStoUTF16 str='%s'", str));
        }
        byte[] bytesUTF16 = str.getBytes(charsetUTF16);
        return this.writeStringBytes(bytesUTF16, dstUTF16.getAddress(), dstSize, 2);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-982955603, version=150)
    public int sceCccSetErrorCharSJIS(int errorChar) {
        int previousErrorChar = this.errorCharSJIS;
        this.errorCharSJIS = errorChar;
        return previousErrorChar;
    }

    @HLEFunction(nid=-962019614, version=150)
    public int sceCccDecodeUTF8(TPointer32 srcAddrUTF8) {
        String srcString = sceCcc.getStringUTF8(srcAddrUTF8.getValue());
        int codePoint = srcString.codePointAt(0);
        int codePointSize = Character.charCount(codePoint);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceCccDecodeUTF8 string='%s'(0x%08X), codePoint=0x%X(size=%d)", srcString, srcAddrUTF8.getValue(), codePoint, codePointSize));
        }
        srcAddrUTF8.setValue(srcAddrUTF8.getValue() + codePointSize);
        return codePoint;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-871724070, version=150)
    public int sceCccIsValidUTF16() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-760118139, version=150)
    public int sceCccIsValidUCS4() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-650564405, version=150)
    public int sceCccStrlenSJIS(TPointer strSJIS) {
        String str = sceCcc.getStringUTF16(strSJIS.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceCccStrlenSJIS str='%s'", str));
        }
        return str.length();
    }

    @HLEFunction(nid=-523272047, version=150)
    public int sceCccDecodeUTF16(TPointer32 srcAddrUTF16) {
        String srcString = sceCcc.getStringUTF16(srcAddrUTF16.getValue());
        int codePoint = srcString.codePointAt(0);
        int codePointSize = Character.charCount(codePoint);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceCccDecodeUTF16 string='%s'(0x%08X), codePoint=0x%X(size=%d)", srcString, srcAddrUTF16.getValue(), codePoint, codePointSize));
        }
        srcAddrUTF16.setValue(srcAddrUTF16.getValue() + (codePointSize << 1));
        return codePoint;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-239649518, version=150)
    public int sceCccUTF16toSJIS() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-76003614, version=150)
    public int sceCccJIStoUCS() {
        return 0;
    }
}

