/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.PspGeList;
import jpcsp.HLE.kernel.types.SceKernelCallbackInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.kernel.types.interrupts.GeCallbackInterruptHandler;
import jpcsp.HLE.kernel.types.interrupts.GeInterruptHandler;
import jpcsp.HLE.kernel.types.pspGeCallbackData;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.graphics.VideoEngine;
import org.apache.log4j.Logger;

public class sceGe_user
extends HLEModule {
    public static Logger log = Modules.getLogger("sceGe_user");
    public volatile boolean waitingForSync;
    public volatile boolean syncDone;
    private HashMap<Integer, SceKernelCallbackInfo> signalCallbacks;
    private HashMap<Integer, SceKernelCallbackInfo> finishCallbacks;
    private static final String geCallbackPurpose = "sceGeCallback";
    private static final int NUMBER_GE_LISTS = 64;
    private PspGeList[] allGeLists;
    private ConcurrentLinkedQueue<PspGeList> listFreeQueue;
    private ConcurrentLinkedQueue<Integer> deferredThreadWakeupQueue;
    public static final int PSP_GE_LIST_DONE = 0;
    public static final int PSP_GE_LIST_QUEUED = 1;
    public static final int PSP_GE_LIST_DRAWING = 2;
    public static final int PSP_GE_LIST_STALL_REACHED = 3;
    public static final int PSP_GE_LIST_END_REACHED = 4;
    public static final int PSP_GE_LIST_CANCEL_DONE = 5;
    public static final String[] PSP_GE_LIST_STRINGS = new String[]{"PSP_GE_LIST_DONE", "PSP_GE_LIST_QUEUED", "PSP_GE_LIST_DRAWING", "PSP_GE_LIST_STALL_REACHED", "PSP_GE_LIST_END_REACHED", "PSP_GE_LIST_CANCEL_DONE"};
    public static final int PSP_GE_SIGNAL_HANDLER_SUSPEND = 1;
    public static final int PSP_GE_SIGNAL_HANDLER_CONTINUE = 2;
    public static final int PSP_GE_SIGNAL_HANDLER_PAUSE = 3;
    public static final int PSP_GE_SIGNAL_SYNC = 8;
    public static final int PSP_GE_SIGNAL_JUMP = 16;
    public static final int PSP_GE_SIGNAL_CALL = 17;
    public static final int PSP_GE_SIGNAL_RETURN = 18;
    public static final int PSP_GE_SIGNAL_TBP0_REL = 32;
    public static final int PSP_GE_SIGNAL_TBP1_REL = 33;
    public static final int PSP_GE_SIGNAL_TBP2_REL = 34;
    public static final int PSP_GE_SIGNAL_TBP3_REL = 35;
    public static final int PSP_GE_SIGNAL_TBP4_REL = 36;
    public static final int PSP_GE_SIGNAL_TBP5_REL = 37;
    public static final int PSP_GE_SIGNAL_TBP6_REL = 38;
    public static final int PSP_GE_SIGNAL_TBP7_REL = 39;
    public static final int PSP_GE_SIGNAL_TBP0_REL_OFFSET = 40;
    public static final int PSP_GE_SIGNAL_TBP1_REL_OFFSET = 41;
    public static final int PSP_GE_SIGNAL_TBP2_REL_OFFSET = 42;
    public static final int PSP_GE_SIGNAL_TBP3_REL_OFFSET = 43;
    public static final int PSP_GE_SIGNAL_TBP4_REL_OFFSET = 44;
    public static final int PSP_GE_SIGNAL_TBP5_REL_OFFSET = 45;
    public static final int PSP_GE_SIGNAL_TBP6_REL_OFFSET = 46;
    public static final int PSP_GE_SIGNAL_TBP7_REL_OFFSET = 47;
    public static final int PSP_GE_SIGNAL_BREAK = 255;
    public static final int PSP_GE_MATRIX_BONE0 = 0;
    public static final int PSP_GE_MATRIX_BONE1 = 1;
    public static final int PSP_GE_MATRIX_BONE2 = 2;
    public static final int PSP_GE_MATRIX_BONE3 = 3;
    public static final int PSP_GE_MATRIX_BONE4 = 4;
    public static final int PSP_GE_MATRIX_BONE5 = 5;
    public static final int PSP_GE_MATRIX_BONE6 = 6;
    public static final int PSP_GE_MATRIX_BONE7 = 7;
    public static final int PSP_GE_MATRIX_WORLD = 8;
    public static final int PSP_GE_MATRIX_VIEW = 9;
    public static final int PSP_GE_MATRIX_PROJECTION = 10;
    public static final int PSP_GE_MATRIX_TEXGEN = 11;
    public int eDRAMMemoryWidth;

    @Override
    public String getName() {
        return "sceGe_user";
    }

    @Override
    public void start() {
        this.waitingForSync = false;
        this.syncDone = false;
        this.signalCallbacks = new HashMap();
        this.finishCallbacks = new HashMap();
        this.listFreeQueue = new ConcurrentLinkedQueue();
        this.allGeLists = new PspGeList[64];
        for (int i = 0; i < 64; ++i) {
            this.allGeLists[i] = new PspGeList(i);
            this.listFreeQueue.add(this.allGeLists[i]);
        }
        this.deferredThreadWakeupQueue = new ConcurrentLinkedQueue();
        this.eDRAMMemoryWidth = 1024;
        super.start();
    }

    public void step() {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        Integer thid = this.deferredThreadWakeupQueue.poll();
        while (thid != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("really waking thread " + Integer.toHexString(thid) + "(" + threadMan.getThreadName(thid) + ")"));
            }
            threadMan.hleUnblockThread(thid);
            thid = this.deferredThreadWakeupQueue.poll();
        }
    }

    private void triggerAsyncCallback(int cbid, int listId, int listAddr, int behavior, int signalId, HashMap<Integer, SceKernelCallbackInfo> callbacks) {
        SceKernelCallbackInfo callback = callbacks.get(cbid);
        if (callback != null && callback.callback_addr != 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Scheduling Async Callback %s, listId=0x%X, behavior=%d, signalId=0x%X", callback.toString(), listId, behavior, signalId));
            }
            GeCallbackInterruptHandler geCallbackInterruptHandler = new GeCallbackInterruptHandler(callback.callback_addr, callback.callback_arg_addr, listAddr);
            GeInterruptHandler geInterruptHandler = new GeInterruptHandler(geCallbackInterruptHandler, listId, behavior, signalId);
            Emulator.getScheduler().addAction(geInterruptHandler);
        } else {
            this.hleGeOnAfterCallback(listId, behavior, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockCurrentThreadOnList(PspGeList list, IAction action) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean blockCurrentThread = false;
        boolean executeAction = false;
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            int currentThreadId = threadMan.getCurrentThreadID();
            if (list.isDone()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("blockCurrentThreadOnList not blocking thread " + Integer.toHexString(currentThreadId) + ", list completed " + list));
                }
                executeAction = true;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("blockCurrentThreadOnList blocking thread " + Integer.toHexString(currentThreadId) + " on list " + list));
                }
                list.blockedThreadIds.add(currentThreadId);
                blockCurrentThread = true;
            }
        }
        if (executeAction && action != null) {
            action.execute();
        }
        if (blockCurrentThread) {
            threadMan.hleBlockCurrentThread(action, new ListSyncWaitStateChecker(list));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hleGeAfterDrawSyncAction() {
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            for (int i = 0; i < 64; ++i) {
                if (this.allGeLists[i].status != 0) continue;
                this.allGeLists[i].reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hleGeListSyncDone(PspGeList list) {
        if (log.isDebugEnabled()) {
            String msg = "hleGeListSyncDone list " + list;
            msg = list.isDone() ? msg + ", done" : msg + ", NOT done";
            if (list.blockedThreadIds.size() > 0 && list.status != 4) {
                msg = msg + ", waking thread";
                for (int threadId : list.blockedThreadIds) {
                    msg = msg + " " + Integer.toHexString(threadId);
                }
            }
            log.debug((Object)msg);
        }
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            if (list.blockedThreadIds.size() > 0 && list.status != 4) {
                this.deferredThreadWakeupQueue.addAll(list.blockedThreadIds);
            }
            if (list.isDone()) {
                this.listFreeQueue.add(list);
            }
        }
    }

    public void hleGeOnAfterCallback(int listId, int behavior, boolean hasCallback) {
        if (!(behavior != 2 && behavior != 1 && hasCallback || listId < 0 || listId >= 64)) {
            PspGeList list = this.allGeLists[listId];
            if (log.isDebugEnabled()) {
                log.debug((Object)("hleGeOnAfterCallback restarting list " + list));
            }
            list.restartList();
        }
    }

    private void startGeList(PspGeList list) {
        list.startList();
        Modules.sceDisplayModule.setGeDirty(true);
    }

    private void startGeListHead(PspGeList list) {
        list.startListHead();
        Modules.sceDisplayModule.setGeDirty(true);
    }

    public void triggerFinishCallback(int cbid, int listId, int listAddr, int callbackNotifyArg1) {
        this.triggerAsyncCallback(cbid, listId, listAddr, 1, callbackNotifyArg1, this.finishCallbacks);
    }

    public void triggerSignalCallback(int cbid, int listId, int listAddr, int behavior, int callbackNotifyArg1) {
        this.triggerAsyncCallback(cbid, listId, listAddr, behavior, callbackNotifyArg1, this.signalCallbacks);
    }

    public int checkListId(int id) {
        if (id < 0 || id >= 64) {
            throw new SceKernelErrorException(-2147483392);
        }
        return id;
    }

    public int checkMode(int mode) {
        if (mode < 0 || mode > 1) {
            throw new SceKernelErrorException(-2147483385);
        }
        return mode;
    }

    @HLEFunction(nid=526865069, version=150)
    public int sceGeEdramGetSize() {
        return 0x200000;
    }

    @HLEFunction(nid=-461487900, version=150)
    public int sceGeEdramGetAddr() {
        return 0x4000000;
    }

    @HLEFunction(nid=-1216805398, version=150)
    public int sceGeEdramSetAddrTranslation(int size) {
        int previousWidth = this.eDRAMMemoryWidth;
        this.eDRAMMemoryWidth = size;
        return previousWidth;
    }

    @HLEFunction(nid=-594292753, version=150)
    public int sceGeGetCmd(int cmd) {
        VideoEngine ve = VideoEngine.getInstance();
        int value = ve.getCommandValue(cmd);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("sceGeGetCmd %s: cmd=0x%X, value=0x%06X", ve.commandToString(cmd).toUpperCase(), cmd, value));
        }
        return value;
    }

    @HLEFunction(nid=1472762971, version=150)
    public int sceGeGetMtx(int mtxType, TPointer mtxAddr) {
        VideoEngine ve = VideoEngine.getInstance();
        float[] mtx = ve.getMatrix(mtxType);
        if (mtx == null) {
            log.warn((Object)String.format("sceGeGetMtx invalid type mtxType=%d", mtxType));
            return -1;
        }
        for (int i = 0; i < mtx.length; ++i) {
            mtxAddr.setFloat(i << 2, mtx[i]);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("sceGeGetMtx mtxType=%d, mtxAddr=%s, mtx=%s", mtxType, mtxAddr, mtx));
        }
        return 0;
    }

    @HLEFunction(nid=1133131866, version=150)
    public int sceGeSaveContext(TPointer contextAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGeSaveContext contextAddr=%s", contextAddr));
        }
        VideoEngine.getInstance().hleSaveContext(contextAddr.getAddress());
        return 0;
    }

    @HLEFunction(nid=200673531, version=150)
    public int sceGeRestoreContext(TPointer contextAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGeRestoreContext contextAddr=%s", contextAddr));
        }
        VideoEngine.getInstance().hleRestoreContext(contextAddr.getAddress());
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HLEFunction(nid=-1421219990, version=150)
    public int sceGeListEnQueue(TPointer listAddr, @CanBeNull TPointer stallAddr, int cbid, @CanBeNull TPointer argAddr) {
        int result;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGeListEnQueue(list=%s, stall=%s, cbid=0x%X, arg=%s)", listAddr, stallAddr, cbid, argAddr));
        }
        if (VideoEngine.getInstance().hasDrawList(listAddr.getAddress())) {
            log.warn((Object)"sceGeListEnQueue can't enqueue duplicate list address");
            throw new SceKernelErrorException(-2147483615);
        }
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            PspGeList list = this.listFreeQueue.poll();
            if (list == null) {
                log.warn((Object)"sceGeListEnQueue no more free list available!");
                throw new SceKernelErrorException(-2147483614);
            }
            list.init(listAddr.getAddress(), stallAddr.getAddress(), cbid, argAddr.getAddress());
            this.startGeList(list);
            result = list.id;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGeListEnQueue returning 0x%X", result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HLEFunction(nid=470652326, version=150)
    public int sceGeListEnQueueHead(TPointer listAddr, @CanBeNull TPointer stallAddr, int cbid, @CanBeNull TPointer argAddr) {
        int result;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGeListEnQueueHead(list=%s, stall=%s, cbid=0x%X, arg=%s)", listAddr, stallAddr, cbid, argAddr));
        }
        if (VideoEngine.getInstance().hasDrawList(listAddr.getAddress())) {
            log.warn((Object)"sceGeListEnQueueHead can't enqueue duplicate list address");
            throw new SceKernelErrorException(-2147483615);
        }
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            PspGeList list = this.listFreeQueue.poll();
            if (list == null) {
                log.warn((Object)"sceGeListEnQueueHead no more free list available!");
                throw new SceKernelErrorException(-2147483614);
            }
            list.init(listAddr.getAddress(), stallAddr.getAddress(), cbid, argAddr.getAddress());
            this.startGeListHead(list);
            result = list.id;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGeListEnQueueHead returning 0x%X", result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HLEFunction(nid=1605921456, version=150)
    public int sceGeListDeQueue(@CheckArgument(value="checkListId") int id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGeListDeQueue(id=0x%X)", id));
        }
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            PspGeList list = this.allGeLists[id];
            list.reset();
            if (!this.listFreeQueue.contains(list)) {
                this.listFreeQueue.add(list);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HLEFunction(nid=-522813112, version=150)
    public int sceGeListUpdateStallAddr(@CheckArgument(value="checkListId") int id, @CanBeNull TPointer stallAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGeListUpdateStallAddr(id=0x%X, stall=%s)", id, stallAddr));
        }
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            PspGeList list = this.allGeLists[id];
            if (list.getStallAddr() != stallAddr.getAddress()) {
                list.setStallAddr(stallAddr.getAddress());
                Modules.sceDisplayModule.setGeDirty(true);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HLEFunction(nid=54808244, version=150)
    public int sceGeListSync(@CheckArgument(value="checkListId") int id, @CheckArgument(value="checkMode") int mode) {
        int result;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGeListSync(id=0x%X, mode=%d)", id, mode));
        }
        if (mode == 0 && IntrManager.getInstance().isInsideInterrupt()) {
            log.debug((Object)"sceGeListSync (mode==0) cannot be called inside an interrupt handler!");
            throw new SceKernelErrorException(-2147352476);
        }
        PspGeList list = null;
        boolean blockCurrentThread = false;
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            list = this.allGeLists[id];
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceGeListSync on list: %s", list));
            }
            if (list.isReset()) {
                throw new SceKernelErrorException(-2147483392);
            }
            if (mode == 0 && !list.isDone()) {
                result = 0;
                blockCurrentThread = true;
            } else {
                result = list.status;
            }
        }
        if (blockCurrentThread) {
            this.blockCurrentThreadOnList(list, null);
        }
        return result;
    }

    @HLEFunction(nid=-1299727007, version=150)
    public int sceGeDrawSync(@CheckArgument(value="checkMode") int mode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGeDrawSync mode=%d", mode));
        }
        if (mode == 0 && IntrManager.getInstance().isInsideInterrupt()) {
            log.debug((Object)"sceGeDrawSync (mode==0) cannot be called inside an interrupt handler!");
            throw new SceKernelErrorException(-2147352476);
        }
        int result = 0;
        if (mode == 0) {
            PspGeList lastList = VideoEngine.getInstance().getLastDrawList();
            if (lastList != null) {
                this.blockCurrentThreadOnList(lastList, new HLEAfterDrawSyncAction());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceGeDrawSync all lists completed, not waiting");
                }
                this.hleGeAfterDrawSyncAction();
                Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
            }
        } else if (mode == 1) {
            PspGeList currentList = VideoEngine.getInstance().getFirstDrawList();
            if (currentList != null) {
                result = currentList.status;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceGeDrawSync mode=%d, returning %d", mode, result));
            }
        }
        return result;
    }

    @HLEFunction(nid=-1270289395, version=150)
    public int sceGeBreak(@CheckArgument(value="checkMode") int mode, TPointer brk_addr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGeBreak mode=%d, brk_addr=%s", mode, brk_addr));
        }
        int result = 0;
        PspGeList list = VideoEngine.getInstance().getCurrentList();
        if (mode == 0) {
            if (list != null) {
                list.pauseList();
                result = list.id;
            }
        } else if (mode == 1 && list != null) {
            list.pauseList();
            for (int i = 0; i < 64; ++i) {
                this.allGeLists[i].status = 5;
            }
            result = list.id;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HLEFunction(nid=1275520114, version=150)
    public int sceGeContinue() {
        PspGeList list;
        Memory mem = Memory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceGeContinue()");
        }
        if ((list = VideoEngine.getInstance().getCurrentList()) != null) {
            sceGe_user sceGe_user2 = this;
            synchronized (sceGe_user2) {
                if (list.status == 4 && mem.read32(list.getPc()) == 0xF000000 && mem.read32(list.getPc() + 4) == 0xC000000) {
                    list.readNextInstruction();
                    list.readNextInstruction();
                }
                list.restartList();
            }
        }
        return 0;
    }

    @HLEFunction(nid=-1526987100, version=150, checkInsideInterrupt=true)
    public int sceGeSetCallback(TPointer cbdata_addr) {
        pspGeCallbackData cbdata = new pspGeCallbackData();
        cbdata.read(Emulator.getMemory(), cbdata_addr.getAddress());
        int cbid = SceUidManager.getNewId(geCallbackPurpose, 0, 15);
        if (cbid == Integer.MIN_VALUE) {
            log.warn((Object)String.format("sceGeSetCallback no more callback ID available", new Object[0]));
            return -2147483614;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGeSetCallback signalFunc=0x%08X, signalArg=0x%08X, finishFunc=0x%08X, finishArg=0x%08X, result cbid=0x%X", cbdata.signalFunction, cbdata.signalArgument, cbdata.finishFunction, cbdata.finishArgument, cbid));
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelCallbackInfo callbackSignal = threadMan.hleKernelCreateCallback("GeCallbackSignal", cbdata.signalFunction, cbdata.signalArgument);
        SceKernelCallbackInfo callbackFinish = threadMan.hleKernelCreateCallback("GeCallbackFinish", cbdata.finishFunction, cbdata.finishArgument);
        this.signalCallbacks.put(cbid, callbackSignal);
        this.finishCallbacks.put(cbid, callbackFinish);
        return cbid;
    }

    @HLEFunction(nid=98247374, version=150, checkInsideInterrupt=true)
    public int sceGeUnsetCallback(int cbid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGeUnsetCallback cbid=0x%X", cbid));
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelCallbackInfo callbackSignal = this.signalCallbacks.remove(cbid);
        SceKernelCallbackInfo callbackFinish = this.finishCallbacks.remove(cbid);
        if (callbackSignal != null) {
            threadMan.hleKernelDeleteCallback(callbackSignal.uid);
        }
        if (callbackFinish != null) {
            threadMan.hleKernelDeleteCallback(callbackFinish.uid);
        }
        SceUidManager.releaseId(cbid, geCallbackPurpose);
        return 0;
    }

    private static class ListSyncWaitStateChecker
    implements IWaitStateChecker {
        private PspGeList list;

        public ListSyncWaitStateChecker(PspGeList list) {
            this.list = list;
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            return !this.list.isDone();
        }
    }

    private class HLEAfterDrawSyncAction
    implements IAction {
        private HLEAfterDrawSyncAction() {
        }

        @Override
        public void execute() {
            sceGe_user.this.hleGeAfterDrawSyncAction();
        }
    }

    static class DeferredCallbackInfo {
        public final int cbid;
        public final int callbackIndex;
        public final int listId;
        public final int behavior;
        public final int callbackNotifyArg1;

        public DeferredCallbackInfo(int cbid, int callbackIndex, int callbackNotifyArg1) {
            this.cbid = cbid;
            this.callbackIndex = callbackIndex;
            this.listId = -1;
            this.behavior = 1;
            this.callbackNotifyArg1 = callbackNotifyArg1;
        }

        public DeferredCallbackInfo(int cbid, int callbackIndex, int listId, int behavior, int callbackNotifyArg1) {
            this.cbid = cbid;
            this.callbackIndex = callbackIndex;
            this.listId = listId;
            this.behavior = behavior;
            this.callbackNotifyArg1 = callbackNotifyArg1;
        }
    }
}

